/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONObject;

public abstract class BaseBuild
implements Build {
    protected int buildNumber = -1;
    protected String jobName;
    protected String master;
    protected String result;
    protected long statusModifiedTime;
    private static final Pattern _buildURLPattern = Pattern.compile("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/(?<buildNumber>\\d+)/?");
    private String _status;

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public String getBuildURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null || this.buildNumber == -1) {
            return null;
        }
        return jobURL + this.buildNumber + "/";
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getJobURL() {
        if (this.master == null || this.jobName == null) {
            return null;
        }
        return "http://" + this.master + "/job/" + this.jobName + "/";
    }

    @Override
    public String getMaster() {
        return this.master;
    }

    @Override
    public String getResult() {
        if (!this._status.equals("completed")) {
            throw new IllegalStateException("Build not completed");
        }
        String buildURL = this.getBuildURL();
        if (this.result == null && buildURL != null) {
            try {
                JSONObject resultJSONObject = JenkinsResultsParserUtil.toJSONObject(buildURL + "api/json?tree=result");
                this.result = resultJSONObject.optString("result");
                if (this.result.equals("")) {
                    this.result = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.result;
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public long getStatusAge() {
        return System.currentTimeMillis() - this.statusModifiedTime;
    }

    protected static String decodeURL(String url) {
        url = url.replace("%28", "(");
        url = url.replace("%29", ")");
        url = url.replace("%5B", "[");
        url = url.replace("%5D", "]");
        return url;
    }

    protected BaseBuild() {
        this.setStatus("starting");
    }

    protected BaseBuild(String buildURL) throws Exception {
        this.setBuildURL(buildURL);
    }

    protected void setBuildURL(String buildURL) throws Exception {
        Matcher matcher = _buildURLPattern.matcher(buildURL = BaseBuild.decodeURL(buildURL));
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid build URL " + buildURL);
        }
        this.buildNumber = Integer.parseInt(matcher.group("buildNumber"));
        this.jobName = matcher.group("jobName");
        this.master = matcher.group("master");
        this.update();
    }

    protected void setStatus(String status) {
        if (status == null && this._status != null || !status.equals(this._status)) {
            this._status = status;
            this.statusModifiedTime = System.currentTimeMillis();
        }
    }
}

