/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class DownstreamBuild
extends BaseBuild {
    protected List<Integer> badBuildNumbers = new ArrayList<Integer>();
    protected String invocationURL;
    protected Map<String, String> parameters;
    protected TopLevelBuild topLevelBuild;
    private static final Pattern _invocationURLPattern = Pattern.compile("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/buildWithParameters\\?(?<queryString>.*)");

    public DownstreamBuild(String invocationURL, TopLevelBuild topLevelBuild) throws Exception {
        this.topLevelBuild = topLevelBuild;
        Matcher invocationURLMatcher = _invocationURLPattern.matcher(invocationURL);
        if (!invocationURLMatcher.find()) {
            throw new IllegalArgumentException("Invalid invocation URL");
        }
        this.jobName = invocationURLMatcher.group("jobName");
        this.master = invocationURLMatcher.group("master");
        String queryString = invocationURLMatcher.group("queryString");
        Map<String, String> invokedParameters = this.getParameters(queryString);
        Set<String> parameterNames = this.getParameterNames();
        this.parameters = new HashMap<String, String>();
        for (String parameterName : parameterNames) {
            if (invokedParameters.containsKey(parameterName)) {
                this.parameters.put(parameterName, invokedParameters.get(parameterName));
                continue;
            }
            this.parameters.put(parameterName, "");
        }
        this.invocationURL = invocationURL;
    }

    public String getInvocationURL() {
        return this.invocationURL;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public TopLevelBuild getTopLevelBuild() {
        return this.topLevelBuild;
    }

    public void reinvoke() throws Exception {
        this.badBuildNumbers.add(this.buildNumber);
        this.buildNumber = -1;
        this.result = null;
        this.setStatus("starting");
        JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(this.invocationURL));
        System.out.println("Reinvoked: " + this.invocationURL);
    }

    @Override
    public void update() throws Exception {
        JSONObject completedBuildJSONObject;
        String status = this.getStatus();
        if (status.equals("completed")) {
            return;
        }
        if (status.equals("missing") || status.equals("queued") || status.equals("starting")) {
            JSONObject buildJSONObject = this.getRunningBuildJSONObject();
            if (buildJSONObject != null) {
                this.buildNumber = buildJSONObject.getInt("number");
                this.setStatus("running");
                System.out.println(this._getBuildMessage());
            } else {
                JSONObject queueItemJSONObject = this.getQueueItemJSONObject();
                if (status.equals("started") && queueItemJSONObject != null) {
                    this.setStatus("queued");
                } else if (status.equals("queued") && queueItemJSONObject == null) {
                    this.setStatus("missing");
                    System.out.println(this._getBuildMessage());
                }
            }
        }
        if ((status = this.getStatus()).equals("running") && (completedBuildJSONObject = this.getCompletedBuildJSONObject()) != null) {
            this.result = completedBuildJSONObject.getString("result");
            this.setStatus("completed");
        }
    }

    protected JSONObject getBuildJSONObject() throws Exception {
        return JenkinsResultsParserUtil.toJSONObject(this.getBuildURL() + "/api/json?tree=building,duration,result,url", false);
    }

    protected JSONArray getBuildsJSONArray() throws Exception {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getJobURL() + "/api/json?tree=builds[actions[parameters" + "[name,type,value]],building,duration,number,result,url]", false);
        return jsonObject.getJSONArray("builds");
    }

    protected JSONObject getCompletedBuildJSONObject() throws Exception {
        JSONObject buildJSONObject = this.getBuildJSONObject();
        if (buildJSONObject.get("result") != null && !buildJSONObject.getBoolean("building")) {
            return buildJSONObject;
        }
        return null;
    }

    protected Set<String> getParameterNames() throws Exception {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getJobURL() + "/api/json?tree=actions[parameterDefinitions" + "[name,type,value]]");
        JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
        JSONObject firstActionJSONObject = actionsJSONArray.getJSONObject(0);
        JSONArray parameterDefinitionsJSONArray = firstActionJSONObject.getJSONArray("parameterDefinitions");
        HashSet<String> parameterNames = new HashSet<String>(parameterDefinitionsJSONArray.length());
        for (int i = 0; i < parameterDefinitionsJSONArray.length(); ++i) {
            JSONObject parameterDefinitionJSONObject = parameterDefinitionsJSONArray.getJSONObject(i);
            String type = parameterDefinitionJSONObject.getString("type");
            if (!type.equals("StringParameterDefinition")) continue;
            parameterNames.add(parameterDefinitionJSONObject.getString("name"));
        }
        return parameterNames;
    }

    protected Map<String, String> getParameters(JSONArray jsonArray) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!(jsonObject.opt("value") instanceof String)) continue;
            String name = jsonObject.getString("name");
            String value = jsonObject.getString("value");
            parameters.put(name, value);
        }
        return parameters;
    }

    protected Map<String, String> getParameters(JSONObject buildJSONObject) throws Exception {
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            return new HashMap<String, String>();
        }
        JSONObject jsonObject = actionsJSONArray.getJSONObject(0);
        if (jsonObject.has("parameters")) {
            JSONArray parametersJSONArray = jsonObject.getJSONArray("parameters");
            return this.getParameters(parametersJSONArray);
        }
        return new HashMap<String, String>();
    }

    protected Map<String, String> getParameters(String queryString) throws UnsupportedEncodingException {
        if (!queryString.contains("=")) {
            return Collections.emptyMap();
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (String parameter : queryString.split("&")) {
            if (!parameter.contains("=")) continue;
            String[] parameterParts = parameter.split("=");
            String name = URLDecoder.decode(parameterParts[0], "UTF-8");
            String value = URLDecoder.decode(parameterParts[1], "UTF-8");
            parameters.put(name, value);
        }
        return parameters;
    }

    protected JSONObject getQueueItemJSONObject() throws Exception {
        JSONArray queueItemsJSONArray = this.getQueueItemsJSONArray();
        for (int i = 0; i < queueItemsJSONArray.length(); ++i) {
            JSONObject queueItemJSONObject = queueItemsJSONArray.getJSONObject(i);
            JSONObject taskJSONObject = queueItemJSONObject.getJSONObject("task");
            String queueItemName = taskJSONObject.getString("name");
            if (!queueItemName.equals(this.jobName) || !this.parameters.equals(this.getParameters(queueItemJSONObject))) continue;
            return queueItemJSONObject;
        }
        return null;
    }

    protected JSONArray getQueueItemsJSONArray() throws Exception {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject("http://" + this.master + "/queue/api/json?tree=items[actions[parameters" + "[name,value]],task[name,url]]", false);
        return jsonObject.getJSONArray("items");
    }

    protected JSONObject getRunningBuildJSONObject() throws Exception {
        JSONArray buildsJSONArray = this.getBuildsJSONArray();
        for (int i = 0; i < buildsJSONArray.length(); ++i) {
            JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
            if (!this.parameters.equals(this.getParameters(buildJSONObject)) || this.badBuildNumbers.contains(buildJSONObject.getInt("number"))) continue;
            return buildJSONObject;
        }
        return null;
    }

    private String _getBuildMessage() {
        String status = this.getStatus();
        StringBuilder sb = new StringBuilder();
        sb.append("Build '");
        sb.append(this.jobName);
        sb.append("'");
        if (status.equals("completed")) {
            sb.append(" completed at ");
            sb.append(this.getBuildURL());
            sb.append(". ");
            sb.append(this.getResult());
            return sb.toString();
        }
        if (status.equals("missing")) {
            sb.append(" is missing ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("queued")) {
            sb.append(" is queued at ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("running")) {
            sb.append(" started at ");
            sb.append(this.getBuildURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("starting")) {
            sb.append(" invoked at ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        throw new RuntimeException("Unknown status: " + status + ".");
    }
}

