/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FilePropagator {
    private final List<String> _busySlaves = new ArrayList<String>();
    private final List<String> _errorSlaves = new ArrayList<String>();
    private final List<FilePropagatorTask> _filePropagatorTasks = new ArrayList<FilePropagatorTask>();
    private final List<String> _mirrorSlaves = new ArrayList<String>();
    private final List<String> _targetSlaves = new ArrayList<String>();
    private int _threadsCompletedCount;
    private long _threadsDurationTotal;

    public FilePropagator(String[] fileNames, String sourceDirName, String targetDirName, List<String> targetSlaves) {
        for (String fileName : fileNames) {
            this._filePropagatorTasks.add(new FilePropagatorTask(sourceDirName + "/" + fileName, targetDirName + "/" + fileName));
        }
        this._targetSlaves.addAll(targetSlaves);
        this._copyFromSource();
    }

    public long getAverageThreadDuration() {
        if (this._threadsCompletedCount == 0) {
            return 0L;
        }
        return this._threadsDurationTotal / (long)this._threadsCompletedCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int threadCount) {
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        System.out.println("File propagation starting with " + threadCount + " threads.");
        try {
            long start = System.currentTimeMillis();
            while (!this._targetSlaves.isEmpty() || !this._busySlaves.isEmpty()) {
                FilePropagator filePropagator = this;
                synchronized (filePropagator) {
                    for (String mirrorSlave : this._mirrorSlaves) {
                        if (this._targetSlaves.isEmpty()) break;
                        String targetSlave = this._targetSlaves.remove(0);
                        executorService.execute(new FilePropagatorThread(this, mirrorSlave, targetSlave));
                        this._busySlaves.add(mirrorSlave);
                        this._busySlaves.add(targetSlave);
                    }
                    this._mirrorSlaves.removeAll(this._busySlaves);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("Average thread duration: ");
                sb.append(this.getAverageThreadDuration());
                sb.append("ms\nBusy slaves:");
                sb.append(this._busySlaves.size());
                sb.append("\nMirror slaves:");
                sb.append(this._mirrorSlaves.size());
                sb.append("\nTarget slaves:");
                sb.append(this._targetSlaves.size());
                sb.append("\nTotal duration: ");
                sb.append(System.currentTimeMillis() - start);
                sb.append("\n");
                System.out.println(sb.toString());
                JenkinsResultsParserUtil.sleep(5000L);
            }
            System.out.println("File propagation completed in " + (System.currentTimeMillis() - start) + "ms.");
            if (!this._errorSlaves.isEmpty()) {
                System.out.println(this._errorSlaves.size() + " slaves failed to respond:\n" + this._errorSlaves);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private static String _readInputStream(InputStream inputStream) {
        try {
            StringBuffer sb = new StringBuffer();
            byte[] bytes = new byte[1024];
            int size = inputStream.read(bytes);
            while (size > 0) {
                sb.append(new String(Arrays.copyOf(bytes, size)));
                size = inputStream.read(bytes);
            }
            return sb.toString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private void _copyFromSource() {
        ArrayList<String> commands = new ArrayList<String>();
        String targetSlave = null;
        for (FilePropagatorTask filePropagatorTask : this._filePropagatorTasks) {
            targetSlave = this._targetSlaves.get(0);
            String sourceFileName = filePropagatorTask._sourceFileName;
            System.out.println("Copying from source " + sourceFileName);
            String targetFileName = filePropagatorTask._targetFileName;
            commands.add(this._getMkdirCommand(targetFileName));
            if (sourceFileName.startsWith("http")) {
                commands.add(" curl -o " + targetFileName + " " + sourceFileName);
            } else {
                commands.add("rsync -vI " + sourceFileName + " " + targetFileName);
            }
            String targetDirName = targetFileName.substring(0, targetFileName.lastIndexOf("/"));
            commands.add("ls -al " + targetDirName);
        }
        try {
            if (this._executeCommands(commands, true, targetSlave) != 0) {
                throw new RuntimeException("Unable to copy from source. Executed: " + commands);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to copy from source. Executed: " + commands, e);
        }
        if (targetSlave != null) {
            this._mirrorSlaves.add(targetSlave);
            this._targetSlaves.remove(targetSlave);
        }
        System.out.println("Finished copying from source.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _executeCommands(List<String> commands, boolean printOutput, String targetSlave) throws IOException {
        File shellFile = this._writeShellFile(commands, targetSlave);
        try {
            FileSystem fileSystem = FileSystems.getDefault();
            System.out.println("Executing commands:\n" + new String(Files.readAllBytes(fileSystem.getPath(shellFile.getAbsolutePath(), new String[0]))));
            String errorText = null;
            Integer exitCode = null;
            Process process = null;
            long start = System.currentTimeMillis();
            while (exitCode == null) {
                try {
                    Runtime runtime = Runtime.getRuntime();
                    process = runtime.exec("./" + shellFile.getName());
                }
                catch (IOException ioe) {
                    String message = ioe.getMessage();
                    if (message.contains("Text file busy") && System.currentTimeMillis() - start < 2000L) {
                        JenkinsResultsParserUtil.sleep(100L);
                        continue;
                    }
                    throw ioe;
                }
                if (printOutput) {
                    System.out.println(FilePropagator._readInputStream(process.getInputStream()));
                }
                if ((errorText = FilePropagator._readInputStream(process.getErrorStream())).contains("No buffer space available") || errorText.contains("Temporary failure in name resolution")) {
                    System.out.println(errorText + "\nRetry in 1 minute.");
                    JenkinsResultsParserUtil.sleep(60000L);
                    continue;
                }
                try {
                    exitCode = process.waitFor();
                }
                catch (InterruptedException ie) {
                    throw new RuntimeException(ie);
                }
                process.destroy();
            }
            if (!(errorText = errorText.trim()).isEmpty()) {
                System.out.println(errorText);
            }
            int n = exitCode;
            return n;
        }
        finally {
            if (shellFile != null && shellFile.exists()) {
                shellFile.delete();
            }
        }
    }

    private String _getMkdirCommand(String fileName) {
        String dirName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        return "mkdir -pv " + dirName;
    }

    private File _writeShellFile(List<String> commands, String targetSlave) throws IOException {
        File file = new File(commands.hashCode() + ".sh");
        StringBuffer sb = new StringBuffer("ssh ");
        sb.append(targetSlave);
        sb.append(" '");
        for (int i = 0; i < commands.size(); ++i) {
            sb.append(commands.get(i));
            if (i >= commands.size() - 1) continue;
            sb.append(" && ");
        }
        sb.append("'\n");
        try {
            try (FileWriter fileWriter = new FileWriter(file);){
                fileWriter.write(sb.toString());
            }
            file.setExecutable(true);
            return file;
        }
        catch (IOException ioe) {
            if (file != null && file.exists()) {
                file.delete();
            }
            throw ioe;
        }
    }

    private static class FilePropagatorThread
    implements Runnable {
        private long _duration;
        private final FilePropagator _filePropagator;
        private final String _mirrorSlave;
        private boolean _successful;
        private final String _targetSlave;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            ArrayList<String> commands = new ArrayList<String>(this._filePropagator._filePropagatorTasks.size());
            for (FilePropagatorTask filePropagatorTask : this._filePropagator._filePropagatorTasks) {
                commands.add(this._filePropagator._getMkdirCommand(filePropagatorTask._targetFileName));
                commands.add("rsync -vI " + this._mirrorSlave + ":" + filePropagatorTask._targetFileName + " " + filePropagatorTask._targetFileName);
            }
            try {
                this._successful = this._filePropagator._executeCommands(commands, false, this._targetSlave) == 0;
            }
            catch (Exception e) {
                this._successful = false;
            }
            this._duration = System.currentTimeMillis() - start;
            FilePropagator filePropagator = this._filePropagator;
            synchronized (filePropagator) {
                this._filePropagator._busySlaves.remove(this._mirrorSlave);
                this._filePropagator._busySlaves.remove(this._targetSlave);
                this._filePropagator._mirrorSlaves.add(this._mirrorSlave);
                this._filePropagator._threadsCompletedCount++;
                this._filePropagator._threadsDurationTotal += this._duration;
                if (!this._successful) {
                    this._filePropagator._errorSlaves.add(this._targetSlave);
                    return;
                }
                this._filePropagator._mirrorSlaves.add(this._targetSlave);
            }
        }

        private FilePropagatorThread(FilePropagator filePropagator, String mirrorSlave, String targetSlave) {
            this._filePropagator = filePropagator;
            this._mirrorSlave = mirrorSlave;
            this._targetSlave = targetSlave;
        }
    }

    private static class FilePropagatorTask {
        private final String _sourceFileName;
        private final String _targetFileName;

        private FilePropagatorTask(String sourceFileName, String targetFileName) {
            this._sourceFileName = sourceFileName;
            this._targetFileName = targetFileName;
        }
    }
}

