/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.FailureMessageUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.UnstableMessageUtil;
import java.io.File;
import java.util.ArrayList;
import org.apache.tools.ant.Project;
import org.json.JSONArray;
import org.json.JSONObject;

public class GitHubJobMessageUtil {
    public static void getGitHubJobMessage(Project project) throws Exception {
        StringBuilder sb = new StringBuilder();
        String buildURL = project.getProperty("build.url");
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "api/json"));
        String topLevelSharedDir = project.getProperty("top.level.shared.dir");
        topLevelSharedDir = topLevelSharedDir.replace("${user.dir}", System.getProperty("user.dir"));
        File javacOutputFile = new File(topLevelSharedDir + "/javac.output.txt");
        String result = jsonObject.getString("result");
        if (result.equals("ABORTED")) {
            sb.append("<pre><code>Build was aborted</code></pre>");
        } else if (result.equals("FAILURE")) {
            if (jsonObject.has("runs")) {
                int i;
                JSONArray runsJSONArray = jsonObject.getJSONArray("runs");
                ArrayList<String> failureBuildURLs = new ArrayList<String>();
                ArrayList<String> successBuildURLs = new ArrayList<String>();
                for (i = 0; i < runsJSONArray.length(); ++i) {
                    JSONObject runsJSONObject = runsJSONArray.getJSONObject(i);
                    String runBuildURL = runsJSONObject.getString("url");
                    if (!runBuildURL.endsWith("/" + jsonObject.get("number") + "/")) continue;
                    JSONObject runBuildURLJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(runBuildURL + "api/json"));
                    String runBuildURLResult = runBuildURLJSONObject.getString("result");
                    if (runBuildURLResult.equals("SUCCESS")) {
                        successBuildURLs.add(runBuildURL);
                        continue;
                    }
                    failureBuildURLs.add(runBuildURL);
                }
                sb.append("<h6>Job Results:</h6>");
                sb.append("<p>");
                sb.append(successBuildURLs.size());
                sb.append(" Test");
                if (successBuildURLs.size() != 1) {
                    sb.append("s");
                }
                sb.append(" Passed.<br />");
                sb.append(failureBuildURLs.size());
                sb.append(" Test");
                if (failureBuildURLs.size() != 1) {
                    sb.append("s");
                }
                sb.append(" Failed.</p>");
                sb.append("<ol>");
                for (i = 0; i < failureBuildURLs.size(); ++i) {
                    String failureBuildURL = (String)failureBuildURLs.get(i);
                    JSONObject failureJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(failureBuildURL + "api/json"));
                    sb.append("<li><strong><a href=\"");
                    sb.append(failureBuildURL);
                    sb.append("\">");
                    sb.append(JenkinsResultsParserUtil.fixJSON(failureJSONObject.getString("fullDisplayName")));
                    sb.append("</a></strong>");
                    sb.append(FailureMessageUtil.getFailureMessage(project, failureBuildURL));
                    sb.append("</li>");
                    if (i >= 2) break;
                }
                sb.append("</ol>");
            } else {
                sb.append(FailureMessageUtil.getFailureMessage(project, buildURL));
            }
        } else if (result.equals("UNSTABLE")) {
            sb.append(UnstableMessageUtil.getUnstableMessage(buildURL));
        } else if (javacOutputFile.exists()) {
            sb.append("<h6>Job Results:</h6>");
            sb.append("<p>0 Tests Passed.<br />1 Test Failed.</p>");
            sb.append("<pre><code>");
            String javacOutputFileContent = JenkinsResultsParserUtil.read(javacOutputFile);
            if (javacOutputFileContent.length() > 5000) {
                javacOutputFileContent = javacOutputFileContent.substring(javacOutputFileContent.length() - 5000);
            }
            sb.append(javacOutputFileContent);
            sb.append("</code></pre>");
        }
        project.setProperty("report.html.content", sb.toString());
    }
}

