/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsPerformanceDataUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.List;
import org.dom4j.Element;
import org.dom4j.tree.DefaultElement;

public class JenkinsPerformanceTableUtil {
    public static String generateHTML() throws IOException {
        List<JenkinsPerformanceDataUtil.Result> results = JenkinsPerformanceDataUtil.getSlowestResults();
        if (results == null) {
            return "<p>Performance data is not available.</p>";
        }
        DefaultElement divElement = new DefaultElement("div");
        DefaultElement pElement = new DefaultElement("p");
        divElement.add((Element)pElement);
        pElement.addText(JenkinsPerformanceDataUtil.getSlaveCount() + 1 + " Slaves");
        pElement.add((Element)new DefaultElement("br"));
        pElement.addText(JenkinsPerformanceDataUtil.getTestCount() + " Tests");
        pElement.add((Element)new DefaultElement("br"));
        pElement.addText(JenkinsPerformanceDataUtil.getTotalDuration() + " Seconds of CPU " + "Time");
        pElement.add((Element)new DefaultElement("br"));
        DefaultElement tableElement = new DefaultElement("table");
        divElement.add((Element)tableElement);
        tableElement.addAttribute("border", "1");
        tableElement.addAttribute("cellspacing", "0");
        tableElement.add(JenkinsPerformanceTableUtil._createRowElement("th", "Axis", "Class Name", "Duration (Seconds)", "Job Name", "Name", "Status", null));
        for (JenkinsPerformanceDataUtil.Result result : results) {
            tableElement.add(JenkinsPerformanceTableUtil._createRowElement("td", result.getAxis(), result.getClassName(), Float.toString(result.getDuration()), result.getJobName(), result.getName(), result.getStatus(), result.getUrl()));
        }
        JenkinsPerformanceDataUtil.reset();
        System.out.println(JenkinsResultsParserUtil.format((Element)pElement));
        return JenkinsResultsParserUtil.format((Element)divElement);
    }

    private static Element _createAxisElement(String elementName, String axis, String width) {
        String text = axis;
        if (axis.contains("=")) {
            text = axis.substring(axis.indexOf("=") + 1);
        }
        return JenkinsPerformanceTableUtil._createElement(elementName, text, width);
    }

    private static Element _createElement(String elementName, String text, String width) {
        DefaultElement element = new DefaultElement(elementName);
        element.addAttribute("width", width);
        return element.addText(text);
    }

    private static Element _createJobElement(String elementName, String jobName, String width) {
        String text = jobName;
        if (jobName.contains("/")) {
            text = jobName.substring(jobName.indexOf("/") + 1);
        }
        return JenkinsPerformanceTableUtil._createElement(elementName, text, width);
    }

    private static Element _createNameElement(String elementName, String name, String url, String width) {
        if (url == null || url.length() == 0) {
            return JenkinsPerformanceTableUtil._createElement(elementName, name, width);
        }
        DefaultElement element = new DefaultElement(elementName);
        DefaultElement anchorElement = new DefaultElement("a");
        anchorElement.addAttribute("href", url);
        anchorElement.addText(name);
        element.add((Element)anchorElement);
        element.addAttribute("width", width);
        return element;
    }

    private static Element _createRowElement(String elementName, String axis, String className, String duration, String jobName, String name, String status, String url) {
        DefaultElement element = new DefaultElement("tr");
        element.add(JenkinsPerformanceTableUtil._createJobElement(elementName, jobName, "16%"));
        element.add(JenkinsPerformanceTableUtil._createAxisElement(elementName, axis, "12%"));
        element.add(JenkinsPerformanceTableUtil._createElement(elementName, className, "30%"));
        element.add(JenkinsPerformanceTableUtil._createNameElement(elementName, name, url, "30%"));
        element.add(JenkinsPerformanceTableUtil._createElement(elementName, status, "8%"));
        element.add(JenkinsPerformanceTableUtil._createElement(elementName, duration, "4%"));
        return element;
    }
}

