/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;
import org.json.JSONArray;
import org.json.JSONObject;

public class LoadBalancerUtil {
    protected static long recentJobPeriod = 120000L;
    private static final long _MAX_AGE = 30000L;
    private static final String _MY_HOST_NAME;
    private static final Pattern _hostnamePattern;
    private static final Pattern _urlPattern;

    public static String getMostAvailableMasterURL(Project project) throws Exception {
        return LoadBalancerUtil.getMostAvailableMasterURL("base.invocation.url", project.getProperty("base.invocation.url"), "invoked.job.batch.size", project.getProperty("invoked.job.batch.size"), "top.level.shared.dir", project.getProperty("top.level.shared.dir"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMostAvailableMasterURL(Properties properties) throws Exception {
        long start = System.currentTimeMillis();
        System.out.println("Get most available master URL for properties:");
        properties.list(System.out);
        boolean readOnly = false;
        int retryCount = 0;
        String baseInvocationURL;
        String hostNamePrefix;
        while (!(hostNamePrefix = LoadBalancerUtil.getHostNamePrefix(baseInvocationURL = properties.getProperty("base.invocation.url"))).equals(baseInvocationURL)) {
            List<String> hostNames = LoadBalancerUtil.getHostNames(properties, hostNamePrefix);
            if (hostNames.size() == 1) {
                return "http://" + hostNamePrefix + "-1";
            }
            File sharedDir = new File(properties.getProperty("jenkins.shared.dir", "NULL"));
            if (!sharedDir.exists() || !sharedDir.isDirectory()) {
                readOnly = true;
                System.out.println("Load balancer will run in read only mode because of missing shared directory " + sharedDir.getPath() + ".");
            }
            Map<String, Integer> recentJobMap = new HashMap<String, Integer>();
            if (!readOnly) {
                File baseDir = new File(sharedDir, hostNamePrefix);
                File semaphoreFile = new File(baseDir, hostNamePrefix + ".semaphore");
                LoadBalancerUtil.waitForTurn(semaphoreFile, hostNames.size());
                JenkinsResultsParserUtil.write(semaphoreFile, _MY_HOST_NAME);
                recentJobMap = LoadBalancerUtil.getRecentJobCountMap(new File(baseDir, "recentJob"));
            }
            int maxAvailableSlaveCount = Integer.MIN_VALUE;
            int x = -1;
            try {
                ArrayList<FutureTask<Integer>> futureTasks = new ArrayList<FutureTask<Integer>>(hostNames.size());
                LoadBalancerUtil.startParallelTasks(recentJobMap, hostNames, hostNamePrefix, properties, futureTasks);
                ArrayList<Integer> badIndices = new ArrayList<Integer>(futureTasks.size());
                ArrayList<Integer> maxIndices = new ArrayList<Integer>(futureTasks.size());
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < futureTasks.size(); ++i) {
                    Integer availableSlaveCount = null;
                    FutureTask futureTask = (FutureTask)futureTasks.get(i);
                    try {
                        availableSlaveCount = (Integer)futureTask.get(15L, TimeUnit.SECONDS);
                    }
                    catch (TimeoutException te) {
                        System.out.println("Unable to assess master availability for " + hostNames.get(i) + ".");
                        availableSlaveCount = null;
                    }
                    if (availableSlaveCount == null) {
                        badIndices.add(i);
                        continue;
                    }
                    sb.append(hostNames.get(i));
                    sb.append(" : ");
                    sb.append(availableSlaveCount);
                    sb.append("\n");
                    if (availableSlaveCount > maxAvailableSlaveCount) {
                        maxAvailableSlaveCount = availableSlaveCount;
                        maxIndices.clear();
                    }
                    if (availableSlaveCount < maxAvailableSlaveCount) continue;
                    maxIndices.add(i);
                }
                if (maxAvailableSlaveCount == Integer.MIN_VALUE) {
                    if (retryCount == 3) {
                        throw new RuntimeException("Retry limit exceeded. Unable to communicate  with masters.");
                    }
                    ++retryCount;
                    continue;
                }
                if (maxIndices.size() > 0) {
                    x = (Integer)maxIndices.get(LoadBalancerUtil.getRandomValue(0, maxIndices.size() - 1));
                } else {
                    while (badIndices.contains(x = LoadBalancerUtil.getRandomValue(0, hostNames.size() - 1))) {
                    }
                }
                sb.append("\nMost available master ");
                sb.append(hostNames.get(x));
                sb.append(" has ");
                sb.append(maxAvailableSlaveCount);
                sb.append(" available slaves.");
                System.out.println(sb);
                String string = "http://" + hostNames.get(x);
                return string;
            }
            finally {
                if (!readOnly) {
                    File baseDir = new File(sharedDir, hostNamePrefix);
                    File semaphoreFile = new File(baseDir, hostNamePrefix + ".semaphore");
                    long age = System.currentTimeMillis() - semaphoreFile.lastModified();
                    System.out.println("Semaphore " + semaphoreFile + " was last modified " + (float)age / 1000.0f + " seconds ago.");
                    String content = JenkinsResultsParserUtil.read(semaphoreFile);
                    if (content.equals(_MY_HOST_NAME)) {
                        if (recentJobPeriod > 0L) {
                            String invokedJobBatchSize;
                            StringBuilder sb = new StringBuilder();
                            File recentJobFile = new File(baseDir, "recentJob/" + hostNames.get(x));
                            if (recentJobFile.exists()) {
                                sb.append(JenkinsResultsParserUtil.read(recentJobFile));
                                if (sb.length() > 0) {
                                    sb.append("|");
                                }
                            }
                            if ((invokedJobBatchSize = properties.getProperty("invoked.job.batch.size")) == null || invokedJobBatchSize.length() == 0) {
                                invokedJobBatchSize = "1";
                            }
                            sb.append(invokedJobBatchSize);
                            sb.append("-");
                            sb.append(System.currentTimeMillis());
                            JenkinsResultsParserUtil.write(recentJobFile, sb.toString());
                        }
                        JenkinsResultsParserUtil.write(semaphoreFile, "");
                    } else {
                        System.out.println("Sempahore " + semaphoreFile + " was overwritten with: " + content);
                    }
                }
                System.out.println("Got most available master URL in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds.");
                continue;
            }
            break;
        }
        return baseInvocationURL;
    }

    public static String getMostAvailableMasterURL(String ... overridePropertiesArray) throws Exception {
        return LoadBalancerUtil.getMostAvailableMasterURL("http://mirrors-no-cache.lax.liferay.com/github.com/liferay/liferay-jenkins-ee/commands/build.properties", overridePropertiesArray);
    }

    public static String getMostAvailableMasterURL(String propertiesURL, String[] overridePropertiesArray) throws Exception {
        Properties properties = new Properties();
        String propertiesString = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(propertiesURL), false);
        properties.load(new StringReader(propertiesString));
        if (overridePropertiesArray != null && overridePropertiesArray.length > 0 && overridePropertiesArray.length % 2 == 0) {
            for (int i = 0; i < overridePropertiesArray.length; i += 2) {
                String overridePropertyName = overridePropertiesArray[i];
                String overridePropertyValue = overridePropertiesArray[i + 1];
                if (overridePropertyValue == null) continue;
                properties.setProperty(overridePropertyName, overridePropertyValue);
            }
        }
        return LoadBalancerUtil.getMostAvailableMasterURL(properties);
    }

    protected static List<String> getBlacklist(Properties properties) {
        String blacklistString = properties.getProperty("jenkins.load.balancer.blacklist", "");
        System.out.println("Blacklist: " + blacklistString);
        if (blacklistString.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> blacklist = new ArrayList<String>();
        for (String blacklistItem : blacklistString.split(",")) {
            blacklist.add(blacklistItem.trim());
        }
        return blacklist;
    }

    protected static String getHostNamePrefix(String baseInvocationURL) {
        Matcher matcher = _urlPattern.matcher(baseInvocationURL);
        if (!matcher.find()) {
            return baseInvocationURL;
        }
        return matcher.group("hostNamePrefix");
    }

    protected static List<String> getHostNames(Properties properties, String hostNamePrefix) {
        String jenkinsLocalURL;
        List<String> blacklist = LoadBalancerUtil.getBlacklist(properties);
        ArrayList<String> hostNames = new ArrayList<String>();
        int i = 1;
        while ((jenkinsLocalURL = properties.getProperty("jenkins.local.url[" + hostNamePrefix + "-" + i + "]")) != null && jenkinsLocalURL.length() > 0) {
            Matcher matcher = _hostnamePattern.matcher(jenkinsLocalURL);
            if (!matcher.find()) continue;
            String jenkinsLocalHostName = matcher.group("hostname");
            if (!blacklist.contains(jenkinsLocalHostName)) {
                hostNames.add(jenkinsLocalHostName);
            }
            ++i;
        }
        System.out.println("Host name prefix: " + hostNamePrefix);
        System.out.println("Host names: " + hostNames);
        return hostNames;
    }

    protected static int getRandomValue(int start, int end) {
        int size = Math.abs(end - start);
        double randomDouble = Math.random();
        return start + (int)Math.round((double)size * randomDouble);
    }

    protected static Map<String, Integer> getRecentJobCountMap(File dir) throws Exception {
        HashMap<String, Integer> jobCountMap = new HashMap<String, Integer>();
        if (!dir.exists()) {
            return jobCountMap;
        }
        for (File file : dir.listFiles()) {
            if (System.currentTimeMillis() - file.lastModified() > recentJobPeriod) {
                file.delete();
                continue;
            }
            try {
                String content = JenkinsResultsParserUtil.read(file);
                if (content.length() == 0) continue;
                StringBuilder sb = new StringBuilder();
                int totalJobCount = 0;
                for (String jobCountData : content.split("\\|")) {
                    int x = jobCountData.indexOf("-");
                    int jobCount = Integer.parseInt(jobCountData.substring(0, x));
                    long timestamp = Long.parseLong(jobCountData.substring(x + 1));
                    if (timestamp + recentJobPeriod <= System.currentTimeMillis()) continue;
                    if (sb.length() > 0) {
                        sb.append("|");
                    }
                    sb.append(jobCountData);
                    totalJobCount += jobCount;
                }
                jobCountMap.put(file.getName(), totalJobCount);
                if (sb.length() > 0) {
                    JenkinsResultsParserUtil.write(file, sb.toString());
                    continue;
                }
                file.delete();
            }
            catch (Exception e) {
                file.delete();
            }
        }
        return jobCountMap;
    }

    protected static void startParallelTasks(Map<String, Integer> recentJobMap, List<String> hostNames, String hostNamePrefix, Properties properties, List<FutureTask<Integer>> futureTasks) throws Exception {
        ExecutorService executorService = Executors.newFixedThreadPool(hostNames.size());
        for (String targetHostName : hostNames) {
            FutureTask<Integer> futureTask = new FutureTask<Integer>(new AvailableSlaveCallable(recentJobMap.get(targetHostName), properties.getProperty("jenkins.local.url[" + targetHostName + "]")));
            executorService.execute(futureTask);
            futureTasks.add(futureTask);
        }
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void waitForTurn(File file, int hostNameCount) throws Exception {
        long start = System.currentTimeMillis();
        try {
            block6: {
                String content;
                while (true) {
                    if (!file.exists()) {
                        JenkinsResultsParserUtil.write(file, "");
                        return;
                    }
                    long age = System.currentTimeMillis() - file.lastModified();
                    content = JenkinsResultsParserUtil.read(file);
                    if (content.length() <= 0) break block6;
                    if (age >= 30000L) break;
                    Thread.sleep(1000L);
                }
                System.out.println("Sempahore file " + file + " timed out: " + content);
            }
            return;
        }
        finally {
            System.out.println("Waited " + (float)(System.currentTimeMillis() - start) / 1000.0f + " seconds.");
        }
    }

    static {
        _hostnamePattern = Pattern.compile(".*/(?<hostname>[^/]+)/?");
        _urlPattern = Pattern.compile("http://(?<hostNamePrefix>.+-\\d?).liferay.com");
        String inetHostName = null;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            inetHostName = inetAddress.getHostName();
        }
        catch (UnknownHostException uhe) {
            inetHostName = "UNKNOWN";
        }
        _MY_HOST_NAME = inetHostName;
    }

    private static class AvailableSlaveCallable
    implements Callable<Integer> {
        protected Integer recentJobCount;
        protected String url;

        @Override
        public Integer call() throws Exception {
            long start = System.currentTimeMillis();
            JSONObject computerJSONObject = null;
            JSONObject queueJSONObject = null;
            try {
                computerJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.url + "/computer/api/json?pretty&tree=computer" + "[displayName,idle,offline]"), false, 5000);
                queueJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(this.url + "/queue/api/json"), false, 5000);
            }
            catch (Exception e) {
                System.out.println("Unable to read " + this.url);
                return null;
            }
            int idleCount = 0;
            JSONArray computersJSONArray = computerJSONObject.getJSONArray("computer");
            for (int i = 0; i < computersJSONArray.length(); ++i) {
                String displayName;
                JSONObject curComputerJSONObject = computersJSONArray.getJSONObject(i);
                if (!curComputerJSONObject.getBoolean("idle") || curComputerJSONObject.getBoolean("offline") || (displayName = curComputerJSONObject.getString("displayName")).equals("master")) continue;
                ++idleCount;
            }
            int queueCount = 0;
            if (queueJSONObject.has("items")) {
                JSONArray itemsJSONArray = queueJSONObject.getJSONArray("items");
                for (int i = 0; i < itemsJSONArray.length(); ++i) {
                    JSONObject taskJSONObject;
                    String taskName;
                    String why;
                    JSONObject itemJSONObject = itemsJSONArray.getJSONObject(i);
                    if (itemJSONObject.has("why") && (why = itemJSONObject.getString("why")).endsWith("is offline") || itemJSONObject.has("task") && (taskName = (taskJSONObject = itemJSONObject.getJSONObject("task")).getString("name")).equals("verification-node")) continue;
                    ++queueCount;
                }
            }
            int availableSlaveCount = idleCount - queueCount;
            if (this.recentJobCount != null) {
                availableSlaveCount -= this.recentJobCount.intValue();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("{available=");
            sb.append(availableSlaveCount);
            sb.append(", duration=");
            sb.append(System.currentTimeMillis() - start);
            sb.append("ms, idle=");
            sb.append(idleCount);
            sb.append(", queue=");
            sb.append(queueCount);
            sb.append(", recentJobs=");
            sb.append(this.recentJobCount);
            sb.append(", url=");
            sb.append(this.url);
            sb.append("}");
            System.out.println(sb.toString());
            return availableSlaveCount;
        }

        protected AvailableSlaveCallable(Integer recentJobCount, String url) {
            this.recentJobCount = recentJobCount;
            this.url = url;
        }
    }
}

