/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;
import org.json.JSONObject;

public class PluginFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final Pattern _pattern = Pattern.compile("(\\d+) of \\d+ plugins? failed to compile:");

    @Override
    public String getMessage(String buildURL, String consoleOutput, Project project) throws Exception {
        if (!buildURL.contains("portal-acceptance")) {
            return null;
        }
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(buildURL + "api/json"));
        String jobVariant = JenkinsResultsParserUtil.getJobVariant(jsonObject);
        if (!buildURL.contains("plugins") && !jobVariant.contains("plugins")) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Matcher matcher = _pattern.matcher(consoleOutput);
        if (matcher.find()) {
            String group = matcher.group(0);
            sb.append("<p>");
            sb.append(group);
            sb.append("</p>");
            sb.append("<ul>");
            int x = matcher.start() + group.length() + 1;
            int count = Integer.parseInt(matcher.group(1));
            for (int i = 0; i < count; ++i) {
                if (i == 10) {
                    sb.append("<li>...</li>");
                    break;
                }
                int y = consoleOutput.indexOf("\n", x);
                String pluginName = consoleOutput.substring(x, y);
                sb.append("<li>");
                sb.append(pluginName.replace("[echo] ", ""));
                sb.append("</li>");
                x = y + 1;
            }
            sb.append("</ul>");
        } else {
            sb.append("<p>To include a plugin fix for this pull request, please ");
            sb.append("edit your <a href=\"https://github.com/");
            sb.append(project.getProperty("github.pull.request.head.username"));
            sb.append("/");
            sb.append(project.getProperty("portal.repository"));
            sb.append("/blob/");
            sb.append(project.getProperty("github.pull.request.head.branch"));
            sb.append("/git-commit-plugins\">git-commit-plugins</a>. ");
            sb.append("Click <a href=\"https://in.liferay.com/web/");
            sb.append("global.engineering/blog/-/blogs/new-tests-for-the-pull-");
            sb.append("request-tester-\">here</a> for more details.</p>");
            int end = consoleOutput.indexOf("merge-test-results:");
            sb.append(this.getConsoleOutputSnippet(consoleOutput, true, end));
        }
        return sb.toString();
    }
}

