/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import org.apache.tools.ant.Project;

public class RebaseFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _REBASE_END_STRING = "The copy of the patch that failed is found in";
    private static final String _REBASE_START_STRING = "First, rewinding head to replay your work on top of it...";

    @Override
    public String getMessage(String buildURL, String consoleOutput, Project project) throws Exception {
        if (!(consoleOutput.contains(_REBASE_END_STRING) && consoleOutput.contains(_REBASE_START_STRING) && consoleOutput.contains("CONFLICT"))) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>Please fix <strong>rebase errors</strong> on <strong>");
        sb.append("<a href=\"https://github.com/");
        sb.append(project.getProperty("github.pull.request.head.username"));
        sb.append("/");
        sb.append(project.getProperty("repository"));
        sb.append("/tree/");
        sb.append(project.getProperty("github.pull.request.head.branch"));
        sb.append("\">");
        sb.append(project.getProperty("github.pull.request.head.username"));
        sb.append("/");
        sb.append(project.getProperty("github.pull.request.head.branch"));
        sb.append("</a></strong>.</p>");
        int end = consoleOutput.indexOf(_REBASE_END_STRING);
        end = consoleOutput.lastIndexOf("\n", end);
        int start = consoleOutput.lastIndexOf(_REBASE_START_STRING, end);
        start = consoleOutput.lastIndexOf("\n", start);
        sb.append(this.getConsoleOutputSnippet(consoleOutput, true, start, end));
        return sb.toString();
    }
}

