/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.DownstreamBuild;
import java.util.ArrayList;
import java.util.List;

public class TopLevelBuild
extends BaseBuild {
    private final List<DownstreamBuild> _downstreamBuilds = new ArrayList<DownstreamBuild>();

    public TopLevelBuild(String buildURL) throws Exception {
        super(buildURL);
    }

    public void addDownstreamBuilds(String ... invocationURLs) throws Exception {
        for (String invocationURL : invocationURLs) {
            this._downstreamBuilds.add(new DownstreamBuild(invocationURL, this));
        }
        String status = this.getStatus();
        if (status.equals("completed")) {
            this.setStatus(null);
        }
        this.update();
    }

    public List<DownstreamBuild> getDownstreamBuilds(String status) {
        if (status == null) {
            return this._downstreamBuilds;
        }
        ArrayList<DownstreamBuild> filteredDownstreamBuilds = new ArrayList<DownstreamBuild>();
        for (DownstreamBuild downstreamBuild : this._downstreamBuilds) {
            if (!status.equals(downstreamBuild.getStatus())) continue;
            filteredDownstreamBuilds.add(downstreamBuild);
        }
        return filteredDownstreamBuilds;
    }

    @Override
    public void update() throws Exception {
        String status = this.getStatus();
        if (status == null) {
            this.setStatus("running");
            status = this.getStatus();
        }
        if (status.equals("completed")) {
            return;
        }
        if (this._downstreamBuilds != null) {
            for (DownstreamBuild downstreamBuild : this._downstreamBuilds) {
                downstreamBuild.update();
            }
            if (this._downstreamBuilds.size() == this.getDownstreamBuildCount("completed")) {
                this.setStatus("completed");
                return;
            }
            if (this.getDownstreamBuildCount("missing") > 0) {
                this.setStatus("missing");
                return;
            }
            if (this.getDownstreamBuildCount("starting") > 0) {
                this.setStatus("starting");
                return;
            }
        }
        this.setStatus("running");
    }

    protected int getDownstreamBuildCount(String status) {
        List<DownstreamBuild> downstreamBuilds = this.getDownstreamBuilds(status);
        return downstreamBuilds.size();
    }
}

