/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AxisBuild
extends BaseBuild {
    protected String axisVariable;
    private static final Pattern _archiveBuildURLPattern = Pattern.compile("($\\{dependencies\\.url\\}|file:|http://).*/(?<archiveName>[^/]+)/(?<master>[^/]+)/+(?<jobName>[^/]+)/(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/(?<buildNumber>\\d+)/?");
    private static final Pattern _axisVariablePattern = Pattern.compile("AXIS_VARIABLE=(?<axisNumber>[^,]+),.*");
    private static final Pattern _buildURLPattern = Pattern.compile("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+)/(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/(?<buildNumber>\\d+)/?");

    @Override
    public void findDownstreamBuilds() {
    }

    @Override
    public String getArchivePath() {
        if (this.archiveName == null) {
            System.out.println("Build URL " + this.getBuildURL() + " has a null archive name");
        }
        StringBuilder sb = new StringBuilder(this.archiveName);
        if (!this.archiveName.endsWith("/")) {
            sb.append("/");
        }
        sb.append(this.getMaster());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getAxisVariable());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    public String getAxisNumber() {
        Matcher matcher = _axisVariablePattern.matcher(this.getAxisVariable());
        if (matcher.find()) {
            return matcher.group("axisNumber");
        }
        throw new RuntimeException("Invalid axis variable: " + this.getAxisVariable());
    }

    public String getAxisVariable() {
        return this.axisVariable;
    }

    @Override
    public String getBuildURL() {
        String jobURL = this.getJobURL();
        int buildNumber = this.getBuildNumber();
        if (jobURL == null || buildNumber == -1) {
            return null;
        }
        if (this.fromArchive) {
            return jobURL + "/" + this.axisVariable + "/" + buildNumber + "/";
        }
        try {
            jobURL = JenkinsResultsParserUtil.decode(jobURL);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unable to decode " + jobURL, uee);
        }
        String buildURL = jobURL + "/" + this.axisVariable + "/" + buildNumber + "/";
        try {
            return JenkinsResultsParserUtil.encode(buildURL);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException("Could not encode " + buildURL, murle);
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Could not encode " + buildURL, urise);
        }
    }

    @Override
    public String getBuildURLRegex() {
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this.getMaster()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this.getAxisVariable()));
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        return sb.toString();
    }

    @Override
    public void reinvoke() {
        throw new RuntimeException("Axis builds cannot be reinvoked");
    }

    protected AxisBuild(String url) {
        this(url, null);
    }

    protected AxisBuild(String url, BatchBuild parentBuild) {
        super(JenkinsResultsParserUtil.getLocalURL(url), parentBuild);
    }

    @Override
    protected void checkForReinvocation() {
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop-properties.json";
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        StringBuilder sb = new StringBuilder();
        sb.append("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/");
        sb.append(topLevelBuild.getMaster());
        sb.append("/");
        sb.append(topLevelBuild.getJobName());
        sb.append("/");
        sb.append(topLevelBuild.getBuildNumber());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getAxisVariable());
        sb.append("/");
        sb.append(this.getParameterValue("JOB_VARIANT"));
        sb.append("/");
        sb.append("stop.properties");
        return sb.toString();
    }

    @Override
    protected void setBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Unable to decode " + buildURL, uee);
        }
        Matcher matcher = _buildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            matcher = _archiveBuildURLPattern.matcher(buildURL);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid build URL " + buildURL);
            }
            this.archiveName = matcher.group("archiveName");
        }
        this.axisVariable = matcher.group("axisVariable");
        this.jobName = matcher.group("jobName");
        this.master = matcher.group("master");
        this.setBuildNumber(Integer.parseInt(matcher.group("buildNumber")));
        this.loadParametersFromBuildJSONObject();
        this.setStatus("running");
    }
}

