/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.BuildFactory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class BaseBuild
implements Build {
    protected static final Pattern archiveBuildURLPattern = Pattern.compile("($\\{dependencies\\.url\\}|file:|http://).*/(?<archiveName>[^/]+)/(?<master>[^/]+)/+(?<jobName>[^/]+).*/(?<buildNumber>\\d+)/?");
    protected static final Pattern buildURLPattern = Pattern.compile("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/(?<buildNumber>\\d+)/?");
    protected static final Pattern downstreamBuildURLPattern = Pattern.compile("[\\'\\\"].*[\\'\\\"] started at (?<url>.+)\\.");
    protected static final Pattern invocationURLPattern = Pattern.compile("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+).*/buildWithParameters\\?(?<queryString>.*)");
    protected String archiveName;
    protected List<Integer> badBuildNumbers = new ArrayList<Integer>();
    protected List<Build> downstreamBuilds = new ArrayList<Build>();
    protected boolean fromArchive;
    protected String jobName;
    protected String master;
    protected String result;
    protected long statusModifiedTime;
    private int _buildNumber = -1;
    private int _consoleReadCursor;
    private Map<String, String> _parameters = new HashMap<String, String>();
    private final Build _parentBuild;
    private String _status;

    @Override
    public void addDownstreamBuilds(String ... urls) {
        for (String url : urls) {
            try {
                url = JenkinsResultsParserUtil.getLocalURL(JenkinsResultsParserUtil.decode(url));
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("Unable to decode " + url, uee);
            }
            if (this.hasBuildURL(url)) continue;
            this.downstreamBuilds.add(BuildFactory.newBuild(url, this));
        }
    }

    @Override
    public void archive(final String archiveName) {
        if (!this._status.equals("completed")) {
            throw new RuntimeException("Invalid build status: " + this._status);
        }
        this.archiveName = archiveName;
        File archiveDir = new File(this.getArchivePath());
        if (archiveDir.exists()) {
            archiveDir.delete();
        }
        if (this.downstreamBuilds != null) {
            ExecutorService executorService = this.getExecutorService();
            for (final Build downstreamBuild : this.downstreamBuilds) {
                if (executorService != null) {
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            downstreamBuild.archive(archiveName);
                        }
                    };
                    executorService.execute(runnable);
                    continue;
                }
                downstreamBuild.archive(archiveName);
            }
            if (executorService != null) {
                executorService.shutdown();
                while (!executorService.isTerminated()) {
                    JenkinsResultsParserUtil.sleep(100L);
                }
            }
        }
        try {
            this.writeArchiveFile(Long.toString(System.currentTimeMillis()), this.getArchivePath() + "/archive-marker");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to to write archive-marker file", ioe);
        }
        this.archiveConsoleLog();
        this.archiveJSON();
    }

    @Override
    public String getArchivePath() {
        StringBuilder sb = new StringBuilder(this.archiveName);
        if (!this.archiveName.endsWith("/")) {
            sb.append("/");
        }
        sb.append(this.getMaster());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    @Override
    public List<String> getBadBuildURLs() {
        ArrayList<String> badBuildURLs = new ArrayList<String>();
        String jobURL = this.getJobURL();
        for (Integer badBuildNumber : this.badBuildNumbers) {
            StringBuilder sb = new StringBuilder();
            sb.append(jobURL);
            sb.append("/");
            sb.append(badBuildNumber);
            sb.append("/");
            badBuildURLs.add(sb.toString());
        }
        return badBuildURLs;
    }

    @Override
    public int getBuildNumber() {
        return this._buildNumber;
    }

    @Override
    public String getBuildURL() {
        try {
            String jobURL = this.getJobURL();
            if (jobURL == null || this._buildNumber == -1) {
                return null;
            }
            if (this.fromArchive) {
                return jobURL + "/" + this._buildNumber + "/";
            }
            jobURL = JenkinsResultsParserUtil.decode(jobURL);
            return JenkinsResultsParserUtil.encode(jobURL + "/" + this._buildNumber + "/");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getBuildURLRegex() {
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this.getMaster()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        String buildURLRegex = sb.toString();
        return buildURLRegex;
    }

    @Override
    public String getConsoleText() {
        try {
            return JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL() + "/consoleText"), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getDownstreamBuildCount(String status) {
        List<Build> downstreamBuilds = this.getDownstreamBuilds(status);
        return downstreamBuilds.size();
    }

    @Override
    public List<Build> getDownstreamBuilds(String status) {
        if (status == null) {
            return this.downstreamBuilds;
        }
        ArrayList<Build> filteredDownstreamBuilds = new ArrayList<Build>();
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!status.equals(downstreamBuild.getStatus())) continue;
            filteredDownstreamBuilds.add(downstreamBuild);
        }
        return filteredDownstreamBuilds;
    }

    @Override
    public String getInvocationURL() {
        String jobURL = this.getJobURL();
        if (jobURL == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer(jobURL);
        sb.append("/buildWithParameters?");
        Map<String, String> parameters = this.getParameters();
        parameters.put("token", "raen3Aib");
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String value = parameter.getValue();
            if (value == null || value.isEmpty()) continue;
            sb.append(parameter.getKey());
            sb.append("=");
            sb.append(parameter.getValue());
            sb.append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        try {
            return JenkinsResultsParserUtil.encode(sb.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getJobURL() {
        if (this.master == null || this.jobName == null) {
            return null;
        }
        if (this.fromArchive) {
            return "${dependencies.url}/" + this.archiveName + "/" + this.master + "/" + this.jobName;
        }
        try {
            return JenkinsResultsParserUtil.encode("http://" + this.master + "/job/" + this.jobName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getMaster() {
        return this.master;
    }

    @Override
    public Map<String, String> getParameters() {
        return new HashMap<String, String>(this._parameters);
    }

    @Override
    public String getParameterValue(String name) {
        return this._parameters.get(name);
    }

    @Override
    public Build getParentBuild() {
        return this._parentBuild;
    }

    @Override
    public String getResult() {
        String buildURL = this.getBuildURL();
        if (this.result == null && buildURL != null) {
            try {
                JSONObject resultJSONObject = this.getBuildJSONObject("result");
                this.result = resultJSONObject.optString("result");
                if (this.result.equals("")) {
                    this.result = null;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.result;
    }

    @Override
    public Map<String, String> getStartPropertiesMap() {
        return this.getTempMap("start.properties");
    }

    @Override
    public String getStatus() {
        return this._status;
    }

    @Override
    public long getStatusAge() {
        return System.currentTimeMillis() - this.statusModifiedTime;
    }

    @Override
    public String getStatusReport() {
        return this.getStatusReport(0);
    }

    @Override
    public String getStatusReport(int indentSize) {
        StringBuffer indentStringBuffer = new StringBuffer();
        for (int i = 0; i < indentSize; ++i) {
            indentStringBuffer.append(" ");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indentStringBuffer);
        sb.append("Build \"");
        sb.append(this.jobName);
        sb.append("\"");
        String status = this.getStatus();
        if (status.equals("completed")) {
            sb.append(" completed at ");
            sb.append(this.getBuildURL());
            sb.append(". ");
            sb.append(this.getResult());
            return sb.toString();
        }
        if (status.equals("missing")) {
            sb.append(" is missing ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("queued")) {
            sb.append(" is queued at ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        if (status.equals("running")) {
            sb.append(" running at ");
            sb.append(this.getBuildURL());
            sb.append(".\n");
            if (this.getDownstreamBuildCount(null) > 0) {
                sb.append("\n");
                for (Build downstreamBuild : this.getDownstreamBuilds("running")) {
                    sb.append(downstreamBuild.getStatusReport(indentSize + 4));
                }
                sb.append("\n");
                sb.append(indentStringBuffer);
                sb.append(this.getStatusSummary());
                sb.append("\n");
            }
            return sb.toString();
        }
        if (status.equals("starting")) {
            sb.append(" invoked at ");
            sb.append(this.getJobURL());
            sb.append(".");
            return sb.toString();
        }
        throw new RuntimeException("Unknown status: " + status);
    }

    @Override
    public String getStatusSummary() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDownstreamBuildCount("starting"));
        sb.append(" Starting  ");
        sb.append("/ ");
        sb.append(this.getDownstreamBuildCount("missing"));
        sb.append(" Missing  ");
        sb.append("/ ");
        sb.append(this.getDownstreamBuildCount("queued"));
        sb.append(" Queued  ");
        sb.append("/ ");
        sb.append(this.getDownstreamBuildCount("running"));
        sb.append(" Running  ");
        sb.append("/ ");
        sb.append(this.getDownstreamBuildCount("completed"));
        sb.append(" Completed  ");
        sb.append("/ ");
        sb.append(this.getDownstreamBuildCount(null));
        sb.append(" Total ");
        return sb.toString();
    }

    @Override
    public Map<String, String> getStopPropertiesMap() {
        return this.getTempMap("stop.properties");
    }

    @Override
    public boolean hasBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        buildURL = JenkinsResultsParserUtil.getLocalURL(buildURL);
        String thisBuildURL = this.getBuildURL();
        if (thisBuildURL != null && thisBuildURL.equals(buildURL)) {
            return true;
        }
        for (Build downstreamBuild : this.downstreamBuilds) {
            if (!downstreamBuild.hasBuildURL(buildURL)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void reinvoke() {
        String hostName = JenkinsResultsParserUtil.getHostName("");
        if (!hostName.startsWith("cloud-10-0")) {
            System.out.println("A build may not be reinvoked by " + hostName);
            return;
        }
        String invocationURL = this.getInvocationURL();
        try {
            JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(invocationURL));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        System.out.println(this.getReinvokedMessage());
        this.reset();
    }

    @Override
    public String replaceBuildURL(String text) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (this.downstreamBuilds != null) {
            Iterator<Build> iterator = this.downstreamBuilds.iterator();
            while (iterator.hasNext()) {
                Build downstreamBuild;
                Build downstreamBaseBuild = downstreamBuild = iterator.next();
                text = downstreamBaseBuild.replaceBuildURL(text);
            }
        }
        text = text.replaceAll(this.getBuildURLRegex(), Matcher.quoteReplacement("${dependencies.url}/" + this.getArchivePath()));
        for (Build parentBuild = this.getParentBuild(); parentBuild != null; parentBuild = parentBuild.getParentBuild()) {
            text = text.replaceAll(parentBuild.getBuildURLRegex(), Matcher.quoteReplacement("${dependencies.url}/" + parentBuild.getArchivePath()));
        }
        return text;
    }

    @Override
    public void update() {
        String status = this.getStatus();
        if (!status.equals("completed")) {
            try {
                if (status.equals("missing") || status.equals("queued") || status.equals("starting")) {
                    JSONObject runningBuildJSONObject = this.getRunningBuildJSONObject();
                    if (runningBuildJSONObject != null) {
                        this.setBuildNumber(runningBuildJSONObject.getInt("number"));
                    } else {
                        JSONObject queueItemJSONObject = this.getQueueItemJSONObject();
                        if (status.equals("starting") && queueItemJSONObject != null) {
                            this.setStatus("queued");
                        } else if (status.equals("queued") && queueItemJSONObject == null) {
                            this.setStatus("missing");
                        }
                    }
                }
                status = this.getStatus();
                if (this.downstreamBuilds != null) {
                    ExecutorService executorService = this.getExecutorService();
                    for (final Build downstreamBuild : this.downstreamBuilds) {
                        if (executorService != null) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    downstreamBuild.update();
                                }
                            };
                            executorService.execute(runnable);
                            continue;
                        }
                        downstreamBuild.update();
                    }
                    if (executorService != null) {
                        executorService.shutdown();
                        while (!executorService.isTerminated()) {
                            JenkinsResultsParserUtil.sleep(100L);
                        }
                    }
                    String result = this.getResult();
                    if (this.downstreamBuilds.size() == this.getDownstreamBuildCount("completed") && result != null) {
                        this.setStatus("completed");
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.findDownstreamBuilds();
        }
    }

    protected BaseBuild(String url) {
        this(url, null);
    }

    protected BaseBuild(String url, Build parentBuild) {
        this._parentBuild = parentBuild;
        try {
            String archiveMarkerContent = JenkinsResultsParserUtil.toString(url + "/archive-marker", false, 0, 0, 0);
            this.fromArchive = archiveMarkerContent != null && !archiveMarkerContent.isEmpty();
        }
        catch (IOException ioe) {
            this.fromArchive = false;
        }
        if (url.contains("buildWithParameters")) {
            this.setInvocationURL(url);
        } else {
            this.setBuildURL(url);
        }
        this.update();
    }

    protected void archiveConsoleLog() {
        this.downloadSampleURL(this.getArchivePath(), true, this.getBuildURL(), "/consoleText");
    }

    protected void archiveJSON() {
        this.downloadSampleURL(this.getArchivePath(), true, this.getBuildURL(), "api/json");
        this.downloadSampleURL(this.getArchivePath(), false, this.getBuildURL(), "testReport/api/json");
        if (!this.getStartPropertiesMap().isEmpty()) {
            try {
                JSONObject startPropertiesJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getStartPropertiesTempMapURL());
                this.writeArchiveFile(startPropertiesJSONObject.toString(4), this.getArchivePath() + "/start-properties.json");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create start-properties.json", ioe);
            }
        }
        if (!this.getStopPropertiesMap().isEmpty()) {
            try {
                JSONObject stopPropertiesJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getStopPropertiesTempMapURL());
                this.writeArchiveFile(stopPropertiesJSONObject.toString(4), this.getArchivePath() + "/stop-properties.json");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to create stop-properties.json", ioe);
            }
        }
    }

    protected void checkForReinvocation() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        if (topLevelBuild == null || topLevelBuild.fromArchive) {
            return;
        }
        String consoleText = topLevelBuild.getConsoleText();
        if (consoleText.contains(this.getReinvokedMessage())) {
            this.reset();
            this.update();
        }
    }

    protected void downloadSampleURL(String path, boolean required, String url, String urlSuffix) {
        String urlString = url + urlSuffix;
        if (urlString.endsWith("json")) {
            urlString = urlString + "?pretty";
        }
        urlSuffix = JenkinsResultsParserUtil.fixFileName(urlSuffix);
        String content = null;
        try {
            content = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(urlString), false, 0, 0, 0);
        }
        catch (IOException ioe) {
            if (required) {
                throw new RuntimeException("Unable to download sample " + urlString, ioe);
            }
            return;
        }
        try {
            this.writeArchiveFile(content, path + "/" + urlSuffix);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to write file", ioe);
        }
    }

    protected void findDownstreamBuilds() {
        JSONArray runsJSONArray;
        JSONObject buildJSONObject;
        ArrayList<String> foundDownstreamBuildURLs = new ArrayList<String>(this.findDownstreamBuildsInConsoleText());
        try {
            buildJSONObject = this.getBuildJSONObject("runs[number,url]");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (buildJSONObject != null && buildJSONObject.has("runs") && (runsJSONArray = buildJSONObject.getJSONArray("runs")) != null) {
            for (int i = 0; i < runsJSONArray.length(); ++i) {
                String url;
                JSONObject runJSONObject = runsJSONArray.getJSONObject(i);
                if (runJSONObject.getInt("number") != this._buildNumber || this.hasBuildURL(url = runJSONObject.getString("url")) || foundDownstreamBuildURLs.contains(url)) continue;
                foundDownstreamBuildURLs.add(url);
            }
        }
        this.addDownstreamBuilds(foundDownstreamBuildURLs.toArray(new String[foundDownstreamBuildURLs.size()]));
    }

    protected List<String> findDownstreamBuildsInConsoleText() {
        ArrayList<String> foundDownstreamBuildURLs = new ArrayList<String>();
        if (this.getBuildURL() != null) {
            String consoleText = this.getConsoleText();
            Matcher downstreamBuildURLMatcher = downstreamBuildURLPattern.matcher(consoleText.substring(this._consoleReadCursor));
            this._consoleReadCursor = consoleText.length();
            while (downstreamBuildURLMatcher.find()) {
                String url = downstreamBuildURLMatcher.group("url");
                if (foundDownstreamBuildURLs.contains(url)) continue;
                foundDownstreamBuildURLs.add(url);
            }
        }
        return foundDownstreamBuildURLs;
    }

    protected JSONObject getBuildJSONObject(String tree) {
        if (this.getBuildURL() == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(JenkinsResultsParserUtil.getLocalURL(this.getBuildURL()));
        sb.append("/api/json?pretty");
        if (tree != null) {
            sb.append("&tree=");
            sb.append(tree);
        }
        try {
            return JenkinsResultsParserUtil.toJSONObject(sb.toString(), false);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build JSON", ioe);
        }
    }

    protected String getBuildMessage() {
        if (this.jobName != null) {
            String status = this.getStatus();
            StringBuilder sb = new StringBuilder();
            sb.append("Build \"");
            sb.append(this.jobName);
            sb.append("\"");
            if (status.equals("completed")) {
                sb.append(" completed at ");
                sb.append(this.getBuildURL());
                sb.append(". ");
                sb.append(this.getResult());
                return sb.toString();
            }
            if (status.equals("missing")) {
                sb.append(" is missing ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("queued")) {
                sb.append(" is queued at ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("running")) {
                if (this.badBuildNumbers.size() > 0) {
                    sb.append(" restarted at ");
                } else {
                    sb.append(" started at ");
                }
                sb.append(this.getBuildURL());
                sb.append(".");
                return sb.toString();
            }
            if (status.equals("starting")) {
                sb.append(" invoked at ");
                sb.append(this.getJobURL());
                sb.append(".");
                return sb.toString();
            }
            throw new RuntimeException("Unknown status: " + status);
        }
        return "";
    }

    protected JSONArray getBuildsJSONArray() throws Exception {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getJobURL() + "/api/json?tree=builds[actions[parameters[name,type,value]],building,duration,number,result,url]", false);
        return jsonObject.getJSONArray("builds");
    }

    protected ExecutorService getExecutorService() {
        return null;
    }

    protected Set<String> getJobParameterNames() {
        JSONObject jsonObject;
        try {
            jsonObject = JenkinsResultsParserUtil.toJSONObject(this.getJobURL() + "/api/json?tree=actions[parameterDefinitions[name,type,value]]");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build JSON", ioe);
        }
        JSONArray actionsJSONArray = jsonObject.getJSONArray("actions");
        JSONObject firstActionJSONObject = actionsJSONArray.getJSONObject(0);
        JSONArray parameterDefinitionsJSONArray = firstActionJSONObject.getJSONArray("parameterDefinitions");
        HashSet<String> parameterNames = new HashSet<String>(parameterDefinitionsJSONArray.length());
        for (int i = 0; i < parameterDefinitionsJSONArray.length(); ++i) {
            JSONObject parameterDefinitionJSONObject = parameterDefinitionsJSONArray.getJSONObject(i);
            String type = parameterDefinitionJSONObject.getString("type");
            if (!type.equals("StringParameterDefinition")) continue;
            parameterNames.add(parameterDefinitionJSONObject.getString("name"));
        }
        return parameterNames;
    }

    protected Map<String, String> getParameters(JSONArray jsonArray) throws Exception {
        HashMap<String, String> parameters = new HashMap<String, String>(jsonArray.length());
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            if (!(jsonObject.opt("value") instanceof String)) continue;
            String name = jsonObject.getString("name");
            String value = jsonObject.getString("value");
            if (value.isEmpty()) continue;
            parameters.put(name, value);
        }
        return parameters;
    }

    protected Map<String, String> getParameters(JSONObject buildJSONObject) throws Exception {
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            return new HashMap<String, String>();
        }
        JSONObject jsonObject = actionsJSONArray.getJSONObject(0);
        if (jsonObject.has("parameters")) {
            JSONArray parametersJSONArray = jsonObject.getJSONArray("parameters");
            return this.getParameters(parametersJSONArray);
        }
        return new HashMap<String, String>();
    }

    protected JSONObject getQueueItemJSONObject() throws Exception {
        JSONArray queueItemsJSONArray = this.getQueueItemsJSONArray();
        for (int i = 0; i < queueItemsJSONArray.length(); ++i) {
            JSONObject queueItemJSONObject = queueItemsJSONArray.getJSONObject(i);
            JSONObject taskJSONObject = queueItemJSONObject.getJSONObject("task");
            String queueItemName = taskJSONObject.getString("name");
            if (!queueItemName.equals(this.jobName) || !this._parameters.equals(this.getParameters(queueItemJSONObject))) continue;
            return queueItemJSONObject;
        }
        return null;
    }

    protected JSONArray getQueueItemsJSONArray() throws Exception {
        JSONObject jsonObject = JenkinsResultsParserUtil.toJSONObject("http://" + this.master + "/queue/api/json?tree=items[actions[parameters[name,value]],task[name,url]]", false);
        return jsonObject.getJSONArray("items");
    }

    protected String getReinvokedMessage() {
        StringBuffer sb = new StringBuffer();
        sb.append("Reinvoked: ");
        sb.append(this.getBuildURL());
        sb.append(" at ");
        sb.append(this.getInvocationURL());
        return sb.toString();
    }

    protected JSONObject getRunningBuildJSONObject() throws Exception {
        JSONArray buildsJSONArray = this.getBuildsJSONArray();
        for (int i = 0; i < buildsJSONArray.length(); ++i) {
            JSONObject buildJSONObject = buildsJSONArray.getJSONObject(i);
            Map<String, String> parameters = this.getParameters();
            if (!parameters.equals(this.getParameters(buildJSONObject)) || this.badBuildNumbers.contains(buildJSONObject.getInt("number"))) continue;
            return buildJSONObject;
        }
        return null;
    }

    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start-properties.json";
        }
        return this.getParameterValue("JSON_MAP_URL");
    }

    protected String getStopPropertiesTempMapURL() {
        return null;
    }

    protected Map<String, String> getTempMap(String tempMapName) {
        JSONObject tempMapJSONObject = null;
        String tempMapURL = null;
        if (tempMapName.equals("start.properties")) {
            tempMapURL = this.getStartPropertiesTempMapURL();
        }
        if (tempMapName.equals("stop.properties")) {
            tempMapURL = this.getStopPropertiesTempMapURL();
        }
        if (tempMapURL == null) {
            return Collections.emptyMap();
        }
        try {
            tempMapJSONObject = JenkinsResultsParserUtil.toJSONObject(JenkinsResultsParserUtil.getLocalURL(tempMapURL), false, 0, 0, 0);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (tempMapJSONObject == null || !tempMapJSONObject.has("properties")) {
            return Collections.emptyMap();
        }
        JSONArray propertiesJSONArray = tempMapJSONObject.getJSONArray("properties");
        HashMap<String, String> tempMap = new HashMap<String, String>(propertiesJSONArray.length());
        for (int i = 0; i < propertiesJSONArray.length(); ++i) {
            JSONObject propertyJSONObject = propertiesJSONArray.getJSONObject(i);
            String key = propertyJSONObject.getString("name");
            String value = propertyJSONObject.optString("value");
            if (value == null || value.isEmpty()) continue;
            tempMap.put(key, value);
        }
        return tempMap;
    }

    protected TopLevelBuild getTopLevelBuild() {
        Build topLevelBuild;
        for (topLevelBuild = this; topLevelBuild != null && !(topLevelBuild instanceof TopLevelBuild); topLevelBuild = topLevelBuild.getParentBuild()) {
        }
        return (TopLevelBuild)topLevelBuild;
    }

    protected boolean isParentBuildRoot() {
        if (this._parentBuild == null) {
            return false;
        }
        return this._parentBuild.getParentBuild() == null && this._parentBuild instanceof TopLevelBuild;
    }

    protected void loadParametersFromBuildJSONObject() {
        if (this.getBuildURL() == null) {
            return;
        }
        JSONObject buildJSONObject = this.getBuildJSONObject("actions[parameters[*]]");
        JSONArray actionsJSONArray = buildJSONObject.getJSONArray("actions");
        if (actionsJSONArray.length() == 0) {
            this._parameters = new HashMap<String, String>(0);
            return;
        }
        JSONObject actionJSONObject = actionsJSONArray.getJSONObject(0);
        if (actionJSONObject.has("parameters")) {
            JSONArray parametersJSONArray = actionJSONObject.getJSONArray("parameters");
            this._parameters = new HashMap<String, String>(parametersJSONArray.length());
            for (int i = 0; i < parametersJSONArray.length(); ++i) {
                JSONObject parameterJSONObject = parametersJSONArray.getJSONObject(i);
                Object value = parameterJSONObject.opt("value");
                if (!(value instanceof String) || value.toString().isEmpty()) continue;
                this._parameters.put(parameterJSONObject.getString("name"), value.toString());
            }
            return;
        }
        this._parameters = Collections.emptyMap();
    }

    protected void loadParametersFromQueryString(String queryString) {
        Set<String> jobParameterNames = this.getJobParameterNames();
        for (String parameter : queryString.split("&")) {
            String[] nameValueArray = parameter.split("=");
            if (nameValueArray.length != 2 || !jobParameterNames.contains(nameValueArray[0])) continue;
            this._parameters.put(nameValueArray[0], nameValueArray[1]);
        }
    }

    protected void reset() {
        this.result = null;
        this.badBuildNumbers.add(this.getBuildNumber());
        this.setBuildNumber(-1);
        this.downstreamBuilds.clear();
        this._consoleReadCursor = 0;
        this.setStatus("starting");
    }

    protected void setBuildNumber(int buildNumber) {
        this._buildNumber = buildNumber;
        this.setStatus("running");
        if (this._buildNumber != -1) {
            this.checkForReinvocation();
        }
    }

    protected void setBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Unable to decode " + buildURL, uee);
        }
        Matcher matcher = buildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            matcher = archiveBuildURLPattern.matcher(buildURL);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid build URL " + buildURL);
            }
            this.archiveName = matcher.group("archiveName");
        }
        this._buildNumber = Integer.parseInt(matcher.group("buildNumber"));
        this.jobName = matcher.group("jobName");
        this.master = matcher.group("master");
        this.loadParametersFromBuildJSONObject();
        this._consoleReadCursor = 0;
        this.setStatus("running");
        this.checkForReinvocation();
    }

    protected void setInvocationURL(String invocationURL) {
        if (this.getBuildURL() == null) {
            try {
                invocationURL = JenkinsResultsParserUtil.decode(invocationURL);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("Unable to decode " + invocationURL, uee);
            }
            Matcher invocationURLMatcher = invocationURLPattern.matcher(invocationURL);
            if (!invocationURLMatcher.find()) {
                throw new RuntimeException("Invalid invocation URL");
            }
            this.jobName = invocationURLMatcher.group("jobName");
            this.master = invocationURLMatcher.group("master");
            this.loadParametersFromQueryString(invocationURL);
            this.setStatus("starting");
        }
    }

    protected void setStatus(String status) {
        if (status == null && this._status != null || !status.equals(this._status)) {
            this._status = status;
            this.statusModifiedTime = System.currentTimeMillis();
            if (this.isParentBuildRoot()) {
                System.out.println(this.getBuildMessage());
            }
        }
    }

    protected void writeArchiveFile(String content, String path) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(JenkinsResultsParserUtil.DEPENDENCIES_URL_FILE.substring("file:".length()));
        sb.append("/");
        sb.append(path);
        JenkinsResultsParserUtil.write(sb.toString(), this.replaceBuildURL(content));
    }
}

