/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.FunctionalBatchBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.ModulesIntegrationBatchBuild;
import com.liferay.jenkins.results.parser.RebaseErrorTopLevelBuild;
import com.liferay.jenkins.results.parser.SourceBuild;
import com.liferay.jenkins.results.parser.TopLevelBuild;

public class BuildFactory {
    private static final String[] _BATCH_INDICATORS = new String[]{"-batch", "-dist", "environment-"};

    public static Build newBuild(String url, Build parentBuild) {
        String jenkinsJobVariant;
        if ((url = JenkinsResultsParserUtil.getLocalURL(url)).contains("AXIS_VARIABLE=")) {
            return new AxisBuild(url, (BatchBuild)parentBuild);
        }
        if (url.contains("-source")) {
            return new SourceBuild(url, parentBuild);
        }
        for (String batchIndicator : _BATCH_INDICATORS) {
            if (!url.contains(batchIndicator)) continue;
            BatchBuild batchBuild = new BatchBuild(url, (TopLevelBuild)parentBuild);
            String jobVariant = batchBuild.getParameterValue("JOB_VARIANT");
            if (jobVariant != null) {
                if (jobVariant.contains("functional")) {
                    batchBuild = new FunctionalBatchBuild(url, (TopLevelBuild)parentBuild);
                }
                if (jobVariant.contains("modules-integration")) {
                    batchBuild = new ModulesIntegrationBatchBuild(url, (TopLevelBuild)parentBuild);
                }
            }
            return batchBuild;
        }
        TopLevelBuild topLevelBuild = new TopLevelBuild(url, (TopLevelBuild)parentBuild);
        String jobName = topLevelBuild.getJobName();
        if (jobName.equals("test-portal-acceptance-pullrequest(ee-6.2.x)") && (jenkinsJobVariant = topLevelBuild.getParameterValue("JENKINS_JOB_VARIANT")) != null && jenkinsJobVariant.equals("rebase-error")) {
            return new RebaseErrorTopLevelBuild(url, (TopLevelBuild)parentBuild);
        }
        return topLevelBuild;
    }
}

