/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.DownstreamFailureMessageGenerator;
import com.liferay.jenkins.results.parser.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.IntegrationTestTimeoutFailureMessageGenerator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitMirrorFailureMessageGenerator;
import com.liferay.jenkins.results.parser.PluginFailureMessageGenerator;
import com.liferay.jenkins.results.parser.PluginGitIDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.PoshiValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.RebaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.SemanticVersioningFailureMessageGenerator;
import com.liferay.jenkins.results.parser.SourceFormatFailureMessageGenerator;
import org.apache.tools.ant.Project;

public class FailureMessageUtil {
    private static final FailureMessageGenerator[] _failureMessageGenerators = new FailureMessageGenerator[]{new PoshiValidationFailureMessageGenerator(), new DownstreamFailureMessageGenerator(), new IntegrationTestTimeoutFailureMessageGenerator(), new LocalGitMirrorFailureMessageGenerator(), new PluginFailureMessageGenerator(), new PluginGitIDFailureMessageGenerator(), new RebaseFailureMessageGenerator(), new SemanticVersioningFailureMessageGenerator(), new SourceFormatFailureMessageGenerator()};
    private static final GenericFailureMessageGenerator _genericFailureMessageGenerator = new GenericFailureMessageGenerator();

    public static String getFailureMessage(Project project, String buildURL) throws Exception {
        String consoleOutput = JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(buildURL + "/logText/progressiveText"));
        for (FailureMessageGenerator failureMessageGenerator : _failureMessageGenerators) {
            String message = failureMessageGenerator.getMessage(buildURL, consoleOutput, project);
            if (message == null) continue;
            return message;
        }
        return _genericFailureMessageGenerator.getMessage(buildURL, consoleOutput, project);
    }
}

