/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.TopLevelBuild;

public class FunctionalBatchBuild
extends BatchBuild {
    public FunctionalBatchBuild(String url) {
        super(url);
    }

    public FunctionalBatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public void update() {
        super.update();
        if (!this.badBuildNumbers.isEmpty()) {
            return;
        }
        Build failedAxisBuild = null;
        for (Build axisBuild : this.getDownstreamBuilds("completed")) {
            String axisBuildResult = axisBuild.getResult();
            if (axisBuildResult == null || axisBuildResult.equals("SUCCESS")) continue;
            failedAxisBuild = axisBuild;
            break;
        }
        if (failedAxisBuild != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("Functional test failure detected at ");
            sb.append(failedAxisBuild.getBuildURL());
            sb.append(". This batch will be reinvoked.");
            System.out.println(sb);
            this.reinvoke();
        }
    }
}

