/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.FailureMessageUtil;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.Project;

public class GitHubMessageUtil {
    private static final Pattern _pattern = Pattern.compile("\\<h5[^\\>]*\\>(.+)\\<\\/h5\\>.*");

    public static void getGitHubMessage(Project project) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("<h1>");
        sb.append(project.getProperty("top.level.result.message"));
        sb.append("</h1>");
        sb.append("<p>Build Time: ");
        sb.append(project.getProperty("top.level.build.time"));
        sb.append("</p>");
        String rebaseBranchGitCommit = project.getProperty("rebase.branch.git.commit");
        if (!rebaseBranchGitCommit.equals("")) {
            sb.append("<h4>Base Branch:</h4>");
            sb.append("<p>Branch Name: ");
            sb.append("<a href=\"https://github.com/liferay/");
            sb.append(project.getProperty("repository"));
            sb.append("/tree/");
            sb.append(project.getProperty("branch.name"));
            sb.append("\">");
            sb.append(project.getProperty("branch.name"));
            sb.append("</a><br />");
            sb.append("Branch GIT ID: <a href=\"https://github.com/liferay/");
            sb.append(project.getProperty("repository"));
            sb.append("/commit/");
            sb.append(rebaseBranchGitCommit);
            sb.append("\">");
            sb.append(rebaseBranchGitCommit);
            sb.append("</a></p>");
        }
        sb.append("<h4>Job Summary:</h4>");
        sb.append("<ul>");
        sb.append("<li>");
        String topLevelResult = project.getProperty("top.level.result");
        if (!topLevelResult.equals("SUCCESS")) {
            sb.append("<strike><strong>");
        }
        sb.append("<a href=\"");
        sb.append(project.getProperty("env.BUILD_URL"));
        sb.append("\">");
        sb.append(project.getProperty("top.level.build.name"));
        sb.append("</a>");
        if (!topLevelResult.equals("SUCCESS")) {
            sb.append("</strong></strike>");
        }
        sb.append("</li>");
        String reportFileNames = project.getProperty("top.level.report.files");
        for (String reportFileName : reportFileNames.split(" ")) {
            String[] file = new File(reportFileName);
            String content = JenkinsResultsParserUtil.read((File)file);
            Matcher matcher = _pattern.matcher(content);
            if (!matcher.find()) continue;
            sb.append("<li>");
            if (content.contains("job-result=\"SUCCESS\"")) {
                sb.append(matcher.group(1));
            } else {
                sb.append("<strike><strong>");
                sb.append(matcher.group(1));
                sb.append("</strong></strike>");
            }
            sb.append("</li>");
        }
        sb.append("</ul>");
        sb.append("<h5>For more details click <a href=\"");
        sb.append(project.getProperty("top.level.shared.dir.url"));
        sb.append("/jenkins-report.html\">here</a>.</h5>");
        if (!topLevelResult.equals("SUCCESS")) {
            sb.append("<hr />");
            sb.append("<h4>Failed Jobs:</h4>");
            sb.append("<ol>");
            sb.append("<li><h5><a href=\"");
            sb.append(project.getProperty("env.BUILD_URL"));
            sb.append("\">");
            sb.append(project.getProperty("top.level.build.name"));
            sb.append("</a></h5>");
            sb.append("<h6>Job Results:</h6>");
            int topLevelPassCount = Integer.parseInt(project.getProperty("top.level.pass.count"));
            sb.append("<p>");
            sb.append(topLevelPassCount);
            sb.append(" Job");
            if (topLevelPassCount != 1) {
                sb.append("s");
            }
            sb.append(" Passed.<br />");
            int topLevelFailCount = Integer.parseInt(project.getProperty("top.level.fail.count")) + 1;
            sb.append(topLevelFailCount);
            sb.append(" Job");
            if (topLevelFailCount != 1) {
                sb.append("s");
            }
            sb.append(" Failed.</p>");
            sb.append(FailureMessageUtil.getFailureMessage(project, project.getProperty("env.BUILD_URL")));
            sb.append("</li>");
            ArrayList<String> highPriorityJobFailureContents = new ArrayList<String>();
            ArrayList<String> normalPriorityJobFailureContents = new ArrayList<String>();
            for (String reportFileName : reportFileNames.split(" ")) {
                File file = new File(reportFileName);
                String content = JenkinsResultsParserUtil.read(file);
                if (content.contains("job-result=\"SUCCESS\"")) continue;
                if (GitHubMessageUtil.isHighPriorityJobFailure(content)) {
                    highPriorityJobFailureContents.add(content);
                    continue;
                }
                normalPriorityJobFailureContents.add(content);
            }
            ArrayList<String> jobFailureContents = new ArrayList<String>(highPriorityJobFailureContents);
            jobFailureContents.addAll(normalPriorityJobFailureContents);
            for (int i = 0; i < jobFailureContents.size(); ++i) {
                if (i == 4) {
                    sb.append("<li>...</li>");
                    break;
                }
                sb.append("<li>");
                sb.append((String)jobFailureContents.get(i));
                sb.append("</li>");
            }
            sb.append("</ol>");
        }
        project.setProperty("github.post.comment.body", GitHubMessageUtil.redact(sb.toString()));
    }

    protected static String getRedactTokenKey(int index) {
        return "github.message.redact.token[" + index + "]";
    }

    protected static boolean isHighPriorityJobFailure(String content) {
        String[] contentFlags;
        for (String contentFlag : contentFlags = new String[]{"compileJSP", "SourceFormatterTest", "Unable to compile JSPs"}) {
            if (!content.contains(contentFlag)) continue;
            return true;
        }
        return false;
    }

    protected static String redact(String string) throws Exception {
        HashSet<String> redactTokens = new HashSet<String>();
        Properties properties = JenkinsResultsParserUtil.getBuildProperties();
        int i = 1;
        while (properties.containsKey(GitHubMessageUtil.getRedactTokenKey(i))) {
            String key;
            String redactToken = key = properties.getProperty(GitHubMessageUtil.getRedactTokenKey(i));
            if (key.startsWith("${") && key.endsWith("}")) {
                redactToken = properties.getProperty(key.substring(2, key.length() - 1));
            }
            if (redactToken != null && !redactToken.isEmpty()) {
                redactTokens.add(redactToken);
            }
            ++i;
        }
        redactTokens.remove("test");
        for (String redactToken : redactTokens) {
            string = string.replace(redactToken, "[REDACTED]");
        }
        return string;
    }
}

