/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ModulesIntegrationBatchBuild
extends BatchBuild {
    protected Properties buildProperties;
    protected List<Build> verifiedAxisBuilds;
    private static final String _REINVOKE_ERROR_MARKER_TEMPLATE = "reinvoke.error.marker[modules-integration-?]";
    private boolean _notificationsComplete;

    public ModulesIntegrationBatchBuild(String url) {
        super(url);
    }

    public ModulesIntegrationBatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public void reinvoke() {
        super.reinvoke();
        this.verifiedAxisBuilds.clear();
    }

    @Override
    public void update() {
        super.update();
        if (this._notificationsComplete) {
            return;
        }
        if (this.verifiedAxisBuilds == null) {
            this.verifiedAxisBuilds = new ArrayList<Build>();
        }
        Build reinvokeErrorAxisBuild = null;
        String reinvokeErrorMarker = null;
        for (Build axisBuild : this.getDownstreamBuilds("completed")) {
            String axisBuildResult;
            if (this.verifiedAxisBuilds.contains(axisBuild) || (axisBuildResult = axisBuild.getResult()) == null || axisBuildResult.equals("SUCCESS")) continue;
            String axisBuildConsoleText = axisBuild.getConsoleText();
            int i = 1;
            while (this.hasReinvokeErrorMarker(i)) {
                if (axisBuildConsoleText.contains(this.getReinvokeErrorMarker(i))) {
                    reinvokeErrorAxisBuild = axisBuild;
                    reinvokeErrorMarker = this.getReinvokeErrorMarker(i);
                    break;
                }
                ++i;
            }
            if (reinvokeErrorAxisBuild != null) continue;
            this.verifiedAxisBuilds.add(axisBuild);
        }
        if (reinvokeErrorAxisBuild != null) {
            StringBuilder sb = new StringBuilder();
            String subject = "Arquillian broken connection failure";
            if (this.badBuildNumbers.size() == 0) {
                sb.append("Arquillian broken connection failure ");
                sb.append("detected at ");
                sb.append(reinvokeErrorAxisBuild.getBuildURL());
                sb.append(". This batch will be reinvoked.");
                sb.append("\n\nError marker:\n");
                sb.append(reinvokeErrorMarker);
                System.out.println(sb);
                this.reinvoke();
            } else {
                subject = "Second " + subject;
                List<String> badBuildURLs = this.getBadBuildURLs();
                sb.append("Second Arquillian broken connection failure ");
                sb.append("detected at ");
                sb.append(reinvokeErrorAxisBuild.getBuildURL());
                sb.append(". Previous failure was at ");
                sb.append(badBuildURLs.get(0));
                sb.append("\n\nError marker:\n");
                sb.append(reinvokeErrorMarker);
                System.out.println(sb);
                this._notificationsComplete = true;
            }
            try {
                JenkinsResultsParserUtil.sendEmail(sb.toString(), "root@" + JenkinsResultsParserUtil.getHostName("UNKNOWN"), subject, "peter.yoo@liferay.com, shuyang.zhou@liferay.com");
            }
            catch (Exception e) {
                System.out.println("Unable to send email notification: " + e.getMessage());
            }
        }
    }

    protected String getReinvokedErrorMarkerPropertyName(int index) {
        return _REINVOKE_ERROR_MARKER_TEMPLATE.replace("?", Integer.toString(index));
    }

    protected String getReinvokeErrorMarker(int index) {
        if (this.buildProperties == null) {
            this.loadBuildProperties();
        }
        return this.buildProperties.getProperty(this.getReinvokedErrorMarkerPropertyName(index));
    }

    protected boolean hasReinvokeErrorMarker(int index) {
        if (this.buildProperties == null) {
            this.loadBuildProperties();
        }
        return this.buildProperties.containsKey(this.getReinvokedErrorMarkerPropertyName(index));
    }

    protected void loadBuildProperties() {
        try {
            this.buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build.properties.", ioe);
        }
    }
}

