/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;

public class RebaseErrorTopLevelBuild
extends TopLevelBuild {
    private boolean _validResult = false;

    public RebaseErrorTopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public String getResult() {
        if (this._validResult) {
            return this.result;
        }
        super.getResult();
        if (this.result == null) {
            return this.result;
        }
        try {
            if (this.result.equals("SUCCESS")) {
                String string = this.result = "FAILURE";
                return string;
            }
            if (!this.result.equals("FAILURE")) {
                String string = this.result;
                return string;
            }
            long time = System.currentTimeMillis();
            Map<String, String> stopPropertiesMap = this.getStopPropertiesMap();
            while (!stopPropertiesMap.containsKey("TOP_LEVEL_GITHUB_COMMENT_ID")) {
                if (System.currentTimeMillis() - time > 300000L) {
                    System.out.println("No entry exists for TOP_LEVEL_GITHUB_COMMENT_ID in stop.properties");
                    String string = this.result;
                    return string;
                }
                JenkinsResultsParserUtil.sleep(10000L);
                stopPropertiesMap = this.getStopPropertiesMap();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("http://mirrors-no-cache.lax.liferay.com/");
            sb.append("github.com/liferay/liferay-jenkins-ee/tests/");
            sb.append(this.getJobName());
            String jenkinsJobVariant = this.getParameterValue("JENKINS_JOB_VARIANT");
            if (jenkinsJobVariant != null) {
                sb.append("/");
                sb.append(jenkinsJobVariant);
            }
            sb.append("/report.html");
            Element rootElement = this.getElement(JenkinsResultsParserUtil.toString(sb.toString()));
            List<String> expectedCommentTokens = this.getCommentTokens(rootElement);
            sb = new StringBuilder();
            sb.append("https://api.github.com/repos/");
            sb.append(this.getParameterValue("GITHUB_RECEIVER_USERNAME"));
            sb.append("/");
            sb.append("liferay-portal-ee");
            sb.append("/issues/comments/");
            sb.append(stopPropertiesMap.get("TOP_LEVEL_GITHUB_COMMENT_ID"));
            JSONObject jsonObject = this.getJSONObjectFromURL(sb.toString());
            String commentBody = jsonObject.getString("body");
            rootElement = this.getElement(commentBody);
            List<String> actualCommentTokens = this.getCommentTokens(rootElement);
            boolean matchesTemplate = true;
            for (int i = 0; i < expectedCommentTokens.size(); ++i) {
                System.out.println();
                System.out.println("Test " + i);
                Pattern pattern = Pattern.compile(expectedCommentTokens.get(i));
                Matcher matcher = pattern.matcher(actualCommentTokens.get(i));
                System.out.println(expectedCommentTokens.get(i));
                System.out.println(actualCommentTokens.get(i));
                if (!matcher.find()) {
                    System.out.println("Tokens mismatched.");
                    String string = this.result;
                    return string;
                }
                System.out.println("Tokens matched.");
            }
            if (matchesTemplate) {
                this.result = "SUCCESS";
            }
            String string = this.result;
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("An exception occurred while trying to match the actual output with the expected output", e);
        }
        finally {
            this._validResult = true;
        }
    }

    protected List<String> getCommentTokens(Element element) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add("text: " + this.removeWhitespace(element.getText()));
        List elements = element.elements();
        for (Element childElement : elements) {
            tokens.addAll(this.getCommentTokens(childElement));
        }
        List attributes = element.attributes();
        for (Attribute attribute : attributes) {
            tokens.add("attribute: " + this.removeWhitespace(attribute.getValue()));
        }
        return tokens;
    }

    protected Element getElement(String content) throws Exception {
        SAXReader saxReader = new SAXReader();
        StringBuilder sb = new StringBuilder();
        sb.append("<div>");
        sb.append(content);
        sb.append("</div>");
        content = sb.toString();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes("UTF-8"));
        Document document = saxReader.read((InputStream)inputStream);
        return document.getRootElement();
    }

    protected JSONObject getJSONObjectFromURL(String url) throws Exception {
        Properties properties = JenkinsResultsParserUtil.getBuildProperties();
        StringBuilder sb = new StringBuilder();
        URL urlObject = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlObject.openConnection();
        httpURLConnection.setRequestMethod("GET");
        httpURLConnection.setRequestProperty("Authorization", "token " + properties.getProperty("github.access.token"));
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        InputStream inputStream = httpURLConnection.getInputStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        String line = null;
        while ((line = bufferedReader.readLine()) != null) {
            sb.append(line);
        }
        bufferedReader.close();
        return new JSONObject(sb.toString());
    }

    protected String removeWhitespace(String s) {
        s = s.replaceAll("\n", "");
        s = s.replaceAll("\t", "");
        return s;
    }
}

