/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import org.apache.tools.ant.Project;

public class SemanticVersioningFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _SEMVER_END_STRING = ":baseline FAILED";
    private static final String _SEMVER_START_STRING = "PACKAGE_NAME";

    @Override
    public String getMessage(String buildURL, String consoleOutput, Project project) throws Exception {
        if (!consoleOutput.contains(_SEMVER_END_STRING) || !consoleOutput.contains(_SEMVER_START_STRING)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>Please fix <strong>semantic versioning</strong> on ");
        sb.append("<strong><a href=\"https://github.com/");
        sb.append(project.getProperty("github.origin.name"));
        sb.append("/");
        sb.append(project.getProperty("repository"));
        sb.append("/tree/");
        sb.append(project.getProperty("github.sender.branch.name"));
        sb.append("\">");
        sb.append(project.getProperty("github.origin.name"));
        sb.append("/");
        sb.append(project.getProperty("github.sender.branch.name"));
        sb.append("</a></strong>.</p>");
        int end = consoleOutput.indexOf(_SEMVER_END_STRING);
        end = consoleOutput.indexOf("\n", end);
        int start = consoleOutput.lastIndexOf(_SEMVER_START_STRING, end);
        start = consoleOutput.lastIndexOf("\n", start);
        sb.append(this.getConsoleOutputSnippet(consoleOutput, true, start, end));
        return sb.toString();
    }
}

