/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TopLevelBuild
extends BaseBuild {
    private long _updateDuration;

    @Override
    public String getStatusReport(int indentSize) {
        String statusReport = super.getStatusReport(indentSize);
        if (this.getDownstreamBuildCount(null) > 0) {
            while (statusReport.endsWith("\n")) {
                statusReport = statusReport.substring(0, statusReport.length() - 1);
            }
            statusReport = statusReport + " / ";
        }
        return statusReport + "Update took " + this._updateDuration + " milliseconds.\n";
    }

    @Override
    public void update() {
        long start = System.currentTimeMillis();
        super.update();
        this._updateDuration = System.currentTimeMillis() - start;
    }

    protected TopLevelBuild(String url) {
        this(url, null);
    }

    protected TopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected ExecutorService getExecutorService() {
        return Executors.newFixedThreadPool(20);
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop-properties.json";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/");
        sb.append(this.getMaster());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getBuildNumber());
        sb.append("/");
        sb.append("stop.properties");
        return sb.toString();
    }
}

