/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.IntegrationTestTimeoutFailureMessageGenerator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.LocalGitMirrorFailureMessageGenerator;
import com.liferay.jenkins.results.parser.PluginFailureMessageGenerator;
import com.liferay.jenkins.results.parser.PluginGitIDFailureMessageGenerator;
import com.liferay.jenkins.results.parser.SemanticVersioningFailureMessageGenerator;
import com.liferay.jenkins.results.parser.SourceFormatFailureMessageGenerator;
import com.liferay.jenkins.results.parser.TestResult;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.json.JSONObject;

public class AxisBuild
extends BaseBuild {
    protected static final Pattern archiveBuildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("(", Pattern.quote("${dependencies.url}"), "|", Pattern.quote(JenkinsResultsParserUtil.DEPENDENCIES_URL_FILE), "|", Pattern.quote("http://mirrors-no-cache.lax.liferay.com/github.com/liferay/liferay-jenkins-results-parser-samples-ee/4/"), ")/*(?<archiveName>.*)/(?<master>[^/]+)/+(?<jobName>[^/]+)/", "(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/", "(?<buildNumber>\\d+)/?"));
    protected static final Pattern buildURLPattern = Pattern.compile(JenkinsResultsParserUtil.combine("\\w+://(?<master>[^/]+)/+job/+(?<jobName>[^/]+)/", "(?<axisVariable>AXIS_VARIABLE=[^,]+,[^/]+)/", "(?<buildNumber>\\d+)/?"));
    protected static final String defaultLogBaseURL = "https://testray.liferay.com/reports/production/logs";
    protected String axisVariable;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new IntegrationTestTimeoutFailureMessageGenerator(), new LocalGitMirrorFailureMessageGenerator(), new PluginFailureMessageGenerator(), new PluginGitIDFailureMessageGenerator(), new SemanticVersioningFailureMessageGenerator(), new SourceFormatFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private static final Pattern _axisVariablePattern = Pattern.compile("AXIS_VARIABLE=(?<axisNumber>[^,]+),.*");

    @Override
    public void findDownstreamBuilds() {
    }

    @Override
    public String getAppServer() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getAppServer();
    }

    @Override
    public String getArchivePath() {
        if (this.archiveName == null) {
            System.out.println("Build URL " + this.getBuildURL() + " has a null archive name");
        }
        StringBuilder sb = new StringBuilder(this.archiveName);
        if (!this.archiveName.endsWith("/")) {
            sb.append("/");
        }
        sb.append(this.getMaster());
        sb.append("/");
        sb.append(this.getJobName());
        sb.append("/");
        sb.append(this.getAxisVariable());
        sb.append("/");
        sb.append(this.getBuildNumber());
        return sb.toString();
    }

    public String getAxisNumber() {
        Matcher matcher = _axisVariablePattern.matcher(this.getAxisVariable());
        if (matcher.find()) {
            return matcher.group("axisNumber");
        }
        throw new RuntimeException("Invalid axis variable: " + this.getAxisVariable());
    }

    public String getAxisVariable() {
        return this.axisVariable;
    }

    @Override
    public String getBrowser() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getBrowser();
    }

    @Override
    public String getBuildURL() {
        String jobURL = this.getJobURL();
        int buildNumber = this.getBuildNumber();
        if (jobURL == null || buildNumber == -1) {
            return null;
        }
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine(jobURL, "/", this.axisVariable, "/", Integer.toString(buildNumber), "/");
        }
        try {
            jobURL = JenkinsResultsParserUtil.decode(jobURL);
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unable to decode " + jobURL, uee);
        }
        String buildURL = JenkinsResultsParserUtil.combine(jobURL, "/", this.axisVariable, "/", Integer.toString(buildNumber), "/");
        try {
            return JenkinsResultsParserUtil.encode(buildURL);
        }
        catch (MalformedURLException murle) {
            throw new RuntimeException("Could not encode " + buildURL, murle);
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Could not encode " + buildURL, urise);
        }
    }

    @Override
    public String getBuildURLRegex() {
        StringBuffer sb = new StringBuffer();
        sb.append("http[s]*:\\/\\/");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this.getMaster()));
        sb.append("[^\\/]*");
        sb.append("[\\/]+job[\\/]+");
        String jobNameRegexLiteral = JenkinsResultsParserUtil.getRegexLiteral(this.getJobName());
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\(", "(\\(|%28)");
        jobNameRegexLiteral = jobNameRegexLiteral.replace("\\)", "(\\)|%29)");
        sb.append(jobNameRegexLiteral);
        sb.append("[\\/]+");
        sb.append(JenkinsResultsParserUtil.getRegexLiteral(this.getAxisVariable()));
        sb.append("[\\/]+");
        sb.append(this.getBuildNumber());
        sb.append("[\\/]*");
        return sb.toString();
    }

    @Override
    public String getDatabase() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getDatabase();
    }

    @Override
    public String getDisplayName() {
        return JenkinsResultsParserUtil.combine(this.getAxisVariable(), " #", Integer.toString(this.getBuildNumber()));
    }

    @Override
    public Element getGitHubMessageElement() {
        Element failureMessageElement;
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        if (result.equals("ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
        }
        if (result.equals("FAILURE") && (failureMessageElement = this.getFailureMessageElement()) != null) {
            messageElement.add(failureMessageElement);
        }
        if (result.equals("UNSTABLE")) {
            String jobVariant = this.getParameterValue("JOB_VARIANT");
            Element downstreamBuildOrderedListElement = Dom4JUtil.getNewElement("ol", messageElement, new Object[0]);
            int failureCount = 0;
            for (TestResult testResult : this.getTestResults(null)) {
                String testStatus = testResult.getStatus();
                if (testStatus.equals("PASSED") || testStatus.equals("SKIPPED")) continue;
                Element downstreamBuildListItemElement = Dom4JUtil.getNewElement("li", downstreamBuildOrderedListElement, new Object[0]);
                if (failureCount < 3) {
                    downstreamBuildListItemElement.add(Dom4JUtil.getNewAnchorElement(testResult.getTestReportURL(), testResult.getDisplayName()));
                    if (jobVariant.contains("functional")) {
                        Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(testResult.getPoshiReportURL(), "Poshi Report"), " - ", Dom4JUtil.getNewAnchorElement(testResult.getPoshiSummaryURL(), "Poshi Summary"), " - ", Dom4JUtil.getNewAnchorElement(testResult.getConsoleOutputURL(), "Console Output"));
                        if (testResult.hasLiferayLog()) {
                            Dom4JUtil.addToElement(downstreamBuildListItemElement, " - ", Dom4JUtil.getNewAnchorElement(testResult.getLiferayLogURL(), "Liferay Log"));
                        }
                    }
                    ++failureCount;
                    continue;
                }
                downstreamBuildListItemElement.addText("...");
                break;
            }
        }
        return messageElement;
    }

    @Override
    public String getJDK() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getJDK();
    }

    @Override
    public String getOperatingSystem() {
        Build parentBuild = this.getParentBuild();
        return parentBuild.getOperatingSystem();
    }

    public String getTestRayLogsURL() {
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        Properties buildProperties = null;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build properties", ioe);
        }
        String logBaseURL = null;
        if (buildProperties.containsKey("log.base.url")) {
            logBaseURL = buildProperties.getProperty("log.base.url");
        }
        if (logBaseURL == null) {
            logBaseURL = defaultLogBaseURL;
        }
        Map<String, String> startPropertiesTempMap = this.getStartPropertiesTempMap();
        return JenkinsResultsParserUtil.combine(logBaseURL, "/", topLevelBuild.getMaster(), "/", startPropertiesTempMap.get("TOP_LEVEL_START_TIME"), "/", topLevelBuild.getJobName(), "/", Integer.toString(topLevelBuild.getBuildNumber()), "/", this.getParameterValue("JOB_VARIANT"), "/", this.getAxisNumber());
    }

    @Override
    public List<TestResult> getTestResults(String testStatus) {
        String status = this.getStatus();
        if (!status.equals("completed")) {
            return Collections.emptyList();
        }
        JSONObject testReportJSONObject = this.getTestReportJSONObject();
        return TestResult.getTestResults(this, testReportJSONObject.getJSONArray("suites"), testStatus);
    }

    @Override
    public void reinvoke() {
        throw new RuntimeException("Axis builds cannot be reinvoked");
    }

    protected AxisBuild(String url) {
        this(url, null);
    }

    protected AxisBuild(String url, BatchBuild parentBuild) {
        super(JenkinsResultsParserUtil.getLocalURL(url), parentBuild);
    }

    @Override
    protected void checkForReinvocation(String consoleText) {
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        return null;
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop-properties.json";
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", topLevelBuild.getMaster(), "/", topLevelBuild.getJobName(), "/", Integer.toString(topLevelBuild.getBuildNumber()), "/", this.getJobName(), "/", this.getAxisVariable(), "/", this.getParameterValue("JOB_VARIANT"), "/", "stop.properties");
    }

    @Override
    protected void setBuildURL(String buildURL) {
        try {
            buildURL = JenkinsResultsParserUtil.decode(buildURL);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalArgumentException("Unable to decode " + buildURL, uee);
        }
        try {
            String archiveMarkerContent = JenkinsResultsParserUtil.toString(buildURL + "/archive-marker", false, 0, 0, 0);
            this.fromArchive = archiveMarkerContent != null && !archiveMarkerContent.isEmpty();
        }
        catch (IOException ioe) {
            this.fromArchive = false;
        }
        Matcher matcher = buildURLPattern.matcher(buildURL);
        if (!matcher.find()) {
            matcher = archiveBuildURLPattern.matcher(buildURL);
            if (!matcher.find()) {
                throw new IllegalArgumentException("Invalid build URL " + buildURL);
            }
            this.archiveName = matcher.group("archiveName");
        }
        this.axisVariable = matcher.group("axisVariable");
        this.jobName = matcher.group("jobName");
        this.master = matcher.group("master");
        this.setBuildNumber(Integer.parseInt(matcher.group("buildNumber")));
        this.loadParametersFromBuildJSONObject();
        this.setStatus("running");
    }
}

