/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.AxisBuild;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TestResult {
    protected AxisBuild axisBuild;
    protected String className;
    protected long duration;
    protected String packageName;
    protected String simpleClassName;
    protected String status;
    protected String testName;

    public static List<TestResult> getTestResults(AxisBuild axisBuild, JSONArray suitesJSONArray, String testStatus) {
        ArrayList<TestResult> testResults = new ArrayList<TestResult>();
        for (int i = 0; i < suitesJSONArray.length(); ++i) {
            JSONObject suiteJSONObject = suitesJSONArray.getJSONObject(i);
            JSONArray casesJSONArray = suiteJSONObject.getJSONArray("cases");
            for (int j = 0; j < casesJSONArray.length(); ++j) {
                TestResult testResult = new TestResult(axisBuild, casesJSONArray.getJSONObject(j));
                if (testStatus != null && !testStatus.equals(testResult.getStatus())) continue;
                testResults.add(testResult);
            }
        }
        return testResults;
    }

    public TestResult(AxisBuild axisBuild, JSONObject caseJSONObject) {
        if (axisBuild == null) {
            throw new IllegalArgumentException("Axis build may not be null");
        }
        this.axisBuild = axisBuild;
        this.className = caseJSONObject.getString("className");
        this.duration = (long)(caseJSONObject.getDouble("duration") * 1000.0);
        int x = this.className.lastIndexOf(".");
        this.simpleClassName = this.className.substring(x + 1);
        this.packageName = this.className.substring(0, x);
        this.testName = caseJSONObject.getString("name");
        this.status = caseJSONObject.getString("status");
    }

    public AxisBuild getAxisBuild() {
        return this.axisBuild;
    }

    public String getClassName() {
        return this.className;
    }

    public String getConsoleOutputURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.axisBuild.getTestRayLogsURL());
        sb.append("/jenkins-console.txt.gz");
        return sb.toString();
    }

    public String getDisplayName() {
        if (this.testName.startsWith("test[")) {
            return this.testName.substring(5, this.testName.length() - 1);
        }
        return this.simpleClassName + "." + this.testName;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getLiferayLogURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.axisBuild.getTestRayLogsURL());
        sb.append("/");
        sb.append(name.replace("#", "_"));
        sb.append("/liferay-log.txt.gz");
        return sb.toString();
    }

    public String getPoshiReportURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.axisBuild.getTestRayLogsURL());
        sb.append("/");
        sb.append(name.replace("#", "_"));
        sb.append("/index.html.gz");
        return sb.toString();
    }

    public String getPoshiSummaryURL() {
        StringBuilder sb = new StringBuilder();
        String name = this.getDisplayName();
        sb.append(this.axisBuild.getTestRayLogsURL());
        sb.append("/");
        sb.append(name.replace("#", "_"));
        sb.append("/summary.html.gz");
        return sb.toString();
    }

    public String getStatus() {
        return this.status;
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTestReportURL() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.axisBuild.getBuildURL());
        sb.append("/testReport/");
        sb.append(this.packageName);
        sb.append("/");
        sb.append(this.simpleClassName);
        sb.append("/");
        String encodedTestName = this.testName;
        encodedTestName = encodedTestName.replace("[", "_");
        encodedTestName = encodedTestName.replace("]", "_");
        encodedTestName = encodedTestName.replace("#", "_");
        if (this.simpleClassName.equals("junit.framework")) {
            encodedTestName = encodedTestName.replace(".", "_");
        }
        sb.append(encodedTestName);
        return sb.toString();
    }

    public boolean hasLiferayLog() {
        String liferayLog = null;
        try {
            liferayLog = JenkinsResultsParserUtil.toString(this.getLiferayLogURL(), false, 0, 0, 0);
        }
        catch (IOException ioe) {
            return false;
        }
        return !liferayLog.isEmpty();
    }
}

