/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.jcraft.jsch.Session;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.DeleteBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.JschConfigSessionFactory;
import org.eclipse.jgit.transport.OpenSshConfig;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.json.JSONObject;

public class GitWorkingDirectory {
    private final Git _git;
    private File _gitDirectory;
    private final Repository _repository;
    private final String _repositoryName;
    private final String _repositoryUsername;
    private final String _upstreamBranchName;
    private File _workingDirectory;

    public GitWorkingDirectory(String workingDirectory) throws GitAPIException, InterruptedException, IOException {
        this("master", workingDirectory);
    }

    public GitWorkingDirectory(String upstreamBranchName, String workingDirectory) throws GitAPIException, InterruptedException, IOException {
        this._upstreamBranchName = upstreamBranchName;
        this._setWorkingDirectory(workingDirectory);
        this._waitForIndexLock();
        FileRepositoryBuilder fileRepositoryBuilder = new FileRepositoryBuilder();
        fileRepositoryBuilder.setGitDir(this._gitDirectory);
        fileRepositoryBuilder.setWorkTree(this._workingDirectory);
        this._repository = fileRepositoryBuilder.build();
        this._git = new Git(this._repository);
        this._repositoryName = this._getRepositoryName();
        this._repositoryUsername = this._getRepositoryUsername();
    }

    public void checkoutBranch(String branchName) throws InterruptedException, IOException {
        String content;
        System.out.println("Checkout branch " + branchName);
        this._waitForIndexLock();
        StringBuilder sb = new StringBuilder();
        sb.append("git checkout ");
        sb.append(branchName);
        JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, sb.toString());
        int timeout = 0;
        File file = new File(this._gitDirectory, "HEAD");
        while (!(content = JenkinsResultsParserUtil.read(file)).matches("ref: refs/heads/" + branchName + "\\n")) {
            System.out.println("Waiting for branch to be updated");
            Thread.sleep(5000L);
            if (++timeout < 24) continue;
            throw new InterruptedException("Unable to checkout branch " + branchName);
        }
    }

    public void commitFileToCurrentBranch(String fileName, String message) throws GitAPIException {
        System.out.println("Commit file to current branch " + fileName);
        this.stageFileInCurrentBranch(fileName);
        this.commitStagedFilesToCurrentBranch(message);
    }

    public void commitStagedFilesToCurrentBranch(String message) throws GitAPIException {
        System.out.println("Commit staged files to current branch");
        CommitCommand commitCommand = this._git.commit();
        commitCommand.setMessage(message);
        commitCommand.call();
    }

    public void createBranch(String branchName) throws GitAPIException {
        System.out.println("Create branch " + branchName);
        CreateBranchCommand createBranchCommand = this._git.branchCreate();
        createBranchCommand.setName(branchName);
        createBranchCommand.call();
    }

    public String createPullRequest(String title, String body, String receiverUserName, String pullRequestBranchName) throws IOException {
        JSONObject requestJSONObject = new JSONObject();
        requestJSONObject.put("base", (Object)this._upstreamBranchName);
        requestJSONObject.put("body", (Object)body);
        requestJSONObject.put("head", (Object)(receiverUserName + ":" + pullRequestBranchName));
        requestJSONObject.put("title", (Object)title);
        String url = JenkinsResultsParserUtil.combine("https://api.github.com/repos/", receiverUserName, "/", this._repositoryName, "/pulls");
        JSONObject responseJSONObject = JenkinsResultsParserUtil.toJSONObject(url, requestJSONObject.toString());
        String pullRequestURL = responseJSONObject.getString("url");
        System.out.println("Created a pull request at " + pullRequestURL);
        return pullRequestURL;
    }

    public void deleteBranch(String branchName) throws GitAPIException {
        System.out.println("Delete branch " + branchName);
        DeleteBranchCommand deleteBranchCommand = this._git.branchDelete();
        deleteBranchCommand.setBranchNames(new String[]{branchName});
        deleteBranchCommand.setForce(true);
        deleteBranchCommand.call();
    }

    public String getCurrentBranch() throws InterruptedException, IOException {
        this._waitForIndexLock();
        return this._repository.getBranch();
    }

    public String getRepositoryName() {
        return this._repositoryName;
    }

    public String getRepositoryUsername() {
        return this._repositoryUsername;
    }

    public String getUpstreamBranchName() {
        return this._upstreamBranchName;
    }

    public File getWorkingDirectory() {
        return this._workingDirectory;
    }

    public void pushBranchToOrigin(String branchName, String origin) throws GitAPIException {
        System.out.println("Push branch " + branchName + " to " + origin);
        PushCommand pushCommand = this._git.push();
        pushCommand.add(branchName);
        pushCommand.setRemote(origin);
        pushCommand.call();
    }

    public void resetHardToHEAD() throws GitAPIException, InterruptedException, IOException {
        System.out.println("Reset hard to HEAD");
        this._waitForIndexLock();
        JenkinsResultsParserUtil.executeBashCommands(true, this._workingDirectory, "git reset --hard");
    }

    public void stageFileInCurrentBranch(String fileName) throws GitAPIException {
        System.out.println("Stage file in current branch " + fileName);
        AddCommand addCommand = this._git.add();
        addCommand.addFilepattern(fileName);
        addCommand.call();
    }

    private String _getRepositoryName() {
        StoredConfig storedConfig = this._repository.getConfig();
        String remote = storedConfig.getString("remote", "upstream", "url");
        int x = remote.indexOf("/") + 1;
        int y = remote.indexOf(".git");
        String repositoryName = remote.substring(x, y);
        if (!this._upstreamBranchName.contains("ee-") && !this._upstreamBranchName.contains("-private")) {
            repositoryName = repositoryName.replace("-ee", "");
            repositoryName = repositoryName.replace("-private", "");
        }
        return repositoryName;
    }

    private String _getRepositoryUsername() {
        StoredConfig storedConfig = this._repository.getConfig();
        String remote = storedConfig.getString("remote", "upstream", "url");
        int x = remote.indexOf(":") + 1;
        int y = remote.indexOf("/");
        return remote.substring(x, y);
    }

    private void _setWorkingDirectory(String workingDirectory) throws GitAPIException, IOException {
        this._workingDirectory = new File(workingDirectory);
        if (!this._workingDirectory.exists()) {
            throw new FileNotFoundException(this._workingDirectory.getPath() + " is unavailable");
        }
        this._gitDirectory = new File(workingDirectory, ".git");
        if (!this._gitDirectory.exists()) {
            throw new FileNotFoundException(this._gitDirectory.getPath() + " is unavailable");
        }
    }

    private void _waitForIndexLock() throws InterruptedException {
        int timeout = 0;
        File file = new File(this._gitDirectory, "index.lock");
        while (file.exists()) {
            System.out.println("Waiting for index.lock to be cleared.");
            Thread.sleep(5000L);
            if (++timeout < 24) continue;
            file.delete();
        }
    }

    static {
        JschConfigSessionFactory jschConfigSessionFactory = new JschConfigSessionFactory(){

            protected void configure(OpenSshConfig.Host host, Session session) {
                session.setConfig("StrictHostKeyChecking", "no");
            }
        };
        SshSessionFactory.setInstance((SshSessionFactory)jschConfigSessionFactory);
    }
}

