/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import java.util.Hashtable;
import org.dom4j.Element;

public class RebaseFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final String _REBASE_END_STRING = "The copy of the patch that failed is found in";
    private static final String _REBASE_START_STRING = "First, rewinding head to replay your work on top of it...";

    @Override
    public String getMessage(String buildURL, String consoleOutput, Hashtable<?, ?> properties) {
        if (!(consoleOutput.contains(_REBASE_END_STRING) && consoleOutput.contains(_REBASE_START_STRING) && consoleOutput.contains("CONFLICT"))) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p>Please fix <strong>rebase errors</strong> on <strong>");
        sb.append("<a href=\"https://github.com/");
        sb.append(properties.get("github.origin.name"));
        sb.append("/");
        sb.append(properties.get("repository"));
        sb.append("/tree/");
        sb.append(properties.get("github.sender.branch.name"));
        sb.append("\">");
        sb.append(properties.get("github.origin.name"));
        sb.append("/");
        sb.append(properties.get("github.sender.branch.name"));
        sb.append("</a></strong>.</p>");
        int end = consoleOutput.indexOf(_REBASE_END_STRING);
        end = consoleOutput.lastIndexOf("\n", end);
        int start = consoleOutput.lastIndexOf(_REBASE_START_STRING, end);
        start = consoleOutput.lastIndexOf("\n", start);
        sb.append(this.getConsoleOutputSnippet(consoleOutput, true, start, end));
        return sb.toString();
    }

    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        if (!(consoleText.contains(_REBASE_END_STRING) && consoleText.contains(_REBASE_START_STRING) && consoleText.contains("CONFLICT"))) {
            return null;
        }
        int end = consoleText.indexOf(_REBASE_END_STRING);
        end = consoleText.lastIndexOf("\n", end);
        int start = consoleText.lastIndexOf(_REBASE_START_STRING, end);
        start = consoleText.lastIndexOf("\n", start);
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, "Please fix ", Dom4JUtil.getNewElement("strong", null, "rebase errors"), " on ", Dom4JUtil.getNewElement("strong", null, this.getBaseBranchAnchorElement(build.getTopLevelBuild())), this.getConsoleOutputSnippetElement(consoleText, true, start, end)));
    }
}

