/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.util.Hashtable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public abstract class BaseFailureMessageGenerator
implements FailureMessageGenerator {
    private static final Pattern _pattern = Pattern.compile("\\n[a-z\\-\\.]+\\:\\n");

    @Override
    public abstract String getMessage(String var1, String var2, Hashtable<?, ?> var3);

    @Override
    public abstract Element getMessageElement(Build var1);

    protected Element getBaseBranchAnchorElement(TopLevelBuild topLevelBuild) {
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        String baseRepositoryName = topLevelBuild.getBaseRepositoryName();
        Map<String, String> baseRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        sb.append(baseRepositoryGitDetailsTempMap.get("github.origin.name"));
        sb.append("/");
        sb.append(baseRepositoryName);
        sb.append("/tree/");
        sb.append(baseRepositoryGitDetailsTempMap.get("github.sender.branch.name"));
        String url = sb.toString();
        sb = new StringBuilder();
        sb.append(baseRepositoryGitDetailsTempMap.get("github.origin.name"));
        sb.append("/");
        sb.append(baseRepositoryGitDetailsTempMap.get("github.sender.branch.name"));
        return Dom4JUtil.getNewAnchorElement(url, sb.toString());
    }

    protected String getConsoleOutputSnippet(String consoleOutput, boolean truncateTop, int end) {
        if (end == -1) {
            end = consoleOutput.length();
        }
        int start = this.getSnippetStart(consoleOutput, end);
        return this.getConsoleOutputSnippet(consoleOutput, truncateTop, start, end);
    }

    protected String getConsoleOutputSnippet(String consoleOutput, boolean truncateTop, int start, int end) {
        return "<pre><code>" + this._getConsoleOutputSnippet(consoleOutput, truncateTop, start, end) + "</code></pre>";
    }

    protected Element getConsoleOutputSnippetElement(String consoleOutput, boolean truncateTop, int end) {
        if (end == -1) {
            end = consoleOutput.length();
        }
        int start = this.getSnippetStart(consoleOutput, end);
        return this.getConsoleOutputSnippetElement(consoleOutput, truncateTop, start, end);
    }

    protected Element getConsoleOutputSnippetElement(String consoleOutput, boolean truncateTop, int start, int end) {
        return Dom4JUtil.toCodeSnippetElement(this._getConsoleOutputSnippet(consoleOutput, truncateTop, start, end));
    }

    protected Element getGitCommitPluginsAnchorElement(TopLevelBuild topLevelBuild) {
        String repositoryName = topLevelBuild.getBaseRepositoryName();
        Map<String, String> portalRepositoryGitDetailsTempMap = topLevelBuild.getBaseGitRepositoryDetailsTempMap();
        Element gitCommitPluginsAnchorElement = Dom4JUtil.getNewElement("a");
        StringBuilder sb = new StringBuilder();
        sb.append("https://github.com/");
        sb.append(portalRepositoryGitDetailsTempMap.get("github.origin.name"));
        sb.append("/");
        sb.append(repositoryName);
        sb.append("/blob/");
        sb.append(portalRepositoryGitDetailsTempMap.get("github.sender.branch.name"));
        sb.append("/git-commit-plugins");
        gitCommitPluginsAnchorElement.addAttribute("href", sb.toString());
        gitCommitPluginsAnchorElement.addText("git-commit-plugins");
        return gitCommitPluginsAnchorElement;
    }

    protected int getSnippetStart(String consoleOutput, int end) {
        int start = 0;
        Matcher matcher = _pattern.matcher(consoleOutput);
        while (matcher.find()) {
            int x = matcher.start() + 1;
            if (x >= end) {
                return start;
            }
            start = x;
        }
        return start;
    }

    private String _getConsoleOutputSnippet(String consoleOutput, boolean truncateTop, int start, int end) {
        if (end - start > 2500) {
            if (truncateTop) {
                start = end - 2500;
                start = consoleOutput.indexOf("\n", start);
            } else {
                end = start + 2500;
                end = consoleOutput.lastIndexOf("\n", end);
            }
        }
        consoleOutput = consoleOutput.substring(start, end);
        consoleOutput = consoleOutput.replaceFirst("^\\s*\\n", "");
        consoleOutput = consoleOutput.replaceFirst("\\n\\s*$", "");
        return consoleOutput;
    }
}

