/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Iterator;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultElement;

public class Dom4JUtil {
    public static void addToElement(Element element, Object ... items) {
        for (int i = 0; i < items.length; ++i) {
            Object item = items[i];
            if (item == null) continue;
            if (item instanceof Element) {
                element.add((Element)item);
                continue;
            }
            if (item instanceof String) {
                element.addText((String)item);
                continue;
            }
            throw new IllegalArgumentException("Only elements and strings may be added");
        }
    }

    public static String format(Element element) throws IOException {
        return Dom4JUtil.format(element, true);
    }

    public static String format(Element element, boolean pretty) throws IOException {
        CharArrayWriter writer = new CharArrayWriter();
        OutputFormat outputFormat = OutputFormat.createPrettyPrint();
        outputFormat.setTrimText(false);
        XMLWriter xmlWriter = null;
        xmlWriter = pretty ? new XMLWriter((Writer)writer, outputFormat) : new XMLWriter((Writer)writer);
        xmlWriter.write(element);
        return ((Object)writer).toString();
    }

    public static Element getNewAnchorElement(String href, Element parentElement, Object ... items) {
        if (items == null || items.length == 0) {
            return null;
        }
        Element anchorElement = null;
        anchorElement = Dom4JUtil.getNewElement("a", parentElement, new Object[0]);
        anchorElement.addAttribute("href", href);
        Dom4JUtil.addToElement(anchorElement, items);
        return anchorElement;
    }

    public static Element getNewAnchorElement(String href, Object ... items) {
        return Dom4JUtil.getNewAnchorElement(href, null, items);
    }

    public static Element getNewElement(String childElementTag) {
        return Dom4JUtil.getNewElement(childElementTag, null, new Object[0]);
    }

    public static Element getNewElement(String childElementTag, Element parentElement, Object ... items) {
        DefaultElement childElement = new DefaultElement(childElementTag);
        if (parentElement != null) {
            parentElement.add((Element)childElement);
        }
        if (items != null && items.length > 0) {
            Dom4JUtil.addToElement((Element)childElement, items);
        }
        return childElement;
    }

    public static Document parse(String xml) throws DocumentException {
        SAXReader saxReader = new SAXReader();
        return saxReader.read((Reader)new StringReader(xml));
    }

    public static void replace(Element element, boolean cascade, String replacementText, String targetText) {
        Iterator attributeIterator = element.attributeIterator();
        while (attributeIterator.hasNext()) {
            Attribute attribute = (Attribute)attributeIterator.next();
            String text = attribute.getValue();
            attribute.setValue(text.replace(targetText, replacementText));
        }
        Iterator nodeIterator = element.nodeIterator();
        while (nodeIterator.hasNext()) {
            Node node = (Node)nodeIterator.next();
            if (node instanceof Text) {
                Text textNode = (Text)node;
                String text = textNode.getText();
                if (!text.contains(targetText)) continue;
                text = text.replace(targetText, replacementText);
                textNode.setText(text);
                continue;
            }
            if (!(node instanceof Element) || !cascade) continue;
            Dom4JUtil.replace((Element)node, cascade, replacementText, targetText);
        }
    }

    public static Element toCodeSnippetElement(String content) {
        return Dom4JUtil.getNewElement("pre", null, Dom4JUtil.getNewElement("code", null, JenkinsResultsParserUtil.redact(content)));
    }
}

