/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class FilePropagator {
    private final List<String> _busySlaves = new ArrayList<String>();
    private String _cleanUpCommand;
    private final List<String> _errorSlaves = new ArrayList<String>();
    private final List<FilePropagatorTask> _filePropagatorTasks = new ArrayList<FilePropagatorTask>();
    private final List<String> _mirrorSlaves = new ArrayList<String>();
    private final List<String> _targetSlaves = new ArrayList<String>();
    private int _threadsCompletedCount;
    private long _threadsDurationTotal;

    public FilePropagator(String[] fileNames, String sourceDirName, String targetDirName, List<String> targetSlaves) {
        for (String fileName : fileNames) {
            this._filePropagatorTasks.add(new FilePropagatorTask(sourceDirName + "/" + fileName, targetDirName + "/" + fileName));
        }
        this._targetSlaves.addAll(targetSlaves);
    }

    public long getAverageThreadDuration() {
        if (this._threadsCompletedCount == 0) {
            return 0L;
        }
        return this._threadsDurationTotal / (long)this._threadsCompletedCount;
    }

    public void setCleanUpCommand(String cleanUpCommand) {
        this._cleanUpCommand = cleanUpCommand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int threadCount) {
        this._copyFromSource();
        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        System.out.println("File propagation starting with " + threadCount + " threads.");
        try {
            long start = System.currentTimeMillis();
            while (!this._targetSlaves.isEmpty() || !this._busySlaves.isEmpty()) {
                FilePropagator filePropagator = this;
                synchronized (filePropagator) {
                    for (String mirrorSlave : this._mirrorSlaves) {
                        if (this._targetSlaves.isEmpty()) break;
                        String targetSlave = this._targetSlaves.remove(0);
                        executorService.execute(new FilePropagatorThread(this, mirrorSlave, targetSlave));
                        this._busySlaves.add(mirrorSlave);
                        this._busySlaves.add(targetSlave);
                    }
                    this._mirrorSlaves.removeAll(this._busySlaves);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("Average thread duration: ");
                sb.append(this.getAverageThreadDuration());
                sb.append("ms\nBusy slaves:");
                sb.append(this._busySlaves.size());
                sb.append("\nMirror slaves:");
                sb.append(this._mirrorSlaves.size());
                sb.append("\nTarget slaves:");
                sb.append(this._targetSlaves.size());
                sb.append("\nTotal duration: ");
                sb.append(System.currentTimeMillis() - start);
                sb.append("\n");
                System.out.println(sb.toString());
                JenkinsResultsParserUtil.sleep(5000L);
            }
            System.out.println("File propagation completed in " + (System.currentTimeMillis() - start) + "ms.");
            if (!this._errorSlaves.isEmpty()) {
                System.out.println(this._errorSlaves.size() + " slaves failed to respond:\n" + this._errorSlaves);
            }
        }
        finally {
            executorService.shutdown();
        }
    }

    private void _copyFromSource() {
        ArrayList<String> commands = new ArrayList<String>();
        String targetSlave = null;
        for (FilePropagatorTask filePropagatorTask : this._filePropagatorTasks) {
            targetSlave = this._targetSlaves.get(0);
            String sourceFileName = filePropagatorTask._sourceFileName;
            System.out.println("Copying from source " + sourceFileName);
            String targetFileName = filePropagatorTask._targetFileName;
            commands.add(this._getMkdirCommand(targetFileName));
            if (sourceFileName.startsWith("http")) {
                commands.add("curl -o " + targetFileName + " " + sourceFileName);
            } else {
                commands.add("rsync -svI " + sourceFileName + " " + targetFileName);
            }
            String targetDirName = targetFileName.substring(0, targetFileName.lastIndexOf("/"));
            commands.add("ls -al " + targetDirName);
        }
        try {
            if (this._executeBashCommands(commands, targetSlave) != 0) {
                this._errorSlaves.add(targetSlave);
                this._targetSlaves.remove(targetSlave);
                this._copyFromSource();
                targetSlave = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to copy from source. Executed: " + commands, e);
        }
        if (targetSlave != null) {
            this._mirrorSlaves.add(targetSlave);
            this._targetSlaves.remove(targetSlave);
        }
        System.out.println("Finished copying from source.");
    }

    private int _executeBashCommands(List<String> commands, String targetSlave) throws InterruptedException, IOException {
        StringBuffer sb = new StringBuffer("ssh -o PasswordAuthentication=no ");
        sb.append(targetSlave);
        sb.append(" '");
        if (this._cleanUpCommand != null && !this._cleanUpCommand.isEmpty()) {
            sb.append(this._cleanUpCommand);
            sb.append("; ");
        }
        for (int i = 0; i < commands.size(); ++i) {
            sb.append(commands.get(i));
            if (i >= commands.size() - 1) continue;
            sb.append(" && ");
        }
        sb.append("'");
        Process process = JenkinsResultsParserUtil.executeBashCommands(sb.toString());
        return process.exitValue();
    }

    private String _getMkdirCommand(String fileName) {
        String dirName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
        return "mkdir -p " + dirName;
    }

    private static class FilePropagatorThread
    implements Runnable {
        private long _duration;
        private final FilePropagator _filePropagator;
        private final String _mirrorSlave;
        private boolean _successful;
        private final String _targetSlave;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            List filePropagatorTasks = this._filePropagator._filePropagatorTasks;
            ArrayList<String> commands = new ArrayList<String>(filePropagatorTasks.size());
            for (FilePropagatorTask filePropagatorTask : filePropagatorTasks) {
                commands.add(this._filePropagator._getMkdirCommand(filePropagatorTask._targetFileName));
                commands.add("rsync -svI " + this._mirrorSlave + ":" + filePropagatorTask._targetFileName + " " + filePropagatorTask._targetFileName);
            }
            try {
                this._successful = this._filePropagator._executeBashCommands(commands, this._targetSlave) == 0;
            }
            catch (Exception e) {
                this._successful = false;
            }
            this._duration = System.currentTimeMillis() - start;
            FilePropagator filePropagator = this._filePropagator;
            synchronized (filePropagator) {
                this._filePropagator._busySlaves.remove(this._mirrorSlave);
                this._filePropagator._busySlaves.remove(this._targetSlave);
                this._filePropagator._mirrorSlaves.add(this._mirrorSlave);
                this._filePropagator._threadsCompletedCount++;
                FilePropagator filePropagator2 = this._filePropagator;
                filePropagator2._threadsDurationTotal = filePropagator2._threadsDurationTotal + this._duration;
                if (!this._successful) {
                    this._filePropagator._errorSlaves.add(this._targetSlave);
                    return;
                }
                this._filePropagator._mirrorSlaves.add(this._targetSlave);
            }
        }

        private FilePropagatorThread(FilePropagator filePropagator, String mirrorSlave, String targetSlave) {
            this._filePropagator = filePropagator;
            this._mirrorSlave = mirrorSlave;
            this._targetSlave = targetSlave;
        }
    }

    private static class FilePropagatorTask {
        private final String _sourceFileName;
        private final String _targetFileName;

        private FilePropagatorTask(String sourceFileName, String targetFileName) {
            this._sourceFileName = this._escapeParentheses(sourceFileName);
            this._targetFileName = this._escapeParentheses(targetFileName);
        }

        private String _escapeParentheses(String fileName) {
            fileName = fileName.replace(")", "\\)");
            fileName = fileName.replace("(", "\\(");
            return fileName;
        }
    }
}

