/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class IntegrationTestTimeoutFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final Pattern _pattern;

    @Override
    public String getMessage(String buildURL, String consoleOutput, Hashtable<?, ?> properties) {
        Matcher matcher = _pattern.matcher(consoleOutput);
        if (!matcher.find()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<p><strong>");
        sb.append(matcher.group("testName"));
        sb.append("</strong> was aborted because it exceeded the timeout ");
        sb.append("period.</p>");
        String snippet = matcher.group(0);
        sb.append(this.getConsoleOutputSnippet(snippet, false, 0, snippet.length()));
        return sb.toString();
    }

    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        Matcher matcher = _pattern.matcher(consoleText);
        if (!matcher.find()) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, Dom4JUtil.getNewElement("strong", null, matcher.group("testName")), " was aborted because it exceeded the timeout period."));
        String snippet = matcher.group(0);
        messageElement.add(this.getConsoleOutputSnippetElement(snippet, false, 0, snippet.length()));
        return messageElement;
    }

    static {
        StringBuilder sb = new StringBuilder();
        sb.append("Execution failed for task '(?<testName>[^']*)'\\.\\s*");
        sb.append("\\[exec\\] > Process 'Gradle Test Executor \\d+' finished ");
        sb.append("with non-zero exit value 200");
        _pattern = Pattern.compile(sb.toString());
    }
}

