/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import com.liferay.jenkins.results.parser.DownstreamFailureMessageGenerator;
import com.liferay.jenkins.results.parser.FailureMessageGenerator;
import com.liferay.jenkins.results.parser.GenericFailureMessageGenerator;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.PoshiValidationFailureMessageGenerator;
import com.liferay.jenkins.results.parser.RebaseFailureMessageGenerator;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;
import org.json.JSONObject;

public class TopLevelBuild
extends BaseBuild {
    protected static final Pattern gitRepositoryTempMapNamePattern = Pattern.compile("git\\.(?<repositoryType>.*)\\.properties");
    private static final long _DOWNSTREAM_BUILDS_LISTING_INTERVAL = 300000L;
    private static final FailureMessageGenerator[] _FAILURE_MESSAGE_GENERATORS = new FailureMessageGenerator[]{new PoshiValidationFailureMessageGenerator(), new RebaseFailureMessageGenerator(), new DownstreamFailureMessageGenerator(), new GenericFailureMessageGenerator()};
    private long _lastDownstreamBuildsListingTimestamp = -1L;
    private long _updateDuration;

    @Override
    public void archive(String archiveName) {
        super.archive(archiveName);
        if (this.getParentBuild() == null) {
            Properties archiveProperties = new Properties();
            archiveProperties.setProperty("top.level.build.url", this.replaceBuildURL(this.getBuildURL()));
            try {
                StringWriter sw = new StringWriter();
                archiveProperties.store(sw, null);
                this.writeArchiveFile(sw.toString(), archiveName + "/archive.properties");
            }
            catch (IOException ioe) {
                throw new RuntimeException("Unable to write archive properties");
            }
        }
        try {
            this.writeArchiveFile(this.getJenkinsReport(), this.getArchivePath() + "/jenkins-report.html");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to archive Jenkins report", ioe);
        }
    }

    public Map<String, String> getBaseGitRepositoryDetailsTempMap() {
        String repositoryType = this.getBaseRepositoryType();
        String tempMapName = "git." + repositoryType + ".properties";
        return this.getTempMap(tempMapName);
    }

    @Override
    public String getDisplayName() {
        String displayName = super.getDisplayName();
        if (this.getParentBuild() != null) {
            displayName = displayName + "/" + this.getParameterValue("JENKINS_JOB_VARIANT");
        }
        return displayName;
    }

    @Override
    public Element getGitHubMessageElement() {
        Collections.sort(this.downstreamBuilds, new BaseBuild.BuildDisplayNameComparator());
        if (this.getParentBuild() == null) {
            return this.getTopGitHubMessageElement();
        }
        return super.getGitHubMessageElement();
    }

    public String getJenkinsReport() {
        try {
            return JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(this.getJenkinsReportURL()));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get Jenkins report", ioe);
        }
    }

    public String getJenkinsReportURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/jenkins-report.html";
        }
        return JenkinsResultsParserUtil.combine("https://", this.getMaster(), ".liferay.com/", "userContent/jobs/", this.getJobName(), "/builds/", Integer.toString(this.getBuildNumber()), "/jenkins-report.html");
    }

    @Override
    public String getStatusReport(int indentSize) {
        String statusReport = super.getStatusReport(indentSize);
        if (this.getDownstreamBuildCount(null) > 0) {
            while (statusReport.endsWith("\n")) {
                statusReport = statusReport.substring(0, statusReport.length() - 1);
            }
            statusReport = statusReport + " / ";
        }
        return statusReport + "Update took " + this._updateDuration + " milliseconds.\n";
    }

    @Override
    public String getStatusSummary() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - 300000L >= this._lastDownstreamBuildsListingTimestamp) {
            StringBuilder sb = new StringBuilder(super.getStatusSummary());
            sb.append("\nRunning Builds: ");
            this._lastDownstreamBuildsListingTimestamp = System.currentTimeMillis();
            for (Build downstreamBuild : this.getDownstreamBuilds("running")) {
                sb.append("\n");
                sb.append(downstreamBuild.getBuildURL());
            }
            return sb.toString();
        }
        return super.getStatusSummary();
    }

    @Override
    public JSONObject getTestReportJSONObject() {
        return null;
    }

    @Override
    public void update() {
        long start = System.currentTimeMillis();
        super.update();
        this._updateDuration = System.currentTimeMillis() - start;
    }

    protected TopLevelBuild(String url) {
        this(url, null);
    }

    protected TopLevelBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    protected void archiveJSON() {
        super.archiveJSON();
        try {
            Properties buildProperties = JenkinsResultsParserUtil.getBuildProperties();
            String repositoryTypes = buildProperties.getProperty("repository.types");
            if (this.jobName.startsWith("test-subrepository-acceptance-pullrequest")) {
                repositoryTypes = repositoryTypes + "," + this.getBaseRepositoryName();
            }
            for (String repositoryType : repositoryTypes.split(",")) {
                try {
                    JSONObject gitRepositoryDetailsJSONObject = JenkinsResultsParserUtil.toJSONObject(this.getGitRepositoryDetailsPropertiesTempMapURL(repositoryType));
                    Set set = gitRepositoryDetailsJSONObject.keySet();
                    if (set.isEmpty()) continue;
                    this.writeArchiveFile(gitRepositoryDetailsJSONObject.toString(4), this.getArchivePath() + "/git." + repositoryType + ".properties.json");
                }
                catch (IOException ioe) {
                    throw new RuntimeException("Unable to create git." + repositoryType + ".properties.json", ioe);
                }
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build properties", ioe);
        }
    }

    protected Element getBaseBranchDetailsElement() {
        String baseBranchURL = "https://github.com/liferay/" + this.getBaseRepositoryName() + "/tree/" + this.getBranchName();
        String baseRepositoryName = this.getBaseRepositoryName();
        String baseRepositorySHA = null;
        baseRepositorySHA = !baseRepositoryName.equals("liferay-jenkins-ee") && baseRepositoryName.endsWith("-ee") ? this.getBaseRepositorySHA(baseRepositoryName.substring(0, baseRepositoryName.length() - 3)) : this.getBaseRepositorySHA(baseRepositoryName);
        String baseRepositoryCommitURL = "https://github.com/liferay/" + baseRepositoryName + "/commit/" + baseRepositorySHA;
        Element baseBranchDetailsElement = Dom4JUtil.getNewElement("p", null, "Branch Name: ", Dom4JUtil.getNewAnchorElement(baseBranchURL, this.getBranchName()));
        if (baseRepositorySHA != null) {
            Dom4JUtil.addToElement(baseBranchDetailsElement, Dom4JUtil.getNewElement("br"), "Branch GIT ID: ", Dom4JUtil.getNewAnchorElement(baseRepositoryCommitURL, baseRepositorySHA));
        }
        return baseBranchDetailsElement;
    }

    protected Element getBuildTimeElement() {
        return Dom4JUtil.getNewElement("p", null, "Build Time: ", JenkinsResultsParserUtil.toDurationString(this.getDuration()));
    }

    protected Element getDownstreamGitHubMessageElement() {
        Element failureMessageElement;
        String status = this.getStatus();
        if (!status.equals("completed") && this.getParentBuild() != null) {
            return null;
        }
        String result = this.getResult();
        if (result.equals("SUCCESS")) {
            return null;
        }
        Element messageElement = Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewAnchorElement(this.getBuildURL(), null, this.getDisplayName()));
        if (result.equals("ABORTED")) {
            messageElement.add(Dom4JUtil.toCodeSnippetElement("Build was aborted"));
        }
        if (result.equals("FAILURE") && (failureMessageElement = this.getFailureMessageElement()) != null) {
            messageElement.add(failureMessageElement);
        }
        return messageElement;
    }

    @Override
    protected ExecutorService getExecutorService() {
        return Executors.newFixedThreadPool(20);
    }

    @Override
    protected FailureMessageGenerator[] getFailureMessageGenerators() {
        return _FAILURE_MESSAGE_GENERATORS;
    }

    @Override
    protected Element getGitHubMessageJobResultsElement() {
        int successCount = this.getDownstreamBuildCountByResult("SUCCESS");
        int failCount = this.getDownstreamBuildCount(null) - successCount + 1;
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("h6", null, "Job Results:"), Dom4JUtil.getNewElement("p", null, Integer.toString(successCount), JenkinsResultsParserUtil.getNounForm(successCount, " Jobs", " Job"), " Passed.", Dom4JUtil.getNewElement("br"), Integer.toString(failCount), JenkinsResultsParserUtil.getNounForm(failCount, " Jobs", " Job"), " Failed."));
    }

    protected String getGitRepositoryDetailsPropertiesTempMapURL(String repositoryType) {
        if (this.fromArchive) {
            return JenkinsResultsParserUtil.combine(this.getBuildURL(), "git.", repositoryType, ".properties.json");
        }
        TopLevelBuild topLevelBuild = this.getTopLevelBuild();
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", topLevelBuild.getMaster(), "/", topLevelBuild.getJobName(), "/", Integer.toString(topLevelBuild.getBuildNumber()), "/", topLevelBuild.getJobName(), "/git.", repositoryType, ".properties");
    }

    protected Element getJobSummaryListElement() {
        Element jobSummaryListElement = Dom4JUtil.getNewElement("ul");
        ArrayList<Build> builds = new ArrayList<Build>();
        builds.add(this);
        builds.addAll(this.getDownstreamBuilds(null));
        for (Build build : builds) {
            Element jobSummaryListItemElement = Dom4JUtil.getNewElement("li", jobSummaryListElement, new Object[0]);
            jobSummaryListItemElement.add(build.getGitHubMessageBuildAnchorElement());
        }
        return jobSummaryListElement;
    }

    protected Element getMoreDetailsElement() {
        Element moreDetailsElement = Dom4JUtil.getNewElement("h5", null, "For more details click ", Dom4JUtil.getNewAnchorElement(this.getJenkinsReportURL(), "here"), ".");
        return moreDetailsElement;
    }

    protected Element getResultElement() {
        Element resultElement = Dom4JUtil.getNewElement("h1");
        String result = this.getResult();
        if (!result.equals("SUCCESS")) {
            resultElement.addText("Some tests FAILED.");
        } else {
            resultElement.addText("All tests PASSED.");
        }
        return resultElement;
    }

    @Override
    protected String getStartPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/start.properties.json";
        }
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", this.getMaster(), "/", this.getJobName(), "/", Integer.toString(this.getBuildNumber()), "/", this.getJobName(), "/", "start.properties");
    }

    @Override
    protected String getStopPropertiesTempMapURL() {
        if (this.fromArchive) {
            return this.getBuildURL() + "/stop.properties.json";
        }
        return JenkinsResultsParserUtil.combine("http://cloud-10-0-0-31.lax.liferay.com/osb-jenkins-web/map/", this.getMaster(), "/", this.getJobName(), "/", Integer.toString(this.getBuildNumber()), "/", this.getJobName(), "/", "stop.properties");
    }

    @Override
    protected String getTempMapURL(String tempMapName) {
        String tempMapURL = super.getTempMapURL(tempMapName);
        if (tempMapURL != null) {
            return tempMapURL;
        }
        Matcher matcher = gitRepositoryTempMapNamePattern.matcher(tempMapName);
        if (matcher.find()) {
            return this.getGitRepositoryDetailsPropertiesTempMapURL(matcher.group("repositoryType"));
        }
        return null;
    }

    protected Element getTopGitHubMessageElement() {
        this.update();
        Element rootElement = Dom4JUtil.getNewElement("html", null, this.getResultElement(), this.getBuildTimeElement(), Dom4JUtil.getNewElement("h4", null, "Base Branch:"), this.getBaseBranchDetailsElement(), Dom4JUtil.getNewElement("h4", null, "Job Summary:"), this.getJobSummaryListElement(), this.getMoreDetailsElement());
        String result = this.getResult();
        if (!result.equals("SUCCESS")) {
            String jobName;
            Dom4JUtil.addToElement(rootElement, Dom4JUtil.getNewElement("hr"), Dom4JUtil.getNewElement("h4", null, "Failed Jobs:"));
            Element failedJobsOrderedListElement = Dom4JUtil.getNewElement("ol", rootElement, Dom4JUtil.getNewElement("li", null, super.getGitHubMessageElement()));
            int failureCount = 1;
            ArrayList<Element> failureElements = new ArrayList<Element>();
            for (Build downstreamBuild : this.getDownstreamBuilds(null)) {
                String downstreamBuildResult = downstreamBuild.getResult();
                if (downstreamBuildResult.equals("SUCCESS")) continue;
                Element failureElement = downstreamBuild.getGitHubMessageElement();
                if (TopLevelBuild.isHighPriorityBuildFailureElement(failureElement)) {
                    failureElements.add(0, failureElement);
                    continue;
                }
                failureElements.add(downstreamBuild.getGitHubMessageElement());
            }
            for (Element failureElement : failureElements) {
                Element failedJobsListItemElement = Dom4JUtil.getNewElement("li", failedJobsOrderedListElement, new Object[0]);
                if (failureCount == 5) {
                    failedJobsListItemElement.addText("...");
                    break;
                }
                failedJobsListItemElement.add(failureElement);
                ++failureCount;
            }
            if ((jobName = this.getJobName()).contains("pullrequest")) {
                String url = JenkinsResultsParserUtil.combine("https://test-1-1.liferay.com/job/", jobName.replace("pullrequest", "upstream"));
                try {
                    JenkinsResultsParserUtil.toString(JenkinsResultsParserUtil.getLocalURL(url), false, 0, 0, 0);
                    Dom4JUtil.addToElement(Dom4JUtil.getNewElement("h5", rootElement, new Object[0]), "For upstream results, click ", Dom4JUtil.getNewAnchorElement(url, "here"), ".");
                }
                catch (IOException ioe) {
                    System.out.println("No upstream build detected.");
                }
            }
        }
        return rootElement;
    }

    protected String getUpstreamBranchSHA() {
        String upstreamBranchSHA = this.getParameterValue("GITHUB_UPSTREAM_BRANCH_SHA");
        if (upstreamBranchSHA == null || upstreamBranchSHA.isEmpty()) {
            Map<String, String> startPropertiesTempMap = this.getStartPropertiesTempMap();
            upstreamBranchSHA = startPropertiesTempMap.get("GITHUB_UPSTREAM_BRANCH_SHA");
        }
        return upstreamBranchSHA;
    }
}

