/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.Build;
import java.util.Hashtable;
import org.dom4j.Element;

public class GenericFailureMessageGenerator
extends BaseFailureMessageGenerator {
    @Override
    public String getMessage(String buildURL, String consoleOutput, Hashtable<?, ?> properties) {
        String message = this.getExceptionSnippet(consoleOutput);
        if (message != null) {
            return message;
        }
        message = this.getMergeTestResultsSnippet(consoleOutput);
        if (message != null) {
            return message;
        }
        message = this.getBuildFailedSnippet(consoleOutput);
        if (message != null) {
            return message;
        }
        return this.getConsoleOutputSnippet(consoleOutput, true, -1);
    }

    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        Element message = this.getExceptionSnippetElement(consoleText);
        if (message != null) {
            return message;
        }
        message = this.getMergeTestResultsSnippetElement(consoleText);
        if (message != null) {
            return message;
        }
        message = this.getBuildFailedSnippetElement(consoleText);
        if (message != null) {
            return message;
        }
        return this.getConsoleOutputSnippetElement(consoleText, true, -1);
    }

    protected String getBuildFailedSnippet(String consoleOutput) {
        int end = consoleOutput.indexOf("BUILD FAILED");
        if (end == -1) {
            return null;
        }
        end = consoleOutput.indexOf("Total time:", end);
        return this.getConsoleOutputSnippet(consoleOutput, true, end);
    }

    protected Element getBuildFailedSnippetElement(String consoleOutput) {
        int end = consoleOutput.indexOf("BUILD FAILED");
        if (end == -1) {
            return null;
        }
        end = consoleOutput.indexOf("Total time:", end);
        return this.getConsoleOutputSnippetElement(consoleOutput, true, end);
    }

    protected String getExceptionSnippet(String consoleOutput) {
        int end = consoleOutput.indexOf("[exec] * Exception is:");
        if (end == -1) {
            return null;
        }
        end = consoleOutput.indexOf("\n", end + 500);
        return this.getConsoleOutputSnippet(consoleOutput, true, end);
    }

    protected Element getExceptionSnippetElement(String consoleOutput) {
        int end = consoleOutput.indexOf("[exec] * Exception is:");
        if (end == -1) {
            return null;
        }
        end = consoleOutput.indexOf("\n", end + 500);
        return this.getConsoleOutputSnippetElement(consoleOutput, true, end);
    }

    protected String getMergeTestResultsSnippet(String consoleOutput) {
        int end = consoleOutput.indexOf("merge-test-results:");
        if (end == -1) {
            return null;
        }
        return this.getConsoleOutputSnippet(consoleOutput, true, end);
    }

    protected Element getMergeTestResultsSnippetElement(String consoleOutput) {
        int end = consoleOutput.indexOf("merge-test-results:");
        if (end == -1) {
            return null;
        }
        return this.getConsoleOutputSnippetElement(consoleOutput, true, end);
    }
}

