/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.GitWorkingDirectory;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.RemoteConfig;

public class LocalGitSyncUtil {
    private static final long _BRANCH_EXPIRE_AGE_MILLIS = 172800000L;
    private static final String _cacheBranchRegex = ".*cache-.+-.+-.+-[^-]+";
    private static final Pattern _cacheTimestampBranchPattern = Pattern.compile("(?<name>cache-.*)-(?<timestamp>\\d+)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCacheBranch(GitWorkingDirectory gitWorkingDirectory, String receiverUsername, String senderBranchName, String senderUsername, String senderBranchSHA, String upstreamBranchSHA) throws GitAPIException {
        List<RemoteConfig> localGitRemoteConfigs = null;
        try {
            localGitRemoteConfigs = LocalGitSyncUtil.getLocalGitRemoteConfigs(gitWorkingDirectory);
            LocalGitSyncUtil.deleteCacheBranch(LocalGitSyncUtil.getCacheBranchName(receiverUsername, senderUsername, senderBranchSHA, upstreamBranchSHA), gitWorkingDirectory, localGitRemoteConfigs);
        }
        finally {
            if (localGitRemoteConfigs != null) {
                gitWorkingDirectory.removeRemotes(localGitRemoteConfigs);
            }
        }
    }

    public static List<RemoteConfig> getLocalGitRemoteConfigs(GitWorkingDirectory gitWorkingDirectory) throws GitAPIException {
        List<String> localGitRemoteURLs = LocalGitSyncUtil.getLocalGitRemoteURLs(gitWorkingDirectory);
        ArrayList<RemoteConfig> localGitRemoteConfigs = new ArrayList<RemoteConfig>(localGitRemoteURLs.size());
        for (String localGitRemoteURL : localGitRemoteURLs) {
            String url = localGitRemoteURL.replace("${username}", gitWorkingDirectory.getRepositoryUsername());
            url = url.replace("${repository-name}", gitWorkingDirectory.getRepositoryName());
            String localGitRemoteName = "local-git-remote-" + localGitRemoteURLs.indexOf(localGitRemoteURL);
            RemoteConfig remoteConfig = gitWorkingDirectory.getRemoteConfig(localGitRemoteName);
            if (remoteConfig == null || !url.equals(GitWorkingDirectory.getRemoteURL(remoteConfig))) {
                remoteConfig = gitWorkingDirectory.addRemote(true, localGitRemoteName, url);
            }
            localGitRemoteConfigs.add(remoteConfig);
        }
        return localGitRemoteConfigs;
    }

    public static String synchronizeToLocalGit(GitWorkingDirectory gitWorkingDirectory, String receiverUsername, String senderBranchName, String senderUsername, String senderBranchSHA, String upstreamBranchSHA) throws GitAPIException, IOException {
        return LocalGitSyncUtil.synchronizeToLocalGit(gitWorkingDirectory, receiverUsername, 0, senderBranchName, senderUsername, senderBranchSHA, upstreamBranchSHA);
    }

    protected static void cacheBranch(GitWorkingDirectory gitWorkingDirectory, String localBranchName, RemoteConfig remoteConfig, long timestamp) throws GitAPIException {
        gitWorkingDirectory.pushToRemote(true, remoteConfig);
        gitWorkingDirectory.pushToRemote(true, JenkinsResultsParserUtil.combine(localBranchName, "-", Long.toString(timestamp)), remoteConfig);
    }

    protected static void cacheBranches(final GitWorkingDirectory gitWorkingDirectory, final String localBranchName, List<RemoteConfig> localGitRemoteConfigs, final String upstreamBranchName, final String upstreamUsername) throws GitAPIException {
        if (!localBranchName.equals(gitWorkingDirectory.getCurrentBranch())) {
            gitWorkingDirectory.checkoutBranch(localBranchName, "-f");
        }
        final long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(localGitRemoteConfigs.size());
        for (final RemoteConfig localGitRemoteConfig : localGitRemoteConfigs) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalGitSyncUtil.cacheBranch(gitWorkingDirectory, localBranchName, localGitRemoteConfig, start);
                        if (upstreamUsername.equals("liferay")) {
                            gitWorkingDirectory.pushToRemote(true, upstreamBranchName, upstreamBranchName, localGitRemoteConfig);
                        }
                    }
                    catch (GitAPIException gapie) {
                        throw new RuntimeException(gapie);
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Cache branches pushed up in " + JenkinsResultsParserUtil.toDurationString(duration));
    }

    protected static void checkoutUpstreamBranch(GitWorkingDirectory gitWorkingDirectory) throws GitAPIException {
        String upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
        if (!gitWorkingDirectory.branchExists(upstreamBranchName, null)) {
            RemoteConfig upstreamRemoteConfig = gitWorkingDirectory.getRemoteConfig("upstream");
            LocalGitSyncUtil.updateLocalUpstreamBranch(gitWorkingDirectory, upstreamBranchName, gitWorkingDirectory.getBranchSHA(gitWorkingDirectory.getUpstreamBranchName(), upstreamRemoteConfig), upstreamRemoteConfig);
        }
        gitWorkingDirectory.checkoutBranch(upstreamBranchName);
    }

    protected static void copyUpstreamRefsToHeads(GitWorkingDirectory gitWorkingDirectory) throws IOException {
        File gitDir = gitWorkingDirectory.getGitDirectory();
        File headsDir = new File(gitDir, "refs/heads");
        File upstreamDir = new File(gitDir, "refs/remotes/upstream-temp");
        for (File file : upstreamDir.listFiles()) {
            System.out.println(JenkinsResultsParserUtil.combine("Copying ", headsDir.getPath(), " to ", upstreamDir.getPath()));
            JenkinsResultsParserUtil.copy(file, new File(headsDir, file.getName()));
        }
    }

    protected static void deleteCacheBranch(final String cacheBranchName, final GitWorkingDirectory gitWorkingDirectory, List<RemoteConfig> localGitRemoteConfigs) throws GitAPIException {
        long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(localGitRemoteConfigs.size());
        for (final RemoteConfig localGitRemoteConfig : localGitRemoteConfigs) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalGitSyncUtil.deleteRemoteCacheBranch(cacheBranchName, gitWorkingDirectory, localGitRemoteConfig);
                    }
                    catch (GitAPIException gapie) {
                        throw new RuntimeException(gapie);
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(15L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Expired cache branches deleted in " + JenkinsResultsParserUtil.toDurationString(duration));
    }

    protected static void deleteExpiredCacheBranches(final GitWorkingDirectory gitWorkingDirectory, List<RemoteConfig> localGitRemoteConfigs) throws GitAPIException {
        final long start = System.currentTimeMillis();
        ExecutorService executorService = Executors.newFixedThreadPool(localGitRemoteConfigs.size());
        for (final RemoteConfig localGitRemoteConfig : localGitRemoteConfigs) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LocalGitSyncUtil.deleteExpiredCacheBranches(gitWorkingDirectory, localGitRemoteConfig, start);
                    }
                    catch (GitAPIException gapie) {
                        throw new RuntimeException(gapie);
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(15L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("Expired cache branches deleted in " + JenkinsResultsParserUtil.toDurationString(duration));
    }

    protected static void deleteExpiredCacheBranches(GitWorkingDirectory gitWorkingDirectory, RemoteConfig remoteConfig, long timestamp) throws GitAPIException {
        int branchCount = 0;
        int deleteCount = 0;
        long oldestBranchAge = Long.MIN_VALUE;
        List<String> remoteRepositoryBranchNames = null;
        try {
            remoteRepositoryBranchNames = gitWorkingDirectory.getRemoteBranchNames(remoteConfig);
        }
        catch (GitAPIException gapie) {
            System.out.println("Unable to get remote repository branch names from " + GitWorkingDirectory.getRemoteURL(remoteConfig));
            gapie.printStackTrace();
            return;
        }
        for (String remoteBranchName : remoteRepositoryBranchNames) {
            Matcher matcher = _cacheTimestampBranchPattern.matcher(remoteBranchName);
            if (!matcher.matches()) continue;
            ++branchCount;
            long remoteBranchTimestamp = Long.parseLong(matcher.group("timestamp"));
            long branchAge = timestamp - remoteBranchTimestamp;
            if (branchAge > 172800000L) {
                try {
                    LocalGitSyncUtil.deleteRemoteRepositoryCacheBranch(gitWorkingDirectory, matcher.group("name"), remoteConfig);
                    LocalGitSyncUtil.deleteRemoteRepositoryCacheBranch(gitWorkingDirectory, remoteBranchName, remoteConfig);
                    ++deleteCount;
                }
                catch (GitAPIException gapie) {
                    System.out.println(JenkinsResultsParserUtil.combine("Unable to delete cache branch ", remoteBranchName, " from ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
                    gapie.printStackTrace();
                }
                continue;
            }
            oldestBranchAge = Math.max(oldestBranchAge, branchAge);
        }
        System.out.println(JenkinsResultsParserUtil.combine("Found ", Integer.toString(branchCount), " cache branches on ", GitWorkingDirectory.getRemoteURL(remoteConfig), " ", Integer.toString(deleteCount), " were deleted. ", Integer.toString(branchCount - deleteCount), " remain. The oldest branch is ", JenkinsResultsParserUtil.toDurationString(oldestBranchAge), " old."));
    }

    protected static void deleteLocalCacheBranches(String excludeBranchName, GitWorkingDirectory gitWorkingDirectory) throws GitAPIException {
        for (String localBranchName : gitWorkingDirectory.getLocalBranchNames()) {
            if (!localBranchName.matches(_cacheBranchRegex) || localBranchName.equals(excludeBranchName)) continue;
            gitWorkingDirectory.deleteLocalBranch(localBranchName);
        }
    }

    protected static void deleteRemoteCacheBranch(String cacheBranchName, GitWorkingDirectory gitWorkingDirectory, RemoteConfig remoteConfig) throws GitAPIException {
        for (String remoteBranchName : gitWorkingDirectory.getRemoteBranchNames(remoteConfig)) {
            if (!remoteBranchName.startsWith(cacheBranchName)) continue;
            try {
                LocalGitSyncUtil.deleteRemoteRepositoryCacheBranch(gitWorkingDirectory, remoteBranchName, remoteConfig);
            }
            catch (GitAPIException gapie) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to delete cache branch ", remoteBranchName, " from ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
                gapie.printStackTrace();
            }
        }
    }

    protected static void deleteRemoteRepositoryCacheBranch(GitWorkingDirectory gitWorkingDirectory, String remoteBranchName, RemoteConfig remoteConfig) throws GitAPIException {
        if (gitWorkingDirectory.pushToRemote(true, "", remoteBranchName, remoteConfig)) {
            System.out.println(JenkinsResultsParserUtil.combine("Deleted ", remoteBranchName, " from ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
        } else {
            System.out.println(JenkinsResultsParserUtil.combine("Unable to delete ", remoteBranchName, " from ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
        }
    }

    protected static String getCacheBranchName(String receiverUsername, String senderUsername, String senderSHA, String upstreamSHA) {
        return JenkinsResultsParserUtil.combine("cache-", receiverUsername, "-", upstreamSHA, "-", senderUsername, "-", senderSHA);
    }

    protected static String getGitHubRemoteURL(String repositoryName, String userName) {
        return JenkinsResultsParserUtil.combine("git@github.com:", userName, "/", repositoryName, ".git");
    }

    protected static List<String> getLocalGitRemoteURLs(GitWorkingDirectory gitWorkingDirectory) {
        Properties buildProperties;
        try {
            buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build properties");
        }
        String gitCacheHostnamesPropertyValue = buildProperties.getProperty("github.cache.hostnames");
        String[] gitCacheHostnames = gitCacheHostnamesPropertyValue.split(",");
        ArrayList<String> localGitRemoteURLs = new ArrayList<String>(gitCacheHostnames.length);
        for (String gitCacheHostname : gitCacheHostnames) {
            if (gitCacheHostname.startsWith("file:") || gitCacheHostname.startsWith("http:")) {
                localGitRemoteURLs.add(gitCacheHostname);
                continue;
            }
            localGitRemoteURLs.add(JenkinsResultsParserUtil.combine("git@", gitCacheHostname, ":", gitWorkingDirectory.getRepositoryUsername(), "/", gitWorkingDirectory.getRepositoryName(), ".git"));
        }
        return localGitRemoteURLs;
    }

    protected static RemoteConfig getRandomRemoteConfig(List<RemoteConfig> remoteConfigs) {
        return remoteConfigs.get(JenkinsResultsParserUtil.getRandomValue(0, remoteConfigs.size() - 1));
    }

    protected static List<String> getRemoteCacheBranchNames(GitWorkingDirectory gitWorkingDirectory, RemoteConfig remoteConfig) throws GitAPIException {
        ArrayList<String> remoteCacheBranchNames = new ArrayList<String>();
        List<String> remoteBranchNames = gitWorkingDirectory.getRemoteBranchNames(remoteConfig);
        for (String remoteBranchName : remoteBranchNames) {
            if (!remoteBranchName.matches(_cacheBranchRegex)) continue;
            if (LocalGitSyncUtil.hasTimestampBranch(remoteBranchName, remoteBranchNames)) {
                remoteCacheBranchNames.add(remoteBranchName);
                continue;
            }
            LocalGitSyncUtil.deleteRemoteCacheBranch(remoteBranchName, gitWorkingDirectory, remoteConfig);
        }
        return remoteCacheBranchNames;
    }

    protected static boolean hasTimestampBranch(String cacheBranchName, List<String> remoteBranchNames) {
        for (String remoteBranchName : remoteBranchNames) {
            Matcher matcher = _cacheTimestampBranchPattern.matcher(remoteBranchName);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    protected static boolean isBranchCached(String branchName, GitWorkingDirectory gitWorkingDirectory, List<RemoteConfig> remoteConfigs) {
        for (RemoteConfig remoteConfig : remoteConfigs) {
            try {
                if (gitWorkingDirectory.branchExists(branchName, remoteConfig)) {
                    continue;
                }
            }
            catch (GitAPIException gapie) {
                System.out.println(JenkinsResultsParserUtil.combine("Unable to determine if branch ", branchName, " exists on ", GitWorkingDirectory.getRemoteURL(remoteConfig)));
                gapie.printStackTrace();
            }
            return false;
        }
        return true;
    }

    protected static Map<RemoteConfig, Boolean> pushToAllRemotes(final boolean force, final GitWorkingDirectory gitWorkingDirectory, final String localBranchName, final String remoteBranchName, List<RemoteConfig> remoteConfigs) throws GitAPIException {
        if (!localBranchName.isEmpty() && !localBranchName.equals(gitWorkingDirectory.getCurrentBranch())) {
            gitWorkingDirectory.checkoutBranch(localBranchName, "-f");
        }
        long start = System.currentTimeMillis();
        final Map<RemoteConfig, Boolean> resultsMap = Collections.synchronizedMap(new HashMap(remoteConfigs.size()));
        ExecutorService executorService = Executors.newFixedThreadPool(remoteConfigs.size());
        for (final RemoteConfig remoteConfig : remoteConfigs) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        resultsMap.put(remoteConfig, gitWorkingDirectory.pushToRemote(force, localBranchName, remoteBranchName, remoteConfig));
                    }
                    catch (GitAPIException gapie) {
                        System.out.println(JenkinsResultsParserUtil.combine("Unable to push ", localBranchName, " to ", GitWorkingDirectory.getRemoteURL(remoteConfig), ":", remoteBranchName));
                        gapie.printStackTrace();
                    }
                }
            });
        }
        executorService.shutdown();
        try {
            executorService.awaitTermination(30L, TimeUnit.MINUTES);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println(JenkinsResultsParserUtil.combine("Pushed ", localBranchName, " to ", remoteBranchName, " on ", Integer.toString(remoteConfigs.size()), " git nodes in ", JenkinsResultsParserUtil.toDurationString(duration)));
        return resultsMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected static String synchronizeToLocalGit(GitWorkingDirectory gitWorkingDirectory, String receiverUsername, int retryCount, String senderBranchName, String senderUsername, String senderBranchSHA, String upstreamBranchSHA) throws GitAPIException, IOException {
        String string;
        List<RemoteConfig> localGitRemoteConfigs;
        String cacheBranchName;
        RemoteConfig senderRemoteConfig;
        String originalBranchName;
        long start;
        block29: {
            String upstreamBranchName;
            boolean pullRequest;
            RemoteConfig upstreamRemoteConfig;
            block27: {
                String string2;
                block28: {
                    start = System.currentTimeMillis();
                    File repositoryDirectory = gitWorkingDirectory.getWorkingDirectory();
                    originalBranchName = gitWorkingDirectory.getCurrentBranch();
                    System.out.println(JenkinsResultsParserUtil.combine("Starting synchronization with local-git. Current repository ", "directory is ", repositoryDirectory.getPath(), ". Current ", "branch is ", originalBranchName, "."));
                    senderRemoteConfig = null;
                    upstreamRemoteConfig = null;
                    senderRemoteConfig = gitWorkingDirectory.addRemote(true, "sender-temp", LocalGitSyncUtil.getGitHubRemoteURL(gitWorkingDirectory.getRepositoryName(), senderUsername));
                    upstreamRemoteConfig = gitWorkingDirectory.getRemoteConfig("upstream");
                    pullRequest = !upstreamBranchSHA.equals(senderBranchSHA);
                    cacheBranchName = LocalGitSyncUtil.getCacheBranchName(receiverUsername, senderUsername, senderBranchSHA, upstreamBranchSHA);
                    upstreamBranchName = gitWorkingDirectory.getUpstreamBranchName();
                    if (!pullRequest) {
                        upstreamBranchSHA = gitWorkingDirectory.getBranchSHA(upstreamBranchName, upstreamRemoteConfig);
                    }
                    localGitRemoteConfigs = null;
                    localGitRemoteConfigs = LocalGitSyncUtil.getLocalGitRemoteConfigs(gitWorkingDirectory);
                    LocalGitSyncUtil.deleteLocalCacheBranches(cacheBranchName, gitWorkingDirectory);
                    LocalGitSyncUtil.deleteExpiredCacheBranches(gitWorkingDirectory, localGitRemoteConfigs);
                    if (!LocalGitSyncUtil.isBranchCached(cacheBranchName, gitWorkingDirectory, localGitRemoteConfigs)) break block27;
                    System.out.println(JenkinsResultsParserUtil.combine("Cache branch ", cacheBranchName, " already exists"));
                    if (!gitWorkingDirectory.branchExists(upstreamBranchName, null)) {
                        LocalGitSyncUtil.updateLocalUpstreamBranch(gitWorkingDirectory, upstreamBranchName, upstreamBranchSHA, upstreamRemoteConfig);
                    }
                    LocalGitSyncUtil.updateCacheBranchTimestamp(cacheBranchName, gitWorkingDirectory, localGitRemoteConfigs);
                    string2 = cacheBranchName;
                    if (localGitRemoteConfigs == null) break block28;
                    gitWorkingDirectory.removeRemotes(localGitRemoteConfigs);
                }
                if (gitWorkingDirectory.branchExists(originalBranchName, null)) {
                    gitWorkingDirectory.checkoutBranch(originalBranchName);
                } else {
                    LocalGitSyncUtil.checkoutUpstreamBranch(gitWorkingDirectory);
                }
                gitWorkingDirectory.deleteLocalBranch(cacheBranchName);
                if (senderRemoteConfig != null) {
                    gitWorkingDirectory.removeRemote(senderRemoteConfig);
                }
                System.out.println("Synchronization with local Git completed in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
                return string2;
            }
            LocalGitSyncUtil.updateLocalUpstreamBranch(gitWorkingDirectory, upstreamBranchName, upstreamBranchSHA, upstreamRemoteConfig);
            gitWorkingDirectory.fetch(cacheBranchName, senderBranchName, senderRemoteConfig);
            gitWorkingDirectory.createLocalBranch(cacheBranchName, true, senderBranchSHA);
            if (pullRequest) {
                gitWorkingDirectory.checkoutBranch(cacheBranchName);
                gitWorkingDirectory.rebase(true, upstreamBranchName, cacheBranchName);
            }
            LocalGitSyncUtil.cacheBranches(gitWorkingDirectory, cacheBranchName, localGitRemoteConfigs, upstreamBranchName, "liferay");
            string = cacheBranchName;
            if (localGitRemoteConfigs == null) break block29;
            gitWorkingDirectory.removeRemotes(localGitRemoteConfigs);
        }
        if (gitWorkingDirectory.branchExists(originalBranchName, null)) {
            gitWorkingDirectory.checkoutBranch(originalBranchName);
        } else {
            LocalGitSyncUtil.checkoutUpstreamBranch(gitWorkingDirectory);
        }
        gitWorkingDirectory.deleteLocalBranch(cacheBranchName);
        if (senderRemoteConfig != null) {
            gitWorkingDirectory.removeRemote(senderRemoteConfig);
        }
        System.out.println("Synchronization with local Git completed in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
        return string;
        {
            catch (Exception e) {
                String string3;
                block30: {
                    try {
                        if (retryCount == 1) {
                            throw e;
                        }
                        localGitRemoteConfigs = null;
                        senderRemoteConfig = null;
                        System.out.println("Synchronization with local-git failed. Retrying.");
                        e.printStackTrace();
                        gitWorkingDirectory.checkoutBranch(originalBranchName);
                        string3 = LocalGitSyncUtil.synchronizeToLocalGit(gitWorkingDirectory, receiverUsername, retryCount + 1, senderBranchName, senderUsername, senderBranchSHA, upstreamBranchSHA);
                        if (localGitRemoteConfigs == null) break block30;
                        gitWorkingDirectory.removeRemotes(localGitRemoteConfigs);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (localGitRemoteConfigs != null) {
                                gitWorkingDirectory.removeRemotes(localGitRemoteConfigs);
                            }
                            if (gitWorkingDirectory.branchExists(originalBranchName, null)) {
                                gitWorkingDirectory.checkoutBranch(originalBranchName);
                            } else {
                                LocalGitSyncUtil.checkoutUpstreamBranch(gitWorkingDirectory);
                            }
                            gitWorkingDirectory.deleteLocalBranch(cacheBranchName);
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            if (senderRemoteConfig != null) {
                                gitWorkingDirectory.removeRemote(senderRemoteConfig);
                            }
                            System.out.println("Synchronization with local Git completed in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
                            throw throwable2;
                        }
                    }
                }
                if (gitWorkingDirectory.branchExists(originalBranchName, null)) {
                    gitWorkingDirectory.checkoutBranch(originalBranchName);
                } else {
                    LocalGitSyncUtil.checkoutUpstreamBranch(gitWorkingDirectory);
                }
                gitWorkingDirectory.deleteLocalBranch(cacheBranchName);
                if (senderRemoteConfig != null) {
                    gitWorkingDirectory.removeRemote(senderRemoteConfig);
                }
                System.out.println("Synchronization with local Git completed in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
                return string3;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateCacheBranchTimestamp(String cacheBranchName, GitWorkingDirectory gitWorkingDirectory, List<RemoteConfig> localGitRemoteConfigs) {
        long start = System.currentTimeMillis();
        RemoteConfig localGitRemoteConfig = LocalGitSyncUtil.getRandomRemoteConfig(localGitRemoteConfigs);
        try {
            List<String> remoteCacheBranchNames = LocalGitSyncUtil.getRemoteCacheBranchNames(gitWorkingDirectory, localGitRemoteConfig);
            boolean updated = false;
            for (String remoteCacheBranchName : remoteCacheBranchNames) {
                long existingTimestamp;
                Matcher matcher = _cacheTimestampBranchPattern.matcher(remoteCacheBranchName);
                if (!remoteCacheBranchName.contains(cacheBranchName) || !matcher.matches()) continue;
                if (updated) {
                    LocalGitSyncUtil.pushToAllRemotes(true, gitWorkingDirectory, "", remoteCacheBranchName, localGitRemoteConfigs);
                    continue;
                }
                long currentTimestamp = System.currentTimeMillis();
                if (currentTimestamp - (existingTimestamp = Long.parseLong(matcher.group("timestamp"))) < 86400000L) {
                    return;
                }
                String newTimestampBranchName = JenkinsResultsParserUtil.combine(cacheBranchName, "-", Long.toString(currentTimestamp));
                System.out.println(JenkinsResultsParserUtil.combine("\nUpdating cache branch timestamp from ", remoteCacheBranchName, "to ", newTimestampBranchName));
                System.out.println(JenkinsResultsParserUtil.combine("Updating existing timestamp for branch ", remoteCacheBranchName, " to ", newTimestampBranchName));
                String currentBranch = gitWorkingDirectory.getCurrentBranch();
                gitWorkingDirectory.fetch(newTimestampBranchName, remoteCacheBranchName, localGitRemoteConfig);
                gitWorkingDirectory.createLocalBranch(newTimestampBranchName, true, gitWorkingDirectory.getBranchSHA(remoteCacheBranchName, localGitRemoteConfig));
                try {
                    LocalGitSyncUtil.pushToAllRemotes(true, gitWorkingDirectory, newTimestampBranchName, newTimestampBranchName, localGitRemoteConfigs);
                    LocalGitSyncUtil.pushToAllRemotes(true, gitWorkingDirectory, "", remoteCacheBranchName, localGitRemoteConfigs);
                    updated = true;
                }
                finally {
                    if (gitWorkingDirectory.branchExists(currentBranch, null)) {
                        gitWorkingDirectory.checkoutBranch(currentBranch);
                    } else {
                        LocalGitSyncUtil.checkoutUpstreamBranch(gitWorkingDirectory);
                    }
                    gitWorkingDirectory.deleteLocalBranch(newTimestampBranchName);
                }
            }
        }
        catch (GitAPIException gapie) {
            System.out.println(JenkinsResultsParserUtil.combine("Unable to update cache branch timestamp on branch ", cacheBranchName));
            gapie.printStackTrace();
        }
        System.out.println("Cache branch timestamp updated in " + JenkinsResultsParserUtil.toDurationString(System.currentTimeMillis() - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void updateLocalUpstreamBranch(GitWorkingDirectory gitWorkingDirectory, String upstreamBranchName, String upstreamBranchSHA, RemoteConfig upstreamRemoteConfig) throws GitAPIException {
        gitWorkingDirectory.rebaseAbort();
        gitWorkingDirectory.clean();
        gitWorkingDirectory.reset(null, ResetCommand.ResetType.HARD);
        gitWorkingDirectory.fetch(null, upstreamRemoteConfig);
        String tempBranchName = "temp-" + System.currentTimeMillis();
        try {
            gitWorkingDirectory.createLocalBranch(tempBranchName, true, upstreamBranchSHA);
            gitWorkingDirectory.checkoutBranch(tempBranchName, "-f");
            gitWorkingDirectory.deleteLocalBranch(upstreamBranchName);
            gitWorkingDirectory.createLocalBranch(upstreamBranchName, true, upstreamBranchSHA);
            gitWorkingDirectory.checkoutBranch(upstreamBranchName);
        }
        finally {
            gitWorkingDirectory.deleteLocalBranch(tempBranchName);
        }
    }
}

