/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BatchBuild;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.JenkinsResultsParserUtil;
import com.liferay.jenkins.results.parser.TopLevelBuild;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ModulesIntegrationBatchBuild
extends BatchBuild {
    protected Properties buildProperties;
    protected List<Build> verifiedAxisBuilds;
    private static final String _REINVOKE_ERROR_MARKER_TEMPLATE = "reinvoke.error.marker[modules-integration-?]";
    private boolean _notificationsComplete;

    public ModulesIntegrationBatchBuild(String url) {
        super(url);
    }

    public ModulesIntegrationBatchBuild(String url, TopLevelBuild topLevelBuild) {
        super(url, topLevelBuild);
    }

    @Override
    public void reinvoke() {
        super.reinvoke();
        this.verifiedAxisBuilds.clear();
    }

    @Override
    public void update() {
        super.update();
        if (this._notificationsComplete) {
            return;
        }
        if (this.verifiedAxisBuilds == null) {
            this.verifiedAxisBuilds = new ArrayList<Build>();
        }
        Build reinvokeErrorAxisBuild = null;
        String reinvokeErrorMarker = null;
        for (Build axisBuild : this.getDownstreamBuilds("completed")) {
            String axisBuildResult;
            if (this.verifiedAxisBuilds.contains(axisBuild) || (axisBuildResult = axisBuild.getResult()) == null || axisBuildResult.equals("SUCCESS")) continue;
            String axisBuildConsoleText = axisBuild.getConsoleText();
            int i = 1;
            while (this.hasReinvokeErrorMarker(i)) {
                if (axisBuildConsoleText.contains(this.getReinvokeErrorMarker(i))) {
                    reinvokeErrorAxisBuild = axisBuild;
                    reinvokeErrorMarker = this.getReinvokeErrorMarker(i);
                    break;
                }
                ++i;
            }
            if (reinvokeErrorAxisBuild != null) continue;
            this.verifiedAxisBuilds.add(axisBuild);
        }
        if (reinvokeErrorAxisBuild != null) {
            String body;
            String subject = "Arquillian broken connection failure";
            if (this.badBuildNumbers.size() == 0) {
                body = JenkinsResultsParserUtil.combine("Arquillian broken connection failure detected at ", reinvokeErrorAxisBuild.getBuildURL(), ". This batch will be reinvoked.\n\nError marker:\n", reinvokeErrorMarker);
                System.out.println(body);
                this.reinvoke();
            } else {
                subject = "Second " + subject;
                List<String> badBuildURLs = this.getBadBuildURLs();
                body = JenkinsResultsParserUtil.combine("Second Arquillian broken connection failure detected at ", reinvokeErrorAxisBuild.getBuildURL(), ". Previous failure was at ", badBuildURLs.get(0), "\n\nError marker:\n", reinvokeErrorMarker);
                System.out.println(body);
                this._notificationsComplete = true;
            }
        }
    }

    protected String getReinvokedErrorMarkerPropertyName(int index) {
        return _REINVOKE_ERROR_MARKER_TEMPLATE.replace("?", Integer.toString(index));
    }

    protected String getReinvokeErrorMarker(int index) {
        if (this.buildProperties == null) {
            this.loadBuildProperties();
        }
        return this.buildProperties.getProperty(this.getReinvokedErrorMarkerPropertyName(index));
    }

    protected boolean hasReinvokeErrorMarker(int index) {
        if (this.buildProperties == null) {
            this.loadBuildProperties();
        }
        return this.buildProperties.containsKey(this.getReinvokedErrorMarkerPropertyName(index));
    }

    protected void loadBuildProperties() {
        try {
            this.buildProperties = JenkinsResultsParserUtil.getBuildProperties();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to get build.properties.", ioe);
        }
    }
}

