/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.jenkins.results.parser;

import com.liferay.jenkins.results.parser.BaseFailureMessageGenerator;
import com.liferay.jenkins.results.parser.Build;
import com.liferay.jenkins.results.parser.Dom4JUtil;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class PoshiValidationFailureMessageGenerator
extends BaseFailureMessageGenerator {
    private static final Pattern _poshiFailurePattern = Pattern.compile("\\n(.*errors in POSHI[\\s\\S]+?FAILED)");

    @Override
    public String getMessage(String buildURL, String consoleOutput, Hashtable<?, ?> properties) {
        Matcher poshiFailureMatcher = _poshiFailurePattern.matcher(consoleOutput);
        if (poshiFailureMatcher.find()) {
            String poshiFailureMessage = poshiFailureMatcher.group(1);
            return "<p>POSHI Validation Failure</p><pre><code>" + poshiFailureMessage + "</code></pre>";
        }
        return null;
    }

    @Override
    public Element getMessageElement(Build build) {
        String consoleText = build.getConsoleText();
        Matcher poshiFailureMatcher = _poshiFailurePattern.matcher(consoleText);
        if (!poshiFailureMatcher.find()) {
            return null;
        }
        return Dom4JUtil.getNewElement("div", null, Dom4JUtil.getNewElement("p", null, "POSHI Validation Failure", Dom4JUtil.toCodeSnippetElement(poshiFailureMatcher.group(1))));
    }
}

