/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMTemplate;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.service.DDMTemplateLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.journal.internal.exportimport.content.processor.JournalArticleExportImportContentProcessor;
import com.liferay.journal.internal.exportimport.creation.strategy.JournalCreationStrategy;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleImage;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleImageLocalService;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.io.File;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={JournalArticleStagedModelDataHandler.class, StagedModelDataHandler.class})
public class JournalArticleStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalArticle> {
    public static final String[] CLASS_NAMES = new String[]{JournalArticle.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleStagedModelDataHandler.class);
    private DDMStructureLocalService _ddmStructureLocalService;
    private DDMTemplateLocalService _ddmTemplateLocalService;
    private ImageLocalService _imageLocalService;
    private JournalArticleExportImportContentProcessor _journalArticleExportImportContentProcessor;
    private JournalArticleImageLocalService _journalArticleImageLocalService;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalArticleResourceLocalService _journalArticleResourceLocalService;
    private JournalCreationStrategy _journalCreationStrategy;
    private UserLocalService _userLocalService;

    public void deleteStagedModel(JournalArticle article) throws PortalException {
        this._journalArticleLocalService.deleteArticle(article);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JournalArticleResource articleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(uuid, groupId);
        if (articleResource == null) {
            return;
        }
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)extraData);
        if (Validator.isNotNull((String)extraData) && extraDataJSONObject.has("uuid")) {
            String articleUuid = extraDataJSONObject.getString("uuid");
            JournalArticle article = this.fetchStagedModelByUuidAndGroupId(articleUuid, groupId);
            this.deleteStagedModel(article);
        } else {
            this._journalArticleLocalService.deleteArticle(groupId, articleResource.getArticleId(), null);
        }
    }

    public JournalArticle fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._journalArticleLocalService.fetchJournalArticleByUuidAndGroupId(uuid, groupId);
    }

    public List<JournalArticle> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._journalArticleLocalService.getJournalArticlesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalArticle article) {
        return article.getTitleCurrentValue();
    }

    public int[] getExportableStatuses() {
        return new int[]{0, 3, 7};
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, JournalArticle article) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        String articleResourceUuid = null;
        try {
            articleResourceUuid = article.getArticleResourceUuid();
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to find article resource for article " + article.getArticleId());
        }
        referenceAttributes.put("article-resource-uuid", articleResourceUuid);
        referenceAttributes.put("article-id", article.getArticleId());
        long defaultUserId = 0L;
        try {
            defaultUserId = this._userLocalService.getDefaultUserId(article.getCompanyId());
        }
        catch (Exception e) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == article.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        String articleResourceUuid = referenceElement.attributeValue("article-resource-uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        String articleArticleId = referenceElement.attributeValue("article-id");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        JournalArticle existingArticle = this.fetchExistingArticle(uuid, articleResourceUuid, groupId, articleArticleId, null, 0.0, preloaded);
        return existingArticle != null;
    }

    protected boolean countStagedModel(PortletDataContext portletDataContext, JournalArticle article) {
        if (article.getClassNameId() == PortalUtil.getClassNameId(DDMStructure.class)) {
            return false;
        }
        return !portletDataContext.isModelCounted(JournalArticleResource.class.getName(), article.getResourcePrimKey());
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        Layout layout;
        Element articleElement = portletDataContext.getExportDataElement((ClassedModel)article);
        articleElement.addAttribute("article-resource-uuid", article.getArticleResourceUuid());
        if (article.getFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)article.getFolder(), (String)"parent");
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(article.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmStructure, (String)"strong");
        if (article.getClassNameId() != PortalUtil.getClassNameId(DDMStructure.class)) {
            DDMTemplate ddmTemplate = this._ddmTemplateLocalService.getTemplate(article.getGroupId(), PortalUtil.getClassNameId(DDMStructure.class), article.getDDMTemplateKey(), true);
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)article, (StagedModel)ddmTemplate, (String)"strong");
        }
        if ((layout = article.getLayout()) != null) {
            portletDataContext.addReferenceElement((ClassedModel)article, articleElement, (ClassedModel)layout, "dependency", true);
        }
        if (article.isSmallImage()) {
            if (Validator.isNotNull((String)article.getSmallImageURL())) {
                String smallImageURL = this._journalArticleExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)article, article.getSmallImageURL() + " ", true, false);
                article.setSmallImageURL(smallImageURL);
            } else {
                Image smallImage = this._imageLocalService.fetchImage(article.getSmallImageId());
                if (smallImage != null && smallImage.getTextObj() != null) {
                    String smallImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)(smallImage.getImageId() + "." + smallImage.getType()));
                    articleElement.addAttribute("small-image-path", smallImagePath);
                    article.setSmallImageType(smallImage.getType());
                    portletDataContext.addZipEntry(smallImagePath, smallImage.getTextObj());
                } else {
                    if (_log.isWarnEnabled()) {
                        StringBundler sb = new StringBundler(4);
                        sb.append("Unable to export small image ");
                        sb.append(article.getSmallImageId());
                        sb.append(" to article ");
                        sb.append(article.getArticleId());
                        _log.warn((Object)sb.toString());
                    }
                    article.setSmallImage(false);
                    article.setSmallImageId(0L);
                }
            }
        }
        List articleImages = this._journalArticleImageLocalService.getArticleImages(article.getGroupId(), article.getArticleId(), article.getVersion());
        for (JournalArticleImage articleImage : articleImages) {
            this.exportArticleImage(portletDataContext, articleImage, article, articleElement);
        }
        article.setStatusByUserUuid(article.getStatusByUserUuid());
        String content = this._journalArticleExportImportContentProcessor.replaceExportContentReferences(portletDataContext, (StagedModel)article, article.getContent(), portletDataContext.getBooleanParameter("journal", "referenced-content"), false);
        article.setContent(content);
        long defaultUserId = this._userLocalService.getDefaultUserId(article.getCompanyId());
        if (defaultUserId == article.getUserId()) {
            articleElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(articleElement, ExportImportPathUtil.getModelPath((StagedModel)article), (ClassedModel)article);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        String articleResourceUuid = referenceElement.attributeValue("article-resource-uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        String articleArticleId = referenceElement.attributeValue("article-id");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        JournalArticle existingArticle = null;
        existingArticle = this.fetchExistingArticle(uuid, articleResourceUuid, groupId, articleArticleId, null, 0.0, preloaded);
        Map articleArticleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId");
        articleArticleIds.put(articleArticleId, existingArticle.getArticleId());
        Map articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class);
        long articleId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        articleIds.put(articleId, existingArticle.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        Map articleIds;
        String newArticleId;
        long userId = portletDataContext.getUserId(article.getUserUuid());
        long authorId = this._journalCreationStrategy.getAuthorUserId(portletDataContext, article);
        if (authorId != 0L) {
            userId = authorId;
        }
        User user = this._userLocalService.getUser(userId);
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        long folderId = MapUtil.getLong((Map)folderIds, (long)article.getFolderId(), (long)article.getFolderId());
        String articleId = article.getArticleId();
        boolean autoArticleId = false;
        if (Validator.isNumber((String)articleId) || this._journalArticleLocalService.fetchArticle(portletDataContext.getScopeGroupId(), articleId, 1.0) != null) {
            autoArticleId = true;
        }
        if (Validator.isNotNull((String)(newArticleId = (String)(articleIds = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".articleId")).get(articleId)))) {
            articleId = newArticleId;
            autoArticleId = false;
        }
        String content = article.getContent();
        content = this._journalArticleExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)article, content);
        article.setContent(content);
        String newContent = this._journalCreationStrategy.getTransformedContent(portletDataContext, article);
        if (newContent != JournalCreationStrategy.ARTICLE_CONTENT_UNCHANGED) {
            article.setContent(newContent);
        }
        Date displayDate = article.getDisplayDate();
        int displayDateMonth = 0;
        int displayDateDay = 0;
        int displayDateYear = 0;
        int displayDateHour = 0;
        int displayDateMinute = 0;
        if (displayDate != null) {
            Calendar displayCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            displayCal.setTime(displayDate);
            displayDateMonth = displayCal.get(2);
            displayDateDay = displayCal.get(5);
            displayDateYear = displayCal.get(1);
            displayDateHour = displayCal.get(10);
            displayDateMinute = displayCal.get(12);
            if (displayCal.get(9) == 1) {
                displayDateHour += 12;
            }
        }
        Date expirationDate = article.getExpirationDate();
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        if (expirationDate != null) {
            Calendar expirationCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            expirationCal.setTime(expirationDate);
            expirationDateMonth = expirationCal.get(2);
            expirationDateDay = expirationCal.get(5);
            expirationDateYear = expirationCal.get(1);
            expirationDateHour = expirationCal.get(10);
            expirationDateMinute = expirationCal.get(12);
            neverExpire = false;
            if (expirationCal.get(9) == 1) {
                expirationDateHour += 12;
            }
        }
        Date reviewDate = article.getReviewDate();
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        if (reviewDate != null) {
            Calendar reviewCal = CalendarFactoryUtil.getCalendar((TimeZone)user.getTimeZone());
            reviewCal.setTime(reviewDate);
            reviewDateMonth = reviewCal.get(2);
            reviewDateDay = reviewCal.get(5);
            reviewDateYear = reviewCal.get(1);
            reviewDateHour = reviewCal.get(10);
            reviewDateMinute = reviewCal.get(12);
            neverReview = false;
            if (reviewCal.get(9) == 1) {
                reviewDateHour += 12;
            }
        }
        Map ddmStructureKeys = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class + ".ddmStructureKey");
        String parentDDMStructureKey = MapUtil.getString((Map)ddmStructureKeys, (String)article.getDDMStructureKey(), (String)article.getDDMStructureKey());
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = 0L;
        if (article.getClassNameId() != 0L) {
            ddmStructureId = (Long)ddmStructureIds.get(article.getClassPK());
        }
        Map ddmTemplateKeys = portletDataContext.getNewPrimaryKeysMap(DDMTemplate.class + ".ddmTemplateKey");
        String parentDDMTemplateKey = MapUtil.getString((Map)ddmTemplateKeys, (String)article.getDDMTemplateKey(), (String)article.getDDMTemplateKey());
        File smallFile = null;
        try {
            Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
            if (article.isSmallImage()) {
                byte[] bytes;
                String smallImagePath = articleElement.attributeValue("small-image-path");
                if (Validator.isNotNull((String)article.getSmallImageURL())) {
                    String smallImageURL = this._journalArticleExportImportContentProcessor.replaceImportContentReferences(portletDataContext, (StagedModel)article, article.getSmallImageURL());
                    article.setSmallImageURL(smallImageURL);
                } else if (Validator.isNotNull((String)smallImagePath) && (bytes = portletDataContext.getZipEntryAsByteArray(smallImagePath)) != null) {
                    smallFile = FileUtil.createTempFile((String)article.getSmallImageType());
                    FileUtil.write((File)smallFile, (byte[])bytes);
                }
            }
            HashMap<String, byte[]> images = new HashMap<String, byte[]>();
            List imagesElements = portletDataContext.getReferenceDataElements((StagedModel)article, Image.class);
            for (Element imageElement : imagesElements) {
                String imagePath = imageElement.attributeValue("path");
                String imageKey = imageElement.attributeValue("image-key");
                images.put(imageKey, portletDataContext.getZipEntryAsByteArray(imagePath));
            }
            String articleURL = null;
            boolean addGroupPermissions = this._journalCreationStrategy.addGroupPermissions(portletDataContext, article);
            boolean addGuestPermissions = this._journalCreationStrategy.addGuestPermissions(portletDataContext, article);
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)article);
            serviceContext.setAddGroupPermissions(addGroupPermissions);
            serviceContext.setAddGuestPermissions(addGuestPermissions);
            if (expirationDate != null && expirationDate.before(new Date())) {
                article.setStatus(3);
            }
            if (article.getStatus() != 0 && article.getStatus() != 7) {
                serviceContext.setWorkflowAction(2);
            }
            JournalArticle importedArticle = null;
            String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
            if (portletDataContext.isDataStrategyMirror()) {
                serviceContext.setUuid(article.getUuid());
                serviceContext.setAttribute("articleResourceUuid", (Serializable)((Object)articleResourceUuid));
                serviceContext.setAttribute("urlTitle", (Serializable)((Object)article.getUrlTitle()));
                boolean preloaded = GetterUtil.getBoolean((String)articleElement.attributeValue("preloaded"));
                JournalArticle existingArticle = this.fetchExistingArticle(articleResourceUuid, portletDataContext.getScopeGroupId(), articleId, newArticleId, preloaded);
                JournalArticle existingArticleVersion = null;
                if (existingArticle != null) {
                    existingArticleVersion = this.fetchExistingArticleVersion(article.getUuid(), portletDataContext.getScopeGroupId(), existingArticle.getArticleId(), article.getVersion());
                }
                if (existingArticle != null && existingArticleVersion == null) {
                    autoArticleId = false;
                    articleId = existingArticle.getArticleId();
                }
                if (existingArticleVersion == null) {
                    importedArticle = this._journalArticleLocalService.addArticle(userId, portletDataContext.getScopeGroupId(), folderId, article.getClassNameId(), ddmStructureId, articleId, autoArticleId, article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, images, articleURL, serviceContext);
                } else {
                    String importedArticleUuid;
                    importedArticle = this._journalArticleLocalService.updateArticle(userId, existingArticle.getGroupId(), folderId, existingArticle.getArticleId(), article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, images, articleURL, serviceContext);
                    String articleUuid = article.getUuid();
                    if (!articleUuid.equals(importedArticleUuid = importedArticle.getUuid())) {
                        importedArticle.setUuid(articleUuid);
                        this._journalArticleLocalService.updateJournalArticle(importedArticle);
                    }
                }
            } else {
                importedArticle = this._journalArticleLocalService.addArticle(userId, portletDataContext.getScopeGroupId(), folderId, article.getClassNameId(), ddmStructureId, articleId, autoArticleId, article.getVersion(), article.getTitleMap(), article.getDescriptionMap(), article.getContent(), parentDDMStructureKey, parentDDMTemplateKey, article.getLayoutUuid(), displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, article.isIndexable(), article.isSmallImage(), article.getSmallImageURL(), smallFile, images, articleURL, serviceContext);
            }
            portletDataContext.importClassedModel((ClassedModel)article, (ClassedModel)importedArticle);
            if (Validator.isNull((String)newArticleId)) {
                articleIds.put(article.getArticleId(), importedArticle.getArticleId());
            }
            Map articlePrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".primaryKey");
            articlePrimaryKeys.put(article.getPrimaryKey(), importedArticle.getPrimaryKey());
        }
        finally {
            if (smallFile != null) {
                smallFile.delete();
            }
        }
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, JournalArticle article) throws Exception {
        long userId = portletDataContext.getUserId(article.getUserUuid());
        Element articleElement = portletDataContext.getImportDataStagedModelElement((StagedModel)article);
        String articleResourceUuid = articleElement.attributeValue("article-resource-uuid");
        boolean preloaded = GetterUtil.getBoolean((String)articleElement.attributeValue("preloaded"));
        JournalArticle existingArticle = this.fetchExistingArticle(article.getUuid(), articleResourceUuid, portletDataContext.getScopeGroupId(), article.getArticleId(), article.getArticleId(), article.getVersion(), preloaded);
        if (existingArticle == null || !existingArticle.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingArticle.getTrashHandler();
        if (trashHandler.isRestorable(existingArticle.getResourcePrimKey())) {
            trashHandler.restoreTrashEntry(userId, existingArticle.getResourcePrimKey());
        }
    }

    protected void exportArticleImage(PortletDataContext portletDataContext, JournalArticleImage articleImage, JournalArticle article, Element articleElement) {
        Image image = this._imageLocalService.fetchImage(articleImage.getArticleImageId());
        if (image == null || image.getTextObj() == null) {
            return;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(articleImage.getElInstanceId());
        sb.append("_");
        sb.append(articleImage.getElName());
        if (Validator.isNotNull((String)articleImage.getLanguageId())) {
            sb.append(articleImage.getLanguageId());
        }
        Element imageElement = portletDataContext.getExportDataElement((ClassedModel)image);
        String imageKey = sb.toString();
        imageElement.addAttribute("image-key", imageKey);
        String fileName = String.valueOf(articleImage.getArticleImageId());
        String articleImagePath = ExportImportPathUtil.getModelPath((StagedModel)article, (String)fileName);
        imageElement.addAttribute("path", articleImagePath);
        portletDataContext.addZipEntry(articleImagePath, image.getTextObj());
        portletDataContext.addReferenceElement((ClassedModel)article, articleElement, (ClassedModel)image, articleImagePath, "dependency", false);
    }

    protected JournalArticle fetchExistingArticle(String articleResourceUuid, long groupId, String articleId, String newArticleId, boolean preloaded) {
        JournalArticle existingArticle = null;
        if (!preloaded) {
            JournalArticleResource journalArticleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(articleResourceUuid, groupId);
            if (journalArticleResource == null) {
                return null;
            }
            return this._journalArticleLocalService.fetchArticle(groupId, journalArticleResource.getArticleId());
        }
        if (Validator.isNotNull((String)newArticleId)) {
            existingArticle = this._journalArticleLocalService.fetchArticle(groupId, newArticleId);
        }
        if (existingArticle == null && Validator.isNull((String)newArticleId)) {
            existingArticle = this._journalArticleLocalService.fetchArticle(groupId, articleId);
        }
        return existingArticle;
    }

    protected JournalArticle fetchExistingArticle(String articleUuid, String articleResourceUuid, long groupId, String articleId, String newArticleId, double version, boolean preloaded) {
        JournalArticle article = this.fetchExistingArticle(articleResourceUuid, groupId, articleId, newArticleId, preloaded);
        if (article != null) {
            article = this.fetchExistingArticleVersion(articleUuid, groupId, article.getArticleId(), version);
        }
        return article;
    }

    protected JournalArticle fetchExistingArticleVersion(String articleUuid, long groupId, String articleId, double version) {
        JournalArticle existingArticle = this.fetchStagedModelByUuidAndGroupId(articleUuid, groupId);
        if (existingArticle != null) {
            return existingArticle;
        }
        return this._journalArticleLocalService.fetchArticle(groupId, articleId, version);
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDDMTemplateLocalService(DDMTemplateLocalService ddmTemplateLocalService) {
        this._ddmTemplateLocalService = ddmTemplateLocalService;
    }

    @Reference(unbind="-")
    protected void setImageLocalService(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleExportImportContentProcessor(JournalArticleExportImportContentProcessor journalArticleExportImportContentProcessor) {
        this._journalArticleExportImportContentProcessor = journalArticleExportImportContentProcessor;
    }

    @Reference(unbind="-")
    protected void setJournalArticleImageLocalService(JournalArticleImageLocalService journalArticleImageLocalService) {
        this._journalArticleImageLocalService = journalArticleImageLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleResourceLocalService(JournalArticleResourceLocalService journalArticleResourceLocalService) {
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalCreationStrategy(JournalCreationStrategy journalCreationStrategy) {
        this._journalCreationStrategy = journalCreationStrategy;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }
}

