/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.exportimport.data.handler;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.exportimport.lar.BaseStagedModelDataHandler;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Element;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={StagedModelDataHandler.class})
public class JournalFolderStagedModelDataHandler
extends BaseStagedModelDataHandler<JournalFolder> {
    public static final String[] CLASS_NAMES = new String[]{JournalFolder.class.getName()};
    private DDMStructureLocalService _ddmStructureLocalService;
    private JournalFolderLocalService _journalFolderLocalService;

    public void deleteStagedModel(JournalFolder folder) throws PortalException {
        this._journalFolderLocalService.deleteFolder(folder);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        JournalFolder folder = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (folder != null) {
            this.deleteStagedModel(folder);
        }
    }

    public JournalFolder fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._journalFolderLocalService.fetchJournalFolderByUuidAndGroupId(uuid, groupId);
    }

    public List<JournalFolder> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._journalFolderLocalService.getJournalFoldersByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(JournalFolder folder) {
        return folder.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        if (folder.getParentFolderId() != 0L) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)folder.getParentFolder(), (String)"parent");
        }
        Element folderElement = portletDataContext.getExportDataElement((ClassedModel)folder);
        this.exportFolderDDMStructures(portletDataContext, folder);
        portletDataContext.addClassedModel(folderElement, ExportImportPathUtil.getModelPath((StagedModel)folder), (ClassedModel)folder);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        Map folderIds = portletDataContext.getNewPrimaryKeysMap(JournalFolder.class);
        long parentFolderId = MapUtil.getLong((Map)folderIds, (long)folder.getParentFolderId(), (long)folder.getParentFolderId());
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)folder);
        JournalFolder importedFolder = null;
        long groupId = portletDataContext.getScopeGroupId();
        if (portletDataContext.isDataStrategyMirror()) {
            JournalFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), groupId);
            if (existingFolder == null) {
                String name = this.getFolderName(null, groupId, parentFolderId, folder.getName(), 2);
                serviceContext.setUuid(folder.getUuid());
                importedFolder = this._journalFolderLocalService.addFolder(userId, groupId, parentFolderId, name, folder.getDescription(), serviceContext);
            } else {
                String name = this.getFolderName(folder.getUuid(), groupId, parentFolderId, folder.getName(), 2);
                importedFolder = this._journalFolderLocalService.updateFolder(userId, serviceContext.getScopeGroupId(), existingFolder.getFolderId(), parentFolderId, name, folder.getDescription(), false, serviceContext);
            }
        } else {
            String name = this.getFolderName(null, groupId, parentFolderId, folder.getName(), 2);
            importedFolder = this._journalFolderLocalService.addFolder(userId, groupId, parentFolderId, name, folder.getDescription(), serviceContext);
        }
        this.importFolderDDMStructures(portletDataContext, folder, importedFolder);
        portletDataContext.importClassedModel((ClassedModel)folder, (ClassedModel)importedFolder);
    }

    protected void doRestoreStagedModel(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        long userId = portletDataContext.getUserId(folder.getUserUuid());
        JournalFolder existingFolder = this.fetchStagedModelByUuidAndGroupId(folder.getUuid(), portletDataContext.getScopeGroupId());
        if (existingFolder == null || !existingFolder.isInTrash()) {
            return;
        }
        TrashHandler trashHandler = existingFolder.getTrashHandler();
        if (trashHandler.isRestorable(existingFolder.getFolderId())) {
            trashHandler.restoreTrashEntry(userId, existingFolder.getFolderId());
        }
    }

    protected void exportFolderDDMStructures(PortletDataContext portletDataContext, JournalFolder folder) throws Exception {
        List ddmStructures = this._journalFolderLocalService.getDDMStructures(new long[]{portletDataContext.getCompanyGroupId(), portletDataContext.getScopeGroupId()}, folder.getFolderId(), 1);
        for (DDMStructure ddmStructure : ddmStructures) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)folder, (StagedModel)ddmStructure, (String)"strong");
        }
    }

    protected String getFolderName(String uuid, long groupId, long parentFolderId, String name, int count) throws Exception {
        JournalFolder folder = this._journalFolderLocalService.fetchFolder(groupId, parentFolderId, name);
        if (folder == null) {
            return name;
        }
        if (Validator.isNotNull((String)uuid) && uuid.equals(folder.getUuid())) {
            return name;
        }
        name = StringUtil.appendParentheticalSuffix((String)name, (int)count);
        return this.getFolderName(uuid, groupId, parentFolderId, name, ++count);
    }

    protected void importFolderDDMStructures(PortletDataContext portletDataContext, JournalFolder folder, JournalFolder importedFolder) throws Exception {
        ArrayList<Long> currentFolderDDMStructureIds = new ArrayList<Long>();
        List referenceElements = portletDataContext.getReferenceElements((StagedModel)folder, DDMStructure.class);
        for (Element referenceElement : referenceElements) {
            long referenceDDMStructureId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
            long ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)referenceDDMStructureId, (long)referenceDDMStructureId);
            DDMStructure existingDDMStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId);
            if (existingDDMStructure == null) continue;
            currentFolderDDMStructureIds.add(existingDDMStructure.getStructureId());
        }
        if (!currentFolderDDMStructureIds.isEmpty()) {
            importedFolder.setRestrictionType(1);
            this._journalFolderLocalService.updateJournalFolder(importedFolder);
            this._journalFolderLocalService.updateFolderDDMStructures(importedFolder, ArrayUtil.toLongArray(currentFolderDDMStructureIds));
        }
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }
}

