/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.events;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.ActionException;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class JournalServicePreAction
extends Action {
    private static final String _PATH_PORTAL_LAYOUT = "/portal/layout";
    private static final Log _log = LogFactoryUtil.getLog(JournalServicePreAction.class);
    private AssetEntryLocalService _assetEntryLocalService;
    private JournalArticleService _journalArticleService;

    public void run(HttpServletRequest request, HttpServletResponse response) throws ActionException {
        try {
            this.servicePre(request);
        }
        catch (Exception e) {
            throw new ActionException((Throwable)e);
        }
    }

    public void servicePre(HttpServletRequest request) throws PortalException {
        block4: {
            String strutsAction = PortalUtil.getStrutsAction((HttpServletRequest)request);
            if (!strutsAction.equals(_PATH_PORTAL_LAYOUT)) {
                return;
            }
            long mainJournalArticleId = ParamUtil.getLong((HttpServletRequest)request, (String)"p_j_a_id");
            if (mainJournalArticleId <= 0L) {
                return;
            }
            try {
                JournalArticle mainJournalArticle = this._journalArticleService.getArticle(mainJournalArticleId);
                AssetEntry layoutAssetEntry = this._assetEntryLocalService.getEntry(JournalArticle.class.getName(), mainJournalArticle.getResourcePrimKey());
                request.setAttribute("LIFERAY_SHARED_LAYOUT_ASSET_ENTRY", (Object)layoutAssetEntry);
            }
            catch (NoSuchArticleException nsae) {
                if (!_log.isWarnEnabled()) break block4;
                _log.warn((Object)nsae.getMessage());
            }
        }
    }

    @Reference(unbind="-")
    protected void setAssetEntryLocalService(AssetEntryLocalService assetEntryLocalService) {
        this._assetEntryLocalService = assetEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleService(JournalArticleService journalArticleService) {
        this._journalArticleService = journalArticleService;
    }
}

