/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.base.BaseTextExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.journal.exception.NoSuchArticleException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.kernel.exception.BulkException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={ExportImportContentProcessor.class, JournalArticleExportImportContentProcessor.class})
public class JournalArticleExportImportContentProcessor
extends BaseTextExportImportContentProcessor {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleExportImportContentProcessor.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private JSONFactory _jsonFactory;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        content = this.replaceExportJournalArticleReferences(portletDataContext, stagedModel, content, exportReferencedContent);
        content = super.replaceExportContentReferences(portletDataContext, stagedModel, content, exportReferencedContent, escapeContent);
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        content = this.replaceImportJournalArticleReferences(portletDataContext, stagedModel, content);
        content = super.replaceImportContentReferences(portletDataContext, stagedModel, content);
        return content;
    }

    public void validateContentReferences(long groupId, String content) throws PortalException {
        this.validateJournalArticleReferences(groupId, content);
        super.validateContentReferences(groupId, content);
    }

    protected String replaceExportJournalArticleReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent) throws Exception {
        Group group = this._groupLocalService.fetchGroup(portletDataContext.getGroupId());
        if (group.isStagingGroup()) {
            group = group.getLiveGroup();
        }
        if (group.isStaged() && !group.isStagedRemotely() && !group.isStagedPortlet("com_liferay_journal_web_portlet_JournalPortlet")) {
            return content;
        }
        Document document = SAXReaderUtil.read((String)content);
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='ddm-journal-article']");
        List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
        for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
            Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
            List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
            for (Element dynamicContentElement : dynamicContentElements) {
                String jsonData = dynamicContentElement.getStringValue();
                if (jsonData.equals("")) continue;
                JSONObject jsonObject = this._jsonFactory.createJSONObject(jsonData);
                long classPK = GetterUtil.getLong((Object)jsonObject.get("classPK"));
                JournalArticle journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK);
                if (journalArticle == null) {
                    if (!_log.isInfoEnabled()) continue;
                    StringBundler messageSB = new StringBundler();
                    messageSB.append("Staged model with class name ");
                    messageSB.append(stagedModel.getModelClassName());
                    messageSB.append(" and primary key ");
                    messageSB.append((Object)stagedModel.getPrimaryKeyObj());
                    messageSB.append(" references missing journal ");
                    messageSB.append("article with class primary key ");
                    messageSB.append(classPK);
                    _log.info((Object)messageSB.toString());
                    continue;
                }
                String journalArticleReference = "[$journal-article-reference=" + journalArticle.getPrimaryKey() + "$]";
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Replacing " + jsonData + " with " + journalArticleReference));
                }
                dynamicContentElement.clearContent();
                dynamicContentElement.addCDATA(journalArticleReference);
                if (exportReferencedContent) {
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)stagedModel, (StagedModel)journalArticle, (String)"dependency");
                    continue;
                }
                Element entityElement = portletDataContext.getExportDataElement((ClassedModel)stagedModel);
                portletDataContext.addReferenceElement((ClassedModel)stagedModel, entityElement, (ClassedModel)journalArticle, "dependency", true);
            }
        }
        return document.asXML();
    }

    protected String replaceImportJournalArticleReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        List referenceElements = portletDataContext.getReferenceElements(stagedModel, JournalArticle.class);
        for (Element referenceElement : referenceElements) {
            long classPK = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
            Map articlePrimaryKeys = portletDataContext.getNewPrimaryKeysMap(JournalArticle.class + ".primaryKey");
            long articlePrimaryKey = MapUtil.getLong((Map)articlePrimaryKeys, (long)classPK, (long)classPK);
            JournalArticle journalArticle = this._journalArticleLocalService.fetchJournalArticle(articlePrimaryKey);
            if (journalArticle == null) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Unable to get journal article with primary key " + articlePrimaryKey));
                }
                throw new NoSuchArticleException("No JournalArticle exists with the key {id= " + articlePrimaryKey + "}");
            }
            String journalArticleReference = "[$journal-article-reference=" + classPK + "$]";
            JSONObject jsonObject = this._jsonFactory.createJSONObject();
            jsonObject.put("className", JournalArticle.class.getName());
            jsonObject.put("classPK", journalArticle.getResourcePrimKey());
            content = StringUtil.replace((String)content, (String)journalArticleReference, (String)jsonObject.toString());
        }
        return content;
    }

    protected void validateJournalArticleReferences(long groupId, String content) throws PortalException {
        ArrayList<NoSuchArticleException> throwables;
        block8: {
            throwables = new ArrayList<NoSuchArticleException>();
            try {
                Document document = SAXReaderUtil.read((String)content);
                XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='ddm-journal-article']");
                List ddmJournalArticleNodes = xPath.selectNodes((Object)document);
                for (Node ddmJournalArticleNode : ddmJournalArticleNodes) {
                    Element ddmJournalArticleElement = (Element)ddmJournalArticleNode;
                    List dynamicContentElements = ddmJournalArticleElement.elements("dynamic-content");
                    for (Element dynamicContentElement : dynamicContentElements) {
                        long classPK;
                        JournalArticle journalArticle;
                        String json = dynamicContentElement.getStringValue();
                        if (Validator.isNull((String)json)) {
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)"No journal article reference is specified");
                            continue;
                        }
                        JSONObject jsonObject = null;
                        try {
                            jsonObject = this._jsonFactory.createJSONObject(json);
                        }
                        catch (JSONException jsone) {
                            _log.debug((Object)jsone, (Throwable)jsone);
                            continue;
                        }
                        if (!jsonObject.has("classPK") || (journalArticle = this._journalArticleLocalService.fetchLatestArticle(classPK = GetterUtil.getLong((Object)jsonObject.get("classPK")))) != null) continue;
                        NoSuchArticleException throwable = new NoSuchArticleException("No JournalArticle exists with the key {resourcePrimKey=" + classPK + "}");
                        throwables.add(throwable);
                    }
                }
            }
            catch (DocumentException de) {
                if (!_log.isDebugEnabled()) break block8;
                _log.debug((Object)("Invalid content:\n" + content));
            }
        }
        if (!throwables.isEmpty()) {
            throw new PortalException((Throwable)new BulkException("Unable to validate journal article references", throwables));
        }
    }
}

