/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.exportimport.content.processor;

import com.liferay.exportimport.content.processor.ExportImportContentProcessor;
import com.liferay.exportimport.content.processor.base.BaseTextExportImportContentProcessor;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.journal.model.JournalFeed;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFeed"}, service={ExportImportContentProcessor.class, JournalFeedExportImportContentProcessor.class})
public class JournalFeedExportImportContentProcessor
extends BaseTextExportImportContentProcessor {
    private static final Log _log = LogFactoryUtil.getLog(JournalFeedExportImportContentProcessor.class);
    private GroupLocalService _groupLocalService;
    private LayoutLocalService _layoutLocalService;

    public String replaceExportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content, boolean exportReferencedContent, boolean escapeContent) throws Exception {
        String[] friendlyURLParts;
        String oldGroupFriendlyURL;
        JournalFeed feed = (JournalFeed)stagedModel;
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL();
        if ((newGroupFriendlyURL = newGroupFriendlyURL.substring(1)).equals(oldGroupFriendlyURL = (friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (String)"/"))[2])) {
            String targetLayoutFriendlyUrl = StringUtil.replaceFirst((String)feed.getTargetLayoutFriendlyUrl(), (String)("/" + newGroupFriendlyURL + "/"), (String)"/@data_handler_group_friendly_url@/");
            feed.setTargetLayoutFriendlyUrl(targetLayoutFriendlyUrl);
        }
        Group targetLayoutGroup = this._groupLocalService.fetchFriendlyURLGroup(portletDataContext.getCompanyId(), "/" + oldGroupFriendlyURL);
        boolean privateLayout = false;
        if (!PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING.equals("/" + friendlyURLParts[1])) {
            privateLayout = true;
        }
        String targetLayoutFriendlyURL = "/" + friendlyURLParts[3];
        Layout targetLayout = this._layoutLocalService.fetchLayoutByFriendlyURL(targetLayoutGroup.getGroupId(), privateLayout, targetLayoutFriendlyURL);
        Element feedElement = portletDataContext.getExportDataElement((ClassedModel)feed);
        portletDataContext.addReferenceElement((ClassedModel)feed, feedElement, (ClassedModel)targetLayout, "dependency", true);
        return content;
    }

    public String replaceImportContentReferences(PortletDataContext portletDataContext, StagedModel stagedModel, String content) throws Exception {
        JournalFeed feed = (JournalFeed)stagedModel;
        Group group = this._groupLocalService.getGroup(portletDataContext.getScopeGroupId());
        String newGroupFriendlyURL = group.getFriendlyURL();
        newGroupFriendlyURL = newGroupFriendlyURL.substring(1);
        String[] friendlyURLParts = StringUtil.split((String)feed.getTargetLayoutFriendlyUrl(), (char)'/');
        String oldGroupFriendlyURL = friendlyURLParts[2];
        if (oldGroupFriendlyURL.equals("@data_handler_group_friendly_url@")) {
            feed.setTargetLayoutFriendlyUrl(StringUtil.replace((String)feed.getTargetLayoutFriendlyUrl(), (String)"@data_handler_group_friendly_url@", (String)newGroupFriendlyURL));
        }
        return content;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(unbind="-")
    protected void setLayoutLocalService(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }
}

