/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.instance.lifecycle;

import com.liferay.journal.configuration.JournalServiceConfiguration;
import com.liferay.journal.service.JournalContentSearchLocalService;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={PortalInstanceLifecycleListener.class})
public class CheckJournalContentSearchPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private ConfigurationProvider _configurationProvider;
    private JournalContentSearchLocalService _journalContentSearchLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        JournalServiceConfiguration journalServiceConfiguration = (JournalServiceConfiguration)this._configurationProvider.getCompanyConfiguration(JournalServiceConfiguration.class, company.getCompanyId());
        if (!journalServiceConfiguration.syncContentSearchOnStartup()) {
            return;
        }
        this._journalContentSearchLocalService.checkContentSearches(company.getCompanyId());
    }

    @Reference(unbind="-")
    protected void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this._configurationProvider = configurationProvider;
    }

    @Reference(unbind="-")
    protected void setJournalContentSearchLocalService(JournalContentSearchLocalService journalContentSearchLocalService) {
        this._journalContentSearchLocalService = journalContentSearchLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }
}

