/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v0_0_3;

import com.liferay.asset.kernel.model.AssetCategory;
import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetVocabulary;
import com.liferay.asset.kernel.service.AssetCategoryLocalService;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.asset.kernel.service.AssetVocabularyLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portlet.asset.util.AssetVocabularySettingsHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class UpgradeJournalArticleType
extends UpgradeProcess {
    private final AssetCategoryLocalService _assetCategoryLocalService;
    private final AssetEntryLocalService _assetEntryLocalService;
    private final AssetVocabularyLocalService _assetVocabularyLocalService;
    private final CompanyLocalService _companyLocalService;
    private final UserLocalService _userLocalService;

    public UpgradeJournalArticleType(AssetCategoryLocalService assetCategoryLocalService, AssetEntryLocalService assetEntryLocalService, AssetVocabularyLocalService assetVocabularyLocalService, CompanyLocalService companyLocalService, UserLocalService userLocalService) {
        this._assetCategoryLocalService = assetCategoryLocalService;
        this._assetEntryLocalService = assetEntryLocalService;
        this._assetVocabularyLocalService = assetVocabularyLocalService;
        this._companyLocalService = companyLocalService;
        this._userLocalService = userLocalService;
    }

    protected AssetCategory addAssetCategory(long groupId, long companyId, String title, long assetVocabularyId) throws Exception {
        long userId = this._userLocalService.getDefaultUserId(companyId);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this._assetCategoryLocalService.addCategory(userId, groupId, title, assetVocabularyId, serviceContext);
    }

    protected AssetVocabulary addAssetVocabulary(long groupId, long companyId, String title, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap) throws Exception {
        long userId = this._userLocalService.getDefaultUserId(companyId);
        AssetVocabularySettingsHelper assetVocabularySettingsHelper = new AssetVocabularySettingsHelper();
        assetVocabularySettingsHelper.setClassNameIdsAndClassTypePKs(new long[]{PortalUtil.getClassNameId((String)JournalArticle.class.getName())}, new long[]{-1L}, new boolean[]{false});
        assetVocabularySettingsHelper.setMultiValued(false);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this._assetVocabularyLocalService.addVocabulary(userId, groupId, title, nameMap, descriptionMap, assetVocabularySettingsHelper.toString(), serviceContext);
    }

    protected void alterTable() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.runSQL("alter table JournalArticle drop column type_");
        }
    }

    protected void doUpgrade() throws Exception {
        this.updateArticleType();
        this.alterTable();
    }

    /*
     * Exception decompiling
     */
    protected List<String> getArticleTypes() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected boolean hasSelectedArticleTypes() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void updateArticles(long companyId, Map<String, Long> journalArticleTypesToAssetCategoryIds) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append("select JournalArticle.resourcePrimKey, ");
        sb.append("JournalArticle.type_ from JournalArticle left join ");
        sb.append("JournalArticle tempJournalArticle on ");
        sb.append("(JournalArticle.groupId = tempJournalArticle.groupId) and ");
        sb.append("(JournalArticle.articleId = tempJournalArticle.articleId) ");
        sb.append("and (JournalArticle.version < tempJournalArticle.version) ");
        sb.append("where JournalArticle.companyId = ? and ");
        sb.append("tempJournalArticle.id_ is null");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setLong(1, companyId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long resourcePrimKey = rs.getLong("resourcePrimKey");
                    AssetEntry assetEntry = this._assetEntryLocalService.fetchEntry(JournalArticle.class.getName(), resourcePrimKey);
                    if (assetEntry == null) continue;
                    String type = rs.getString("type_");
                    long assetCategoryId = journalArticleTypesToAssetCategoryIds.get(type);
                    this._assetEntryLocalService.addAssetCategoryAssetEntry(assetCategoryId, assetEntry);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateArticleType() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!this.hasSelectedArticleTypes()) {
                return;
            }
            List<String> types = this.getArticleTypes();
            if (types.size() <= 0) {
                return;
            }
            Locale localeThreadLocalDefaultLocale = LocaleThreadLocal.getDefaultLocale();
            try {
                List companies = this._companyLocalService.getCompanies();
                for (Company company : companies) {
                    LocaleThreadLocal.setDefaultLocale((Locale)company.getLocale());
                    Set locales = LanguageUtil.getAvailableLocales((long)company.getGroupId());
                    Locale defaultLocale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)company.getCompanyId()));
                    Map nameMap = LocalizationUtil.getLocalizationMap((Collection)locales, (Locale)defaultLocale, (String)"type");
                    AssetVocabulary assetVocabulary = this.addAssetVocabulary(company.getGroupId(), company.getCompanyId(), "type", nameMap, new HashMap<Locale, String>());
                    HashMap<String, Long> journalArticleTypesToAssetCategoryIds = new HashMap<String, Long>();
                    for (String type : types) {
                        AssetCategory assetCategory = this.addAssetCategory(company.getGroupId(), company.getCompanyId(), type, assetVocabulary.getVocabularyId());
                        journalArticleTypesToAssetCategoryIds.put(type, assetCategory.getCategoryId());
                    }
                    this.updateArticles(company.getCompanyId(), journalArticleTypesToAssetCategoryIds);
                }
            }
            finally {
                LocaleThreadLocal.setDefaultLocale((Locale)localeThreadLocalDefaultLocale);
            }
        }
    }
}

