/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradeImageTypeContentAttributes
extends UpgradeProcess {
    protected String addImageContentAttributes(String content) throws Exception {
        Document contentDocument = SAXReaderUtil.read((String)content);
        contentDocument = contentDocument.clone();
        XPath xPath = SAXReaderUtil.createXPath((String)"//dynamic-element[@type='image']");
        List imageNodes = xPath.selectNodes((Object)contentDocument);
        for (Node imageNode : imageNodes) {
            Element imageEl = (Element)imageNode;
            List dynamicContentEls = imageEl.elements("dynamic-content");
            for (Element dynamicContentEl : dynamicContentEls) {
                String id = dynamicContentEl.attributeValue("id");
                dynamicContentEl.addAttribute("alt", "");
                dynamicContentEl.addAttribute("name", id);
                dynamicContentEl.addAttribute("title", id);
                dynamicContentEl.addAttribute("type", "journal");
            }
        }
        return contentDocument.formattedString();
    }

    protected void doUpgrade() throws Exception {
        this.updateContentImages();
    }

    protected void updateContentImages() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select content, id_ from JournalArticle where content like ?");){
            ps1.setString(1, "%type=\"image\"%");
            ResultSet rs = ps1.executeQuery();
            while (rs.next()) {
                String content = rs.getString(1);
                long id = rs.getLong(2);
                String newContent = this.addImageContentAttributes(content);
                PreparedStatement ps = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)"update JournalArticle set content = ? where id_ = ?");
                Throwable throwable = null;
                try {
                    ps.setString(1, newContent);
                    ps.setLong(2, id);
                    ps.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ps == null) continue;
                    if (throwable != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ps.close();
                }
            }
        }
    }
}

