/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.internal.upgrade.v1_0_0;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeJournalArticleImage
extends UpgradeProcess {
    protected void doUpgrade() throws Exception {
        this.updateJournalArticleImagesInstanceId();
        this.updateJournalArticleImagesName();
    }

    protected void updateJournalArticleImagesInstanceId() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select articleId, elName from JournalArticleImage where (elInstanceId = '' or elInstanceId is null) group by articleId, elName");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update JournalArticleImage set elInstanceId = ? where articleId = ? and elName = ?"));){
            while (rs.next()) {
                String articleId = rs.getString(1);
                String elName = rs.getString(2);
                ps2.setString(1, StringUtil.randomString((int)4));
                ps2.setString(2, articleId);
                ps2.setString(3, elName);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }

    protected void updateJournalArticleImagesName() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps1 = this.connection.prepareStatement("select articleImageId, elName from JournalArticleImage");
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch((PreparedStatement)this.connection.prepareStatement("update JournalArticleImage set elName = ? where articleImageId = ?"));){
            while (rs.next()) {
                long articleImageId = rs.getLong(1);
                String elName = rs.getString(2);
                int lastIndexOf = elName.lastIndexOf("_");
                if (lastIndexOf > 0) {
                    elName = elName.substring(0, lastIndexOf);
                }
                ps2.setString(1, elName);
                ps2.setLong(2, articleImageId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

