/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.impl;

import com.liferay.journal.exception.DuplicateArticleImageIdException;
import com.liferay.journal.model.JournalArticleImage;
import com.liferay.journal.service.base.JournalArticleImageLocalServiceBaseImpl;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.List;

public class JournalArticleImageLocalServiceImpl
extends JournalArticleImageLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(JournalArticleImageLocalServiceImpl.class);

    public void addArticleImageId(long articleImageId, long groupId, String articleId, double version, String elInstanceId, String elName, String languageId) throws PortalException {
        if (articleImageId <= 0L) {
            return;
        }
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByG_A_V_E_E_L(groupId, articleId, version, elInstanceId, elName, languageId);
        if (articleImage == null) {
            articleImage = this.journalArticleImagePersistence.create(articleImageId);
            articleImage.setGroupId(groupId);
            articleImage.setArticleId(articleId);
            articleImage.setVersion(version);
            articleImage.setElInstanceId(elInstanceId);
            articleImage.setElName(elName);
            articleImage.setLanguageId(languageId);
            articleImage.setTempImage(false);
            this.journalArticleImagePersistence.update((BaseModel)articleImage);
        } else if (articleImage.getArticleImageId() != articleImageId) {
            throw new DuplicateArticleImageIdException("{articleImageId=" + articleImageId + "}");
        }
    }

    public void deleteArticleImage(JournalArticleImage articleImage) {
        block2: {
            try {
                this.imageLocalService.deleteImage(articleImage.getArticleImageId());
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to delete image " + articleImage.getArticleImageId()), (Throwable)pe);
            }
        }
        this.journalArticleImagePersistence.remove((BaseModel)articleImage);
    }

    public void deleteArticleImage(long articleImageId) {
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByPrimaryKey(articleImageId);
        if (articleImage != null) {
            this.deleteArticleImage(articleImage);
        }
    }

    public void deleteArticleImage(long groupId, String articleId, double version, String elInstanceId, String elName, String languageId) {
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByG_A_V_E_E_L(groupId, articleId, version, elInstanceId, elName, languageId);
        if (articleImage != null) {
            this.deleteArticleImage(articleImage);
        }
    }

    public void deleteImages(long groupId, String articleId, double version) {
        for (JournalArticleImage articleImage : this.journalArticleImagePersistence.findByG_A_V(groupId, articleId, version)) {
            this.deleteArticleImage(articleImage);
        }
    }

    public JournalArticleImage getArticleImage(long articleImageId) throws PortalException {
        return this.journalArticleImagePersistence.findByPrimaryKey(articleImageId);
    }

    public long getArticleImageId(long groupId, String articleId, double version, String elInstanceId, String elName, String languageId) {
        return this.getArticleImageId(groupId, articleId, version, elInstanceId, elName, languageId, false);
    }

    public long getArticleImageId(long groupId, String articleId, double version, String elInstanceId, String elName, String languageId, boolean tempImage) {
        JournalArticleImage articleImage = this.journalArticleImagePersistence.fetchByG_A_V_E_E_L(groupId, articleId, version, elInstanceId, elName, languageId);
        if (articleImage == null) {
            long articleImageId = this.counterLocalService.increment();
            articleImage = this.journalArticleImagePersistence.create(articleImageId);
            articleImage.setGroupId(groupId);
            articleImage.setArticleId(articleId);
            articleImage.setVersion(version);
            articleImage.setElInstanceId(elInstanceId);
            articleImage.setElName(elName);
            articleImage.setLanguageId(languageId);
            articleImage.setTempImage(tempImage);
            this.journalArticleImagePersistence.update((BaseModel)articleImage);
        }
        return articleImage.getArticleImageId();
    }

    public List<JournalArticleImage> getArticleImages(long groupId) {
        return this.journalArticleImagePersistence.findByGroupId(groupId);
    }

    public List<JournalArticleImage> getArticleImages(long groupId, String articleId, double version) {
        return this.journalArticleImagePersistence.findByG_A_V(groupId, articleId, version);
    }

    public int getArticleImagesCount(long groupId) {
        return this.journalArticleImagePersistence.countByGroupId(groupId);
    }
}

