/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFeed;
import com.liferay.journal.service.JournalFeedLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFeed"}, service={BaseModelPermissionChecker.class})
public class JournalFeedPermission
implements BaseModelPermissionChecker {
    private static JournalFeedLocalService _journalFeedLocalService;

    public static void check(PermissionChecker permissionChecker, JournalFeed feed, String actionId) throws PortalException {
        if (!JournalFeedPermission.contains(permissionChecker, feed, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalFeed.class.getName(), feed.getFeedId(), actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long id, String actionId) throws PortalException {
        if (!JournalFeedPermission.contains(permissionChecker, id, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, JournalFeed.class.getName(), id, new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, String feedId, String actionId) throws PortalException {
        if (!JournalFeedPermission.contains(permissionChecker, groupId, feedId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, new String[]{JournalFeed.class.getName(), feedId, actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalFeed feed, String actionId) {
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        Boolean hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)feed.getGroupId(), (String)JournalFeed.class.getName(), (long)feed.getPrimaryKey(), (String)portletId, (String)actionId);
        if (hasPermission != null) {
            return hasPermission;
        }
        if (permissionChecker.hasOwnerPermission(feed.getCompanyId(), JournalFeed.class.getName(), feed.getId(), feed.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(feed.getGroupId(), JournalFeed.class.getName(), feed.getId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long feedId, String actionId) throws PortalException {
        JournalFeed feed = _journalFeedLocalService.getFeed(feedId);
        return JournalFeedPermission.contains(permissionChecker, feed, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, String feedId, String actionId) throws PortalException {
        JournalFeed feed = _journalFeedLocalService.getFeed(groupId, feedId);
        return JournalFeedPermission.contains(permissionChecker, feed, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        JournalFeedPermission.check(permissionChecker, primaryKey, actionId);
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalFeedLocalService journalFeedLocalService) {
        _journalFeedLocalService = journalFeedLocalService;
    }
}

