/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.permission;

import com.liferay.exportimport.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.journal.exception.NoSuchFolderException;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.journal.service.permission.JournalPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalFolder"}, service={BaseModelPermissionChecker.class})
public class JournalFolderPermission
implements BaseModelPermissionChecker {
    private static JournalFolderLocalService _journalFolderLocalService;

    public static void check(PermissionChecker permissionChecker, JournalFolder folder, String actionId) throws PortalException {
        if (!JournalFolderPermission.contains(permissionChecker, folder, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, JournalFolder.class.getName(), folder.getFolderId(), new String[]{actionId});
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException {
        if (!JournalFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, JournalFolder.class.getName(), folderId, new String[]{actionId});
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, JournalFolder folder, String actionId) throws PortalException {
        Boolean hasPermission;
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)folder.getGroupId(), (String)JournalFolder.class.getName(), (long)folder.getFolderId(), (String)portletId, (String)actionId)) != null) {
            return hasPermission;
        }
        if (actionId.equals("VIEW") && PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
            block7: {
                try {
                    long folderId = folder.getFolderId();
                    while (folderId != 0L) {
                        folder = _journalFolderLocalService.getFolder(folderId);
                        if (!JournalFolderPermission._hasPermission(permissionChecker, folder, actionId)) {
                            return false;
                        }
                        folderId = folder.getParentFolderId();
                    }
                }
                catch (NoSuchFolderException nsfe) {
                    if (folder.isInTrash()) break block7;
                    throw nsfe;
                }
            }
            return JournalPermission.contains(permissionChecker, folder.getGroupId(), actionId);
        }
        return JournalFolderPermission._hasPermission(permissionChecker, folder, actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException {
        if (folderId == 0L) {
            return JournalPermission.contains(permissionChecker, groupId, actionId);
        }
        JournalFolder folder = _journalFolderLocalService.getJournalFolder(folderId);
        return JournalFolderPermission.contains(permissionChecker, folder, actionId);
    }

    public void checkBaseModel(PermissionChecker permissionChecker, long groupId, long primaryKey, String actionId) throws PortalException {
        JournalFolderPermission.check(permissionChecker, groupId, primaryKey, actionId);
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        _journalFolderLocalService = journalFolderLocalService;
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, JournalFolder folder, String actionId) {
        return permissionChecker.hasOwnerPermission(folder.getCompanyId(), JournalFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId) || permissionChecker.hasPermission(folder.getGroupId(), JournalFolder.class.getName(), folder.getFolderId(), actionId);
    }
}

