/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.service.persistence.impl;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.model.impl.JournalFolderImpl;
import com.liferay.journal.service.persistence.JournalArticleUtil;
import com.liferay.journal.service.persistence.JournalFolderFinder;
import com.liferay.journal.service.persistence.JournalFolderUtil;
import com.liferay.journal.service.persistence.impl.JournalFolderFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQLUtil;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JournalFolderFinderImpl
extends JournalFolderFinderBaseImpl
implements JournalFolderFinder {
    public static final String COUNT_A_BY_G_U_F = JournalFolderFinder.class.getName() + ".countA_ByG_U_F";
    public static final String COUNT_F_BY_G_F = JournalFolderFinder.class.getName() + ".countF_ByG_F";
    public static final String FIND_A_BY_G_U_F = JournalFolderFinder.class.getName() + ".findA_ByG_U_F";
    public static final String FIND_F_BY_NO_ASSETS = JournalFolderFinder.class.getName() + ".findF_ByNoAssets";
    public static final String FIND_F_BY_G_F = JournalFolderFinder.class.getName() + ".findF_ByG_F";

    public int countF_A_ByG_F(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.doCountF_A_ByG_F(groupId, folderId, queryDefinition, false);
    }

    public int filterCountF_A_ByG_F(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.doCountF_A_ByG_F(groupId, folderId, queryDefinition, true);
    }

    public List<Object> filterFindF_A_ByG_F(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.doFindF_A_ByG_F(groupId, folderId, queryDefinition, true);
    }

    public List<Object> findF_A_ByG_F(long groupId, long folderId, QueryDefinition<?> queryDefinition) {
        return this.doFindF_A_ByG_F(groupId, folderId, queryDefinition, false);
    }

    public List<JournalFolder> findF_ByNoAssets() {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get(((Object)((Object)this)).getClass(), (String)FIND_F_BY_NO_ASSETS);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addEntity("JournalFolder", JournalFolderImpl.class);
            List list = q.list(true);
            return list;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected int doCountF_A_ByG_F(long groupId, long folderId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            sb.append(this.getFoldersSQL(COUNT_F_BY_G_F, groupId, queryDefinition, inlineSQLHelper));
            sb.append(") UNION ALL (");
            sb.append(this.getArticlesSQL(COUNT_A_BY_G_U_F, groupId, queryDefinition, inlineSQLHelper));
            sb.append(")");
            String sql = this.updateSQL(sb.toString(), folderId);
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                qPos.add(folderId);
            }
            qPos.add(groupId);
            if (queryDefinition.getOwnerUserId() > 0L) {
                qPos.add(queryDefinition.getOwnerUserId());
                qPos.add(8);
            }
            qPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                qPos.add(folderId);
            }
            int count = 0;
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Long l = (Long)itr.next();
                if (l == null) continue;
                count += l.intValue();
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Object> doFindF_A_ByG_F(long groupId, long folderId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        Session session = null;
        try {
            session = this.openSession();
            StringBundler sb = new StringBundler(5);
            sb.append("(");
            sb.append(this.getFoldersSQL(FIND_F_BY_G_F, groupId, queryDefinition, inlineSQLHelper));
            sb.append(") UNION ALL (");
            sb.append(this.getArticlesSQL(FIND_A_BY_G_U_F, groupId, queryDefinition, inlineSQLHelper));
            sb.append(")");
            String sql = this.updateSQL(sb.toString(), folderId);
            sql = CustomSQLUtil.replaceOrderBy((String)sql, (OrderByComparator)queryDefinition.getOrderByComparator());
            SQLQuery q = session.createSynchronizedSQLQuery(sql);
            q.addScalar("modelFolderId", Type.LONG);
            q.addScalar("modelFolder", Type.LONG);
            q.addScalar("articleId", Type.STRING);
            q.addScalar("version", Type.DOUBLE);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                qPos.add(folderId);
            }
            qPos.add(groupId);
            if (queryDefinition.getOwnerUserId() > 0L) {
                qPos.add(queryDefinition.getOwnerUserId());
                qPos.add(8);
            }
            qPos.add(queryDefinition.getStatus());
            if (folderId >= 0L) {
                qPos.add(folderId);
            }
            ArrayList<Object> models = new ArrayList<Object>();
            Iterator itr = QueryUtil.iterate((Query)q, (Dialect)this.getDialect(), (int)queryDefinition.getStart(), (int)queryDefinition.getEnd());
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                long curFolderId = (Long)array[0];
                long modelFolder = (Long)array[1];
                JournalFolder obj = null;
                if (modelFolder == 1L) {
                    obj = JournalFolderUtil.findByPrimaryKey((long)curFolderId);
                } else {
                    String articleId = (String)array[2];
                    double version = (Double)array[3];
                    obj = JournalArticleUtil.findByG_A_V((long)groupId, (String)articleId, (double)version);
                }
                models.add(obj);
            }
            ArrayList<Object> arrayList = models;
            return arrayList;
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getArticlesSQL(String id, long groupId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        String sql = CustomSQLUtil.get(((Object)((Object)this)).getClass(), (String)id, queryDefinition, (String)"JournalArticle");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)JournalArticle.class.getName(), (String)"JournalArticle.resourcePrimKey", (long)groupId);
        }
        return sql;
    }

    protected String getFolderId(long folderId, String tableName) {
        if (folderId < 0L) {
            return "";
        }
        StringBundler sb = new StringBundler(5);
        sb.append(" AND ");
        sb.append(tableName);
        sb.append(".");
        if (tableName.equals("JournalFolder")) {
            sb.append("parentFolderId");
        } else {
            sb.append("folderId");
        }
        sb.append(" = ? ");
        return sb.toString();
    }

    protected String getFoldersSQL(String id, long groupId, QueryDefinition<?> queryDefinition, boolean inlineSQLHelper) {
        String sql = CustomSQLUtil.get(((Object)((Object)this)).getClass(), (String)id, queryDefinition, (String)"JournalFolder");
        if (inlineSQLHelper) {
            sql = InlineSQLHelperUtil.replacePermissionCheck((String)sql, (String)JournalFolder.class.getName(), (String)"JournalFolder.folderId", (long)groupId);
        }
        return sql;
    }

    protected String updateSQL(String sql, long folderId) {
        sql = StringUtil.replace((String)sql, (String[])new String[]{"[$ARTICLE_FOLDER_ID$]", "[$FOLDER_PARENT_FOLDER_ID$]"}, (String[])new String[]{this.getFolderId(folderId, "JournalArticle"), this.getFolderId(folderId, "JournalFolder")});
        return sql;
    }
}

