/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.impl;

import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleDisplay;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.permission.JournalArticlePermission;
import com.liferay.journal.util.JournalContent;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.index.IndexEncoder;
import com.liferay.portal.kernel.cache.index.PortalCacheIndexer;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterableInvokerUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.portlet.PortletRequestModel;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.ReflectionUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang.time.StopWatch;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@DoPrivileged
@Component(service={IdentifiableOSGiService.class, JournalContent.class})
public class JournalContentImpl
implements IdentifiableOSGiService,
JournalContent {
    protected static final String CACHE_NAME = JournalContent.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(JournalContentImpl.class);
    private static final Method _clearCacheMethod;
    private static PortalCache<JournalContentKey, JournalArticleDisplay> _portalCache;
    private static PortalCacheIndexer<String, JournalContentKey, JournalArticleDisplay> _portalCacheIndexer;
    private JournalArticleLocalService _journalArticleLocalService;

    public void clearCache() {
        if (ExportImportThreadLocal.isImportInProcess()) {
            return;
        }
        _portalCache.removeAll();
    }

    public void clearCache(long groupId, String articleId, String ddmTemplateKey) {
        _portalCacheIndexer.removeKeys((Object)JournalContentKeyIndexEncoder.encode(groupId, articleId, ddmTemplateKey));
        if (ClusterInvokeThreadLocal.isEnabled()) {
            try {
                ClusterableInvokerUtil.invokeOnCluster(ClusterInvokeAcceptor.class, (Object)this, (Method)_clearCacheMethod, (Object[])new Object[]{groupId, articleId, ddmTemplateKey});
            }
            catch (Throwable t) {
                ReflectionUtil.throwException((Throwable)t);
            }
        }
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, portletRequestModel, null);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, portletRequestModel, null);
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        JournalArticleDisplay articleDisplay = this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
        if (articleDisplay != null) {
            return articleDisplay.getContent();
        }
        return null;
    }

    public String getContent(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, ddmTemplateKey, viewMode, languageId, null, themeDisplay);
    }

    public String getContent(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getContent(groupId, articleId, null, viewMode, languageId, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        long groupId = article.getGroupId();
        String articleId = article.getArticleId();
        double version = article.getVersion();
        articleId = StringUtil.toUpperCase((String)GetterUtil.getString((String)articleId));
        ddmTemplateKey = StringUtil.toUpperCase((String)GetterUtil.getString((String)ddmTemplateKey));
        long layoutSetId = 0L;
        boolean secure = false;
        if (themeDisplay != null) {
            try {
                if (!JournalArticlePermission.contains(themeDisplay.getPermissionChecker(), article, "VIEW")) {
                    return null;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            LayoutSet layoutSet = themeDisplay.getLayoutSet();
            layoutSetId = layoutSet.getLayoutSetId();
            secure = themeDisplay.isSecure();
        }
        JournalContentKey journalContentKey = new JournalContentKey(groupId, articleId, version, ddmTemplateKey, layoutSetId, viewMode, languageId, page, secure);
        JournalArticleDisplay articleDisplay = (JournalArticleDisplay)_portalCache.get((Serializable)journalContentKey);
        boolean lifecycleRender = false;
        if (portletRequestModel != null) {
            lifecycleRender = "RENDER_PHASE".equals(portletRequestModel.getLifecycle());
        }
        if ((articleDisplay == null || !lifecycleRender) && (articleDisplay = this.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay)) != null && articleDisplay.isCacheable() && lifecycleRender) {
            _portalCache.put((Serializable)journalContentKey, (Object)articleDisplay);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("getDisplay for {" + groupId + ", " + articleId + ", " + ddmTemplateKey + ", " + viewMode + ", " + languageId + ", " + page + "} takes " + stopWatch.getTime() + " ms"));
        }
        return articleDisplay;
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, double version, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            JournalArticle article = this._journalArticleLocalService.getArticle(groupId, articleId, version);
            return this.getDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get display for " + groupId + " " + articleId + " " + languageId), (Throwable)pe);
            }
            return null;
        }
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, int page, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, page, null, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getDisplay(groupId, articleId, null, viewMode, languageId, 1, portletRequestModel, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, 0.0, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, PortletRequestModel portletRequestModel) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, portletRequestModel, null);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, 1, null, themeDisplay);
    }

    public JournalArticleDisplay getDisplay(long groupId, String articleId, String viewMode, String languageId, ThemeDisplay themeDisplay) {
        return this.getDisplay(groupId, articleId, viewMode, languageId, 1, themeDisplay);
    }

    public String getOSGiServiceIdentifier() {
        return JournalContent.class.getName();
    }

    protected JournalArticleDisplay getArticleDisplay(JournalArticle article, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        if (article.getStatus() != 0) {
            return null;
        }
        Date now = new Date();
        Date displayDate = article.getDisplayDate();
        Date expirationDate = article.getExpirationDate();
        if (displayDate != null && displayDate.after(now) || expirationDate != null && expirationDate.before(now)) {
            return null;
        }
        try {
            return this._journalArticleLocalService.getArticleDisplay(article, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get display for " + article + " " + languageId), (Throwable)e);
            }
            return null;
        }
    }

    protected JournalArticleDisplay getArticleDisplay(long groupId, String articleId, String ddmTemplateKey, String viewMode, String languageId, int page, PortletRequestModel portletRequestModel, ThemeDisplay themeDisplay) {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Get article display {" + groupId + ", " + articleId + ", " + ddmTemplateKey + "}"));
            }
            return this._journalArticleLocalService.getArticleDisplay(groupId, articleId, ddmTemplateKey, viewMode, languageId, page, portletRequestModel, themeDisplay);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get display for " + groupId + " " + articleId + " " + languageId));
            }
            return null;
        }
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setMultiVMPool(MultiVMPool multiVMPool) {
        _portalCache = multiVMPool.getPortalCache(CACHE_NAME);
        _portalCacheIndexer = new PortalCacheIndexer((IndexEncoder)new JournalContentKeyIndexEncoder(), _portalCache);
    }

    static {
        try {
            _clearCacheMethod = JournalContent.class.getMethod("clearCache", Long.TYPE, String.class, String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
    }

    private static class JournalContentKeyIndexEncoder
    implements IndexEncoder<String, JournalContentKey> {
        private JournalContentKeyIndexEncoder() {
        }

        public static String encode(long groupId, String articleId, String ddmTemplateKey) {
            StringBundler sb = new StringBundler(5);
            sb.append(groupId);
            sb.append("_");
            sb.append(articleId);
            sb.append("_");
            sb.append(ddmTemplateKey);
            return sb.toString();
        }

        public String encode(JournalContentKey journalContentKey) {
            return JournalContentKeyIndexEncoder.encode(journalContentKey._groupId, journalContentKey._articleId, journalContentKey._ddmTemplateKey);
        }
    }

    private static class JournalContentKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String _articleId;
        private final String _ddmTemplateKey;
        private final long _groupId;
        private final String _languageId;
        private final long _layoutSetId;
        private final int _page;
        private final boolean _secure;
        private final double _version;
        private final String _viewMode;

        public boolean equals(Object obj) {
            JournalContentKey journalContentKey = (JournalContentKey)obj;
            return journalContentKey._groupId == this._groupId && Objects.equals(journalContentKey._articleId, this._articleId) && journalContentKey._version == this._version && Objects.equals(journalContentKey._ddmTemplateKey, this._ddmTemplateKey) && journalContentKey._layoutSetId == this._layoutSetId && Objects.equals(journalContentKey._viewMode, this._viewMode) && Objects.equals(journalContentKey._languageId, this._languageId) && journalContentKey._page == this._page && journalContentKey._secure == this._secure;
        }

        public int hashCode() {
            int hashCode = HashUtil.hash((int)0, (long)this._groupId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._articleId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._version);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._ddmTemplateKey);
            hashCode = HashUtil.hash((int)hashCode, (long)this._layoutSetId);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._viewMode);
            hashCode = HashUtil.hash((int)hashCode, (Object)this._languageId);
            hashCode = HashUtil.hash((int)hashCode, (int)this._page);
            return HashUtil.hash((int)hashCode, (boolean)this._secure);
        }

        private JournalContentKey(long groupId, String articleId, double version, String ddmTemplateKey, long layoutSetId, String viewMode, String languageId, int page, boolean secure) {
            this._groupId = groupId;
            this._articleId = articleId;
            this._version = version;
            this._ddmTemplateKey = ddmTemplateKey;
            this._layoutSetId = layoutSetId;
            this._viewMode = viewMode;
            this._languageId = languageId;
            this._page = page;
            this._secure = secure;
        }
    }
}

