/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.util.impl;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.FieldConstants;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.dynamic.data.mapping.util.impl.DDMFieldsCounter;
import com.liferay.journal.util.JournalConverter;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class JournalConverterImpl
implements JournalConverter {
    private static final Log _log = LogFactoryUtil.getLog(JournalConverterImpl.class);
    private final Map<String, String> _ddmDataTypes;
    private final Map<String, String> _ddmMetadataAttributes;
    private final Map<String, String> _ddmTypesToJournalTypes;
    private DLAppLocalService _dlAppLocalService;
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    private GroupLocalService _groupLocalService;
    private final Map<String, String> _journalTypesToDDMTypes;
    private final Pattern _oldDocumentLibraryURLPattern = Pattern.compile("uuid=([^&]+)&groupId=([^&]+)");

    public JournalConverterImpl() {
        this._ddmDataTypes = new HashMap<String, String>();
        this._ddmDataTypes.put("boolean", "boolean");
        this._ddmDataTypes.put("document_library", "document-library");
        this._ddmDataTypes.put("image", "image");
        this._ddmDataTypes.put("link_to_layout", "link-to-page");
        this._ddmDataTypes.put("list", "string");
        this._ddmDataTypes.put("multi-list", "string");
        this._ddmDataTypes.put("text", "string");
        this._ddmDataTypes.put("text_area", "html");
        this._ddmDataTypes.put("text_box", "string");
        this._ddmMetadataAttributes = new HashMap<String, String>();
        this._ddmMetadataAttributes.put("instructions", "tip");
        this._ddmMetadataAttributes.put("label", "label");
        this._ddmMetadataAttributes.put("predefinedValue", "predefinedValue");
        this._ddmTypesToJournalTypes = new HashMap<String, String>();
        this._ddmTypesToJournalTypes.put("checkbox", "boolean");
        this._ddmTypesToJournalTypes.put("ddm-documentlibrary", "document_library");
        this._ddmTypesToJournalTypes.put("ddm-image", "image");
        this._ddmTypesToJournalTypes.put("ddm-link-to-page", "link_to_layout");
        this._ddmTypesToJournalTypes.put("ddm-separator", "selection_break");
        this._ddmTypesToJournalTypes.put("ddm-text-html", "text_area");
        this._ddmTypesToJournalTypes.put("select", "list");
        this._ddmTypesToJournalTypes.put("text", "text");
        this._ddmTypesToJournalTypes.put("textarea", "text_box");
        this._journalTypesToDDMTypes = new HashMap<String, String>();
        this._journalTypesToDDMTypes.put("boolean", "checkbox");
        this._journalTypesToDDMTypes.put("document_library", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("image", "ddm-image");
        this._journalTypesToDDMTypes.put("image_gallery", "ddm-documentlibrary");
        this._journalTypesToDDMTypes.put("link_to_layout", "ddm-link-to-page");
        this._journalTypesToDDMTypes.put("list", "select");
        this._journalTypesToDDMTypes.put("multi-list", "select");
        this._journalTypesToDDMTypes.put("selection_break", "ddm-separator");
        this._journalTypesToDDMTypes.put("text", "text");
        this._journalTypesToDDMTypes.put("text_area", "ddm-text-html");
        this._journalTypesToDDMTypes.put("text_box", "textarea");
    }

    public String getContent(DDMStructure ddmStructure, Fields ddmFields) throws Exception {
        Document document = SAXReaderUtil.createDocument();
        Element rootElement = document.addElement("root");
        String availableLocales = this.getAvailableLocales(ddmFields);
        rootElement.addAttribute("available-locales", availableLocales);
        Locale defaultLocale = ddmFields.getDefaultLocale();
        rootElement.addAttribute("default-locale", LocaleUtil.toLanguageId((Locale)defaultLocale));
        DDMFieldsCounter ddmFieldsCounter = new DDMFieldsCounter();
        for (String fieldName : ddmStructure.getRootFieldNames()) {
            int repetitions = this.countFieldRepetition(ddmFields, fieldName, null, -1);
            for (int i = 0; i < repetitions; ++i) {
                Element dynamicElementElement = rootElement.addElement("dynamic-element");
                dynamicElementElement.addAttribute("name", fieldName);
                this.updateContentDynamicElement(dynamicElementElement, ddmStructure, ddmFields, ddmFieldsCounter);
            }
        }
        return XMLUtil.formatXML((String)document.asXML());
    }

    public Fields getDDMFields(DDMStructure ddmStructure, Document document) throws PortalException {
        Field fieldsDisplayField = new Field(ddmStructure.getStructureId(), "_fieldsDisplay", (Serializable)((Object)""));
        Fields ddmFields = new Fields();
        ddmFields.put(fieldsDisplayField);
        Element rootElement = document.getRootElement();
        String[] availableLanguageIds = StringUtil.split((String)rootElement.attributeValue("available-locales"));
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.addDDMFields(dynamicElementElement, ddmStructure, ddmFields, availableLanguageIds, defaultLanguageId);
        }
        return ddmFields;
    }

    public Fields getDDMFields(DDMStructure ddmStructure, String content) throws PortalException {
        try {
            return this.getDDMFields(ddmStructure, SAXReaderUtil.read((String)content));
        }
        catch (DocumentException de) {
            throw new PortalException((Throwable)de);
        }
    }

    public DDMFormValues getDDMFormValues(DDMStructure ddmStructure, Fields fields) throws PortalException {
        return this._fieldsToDDMFormValuesConverter.convert(ddmStructure, fields);
    }

    @Deprecated
    public String getDDMXSD(String journalXSD) throws Exception {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        return this.getDDMXSD(journalXSD, defaultLocale);
    }

    @Deprecated
    public String getDDMXSD(String journalXSD, Locale defaultLocale) throws Exception {
        Document document = SAXReaderUtil.read((String)journalXSD);
        Element rootElement = document.getRootElement();
        rootElement.addAttribute("available-locales", defaultLocale.toString());
        rootElement.addAttribute("default-locale", defaultLocale.toString());
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLocale.toString());
        }
        return XMLUtil.formatXML((Document)document);
    }

    @Deprecated
    public String getJournalXSD(String ddmXSD) throws Exception {
        Document document = SAXReaderUtil.read((String)ddmXSD);
        Element rootElement = document.getRootElement();
        String defaultLanguageId = rootElement.attributeValue("default-locale");
        this.removeAttribute(rootElement, "available-locales");
        this.removeAttribute(rootElement, "default-locale");
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateDDMXSDDynamicElement(dynamicElementElement, defaultLanguageId);
        }
        return XMLUtil.formatXML((Document)document);
    }

    @Reference(unbind="-")
    public void setFieldsToDDMFormValuesConverter(FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
    }

    protected void addDDMFields(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, String[] availableLanguageIds, String defaultLanguageId) throws PortalException {
        String name = dynamicElementElement.attributeValue("name");
        String instanceId = dynamicElementElement.attributeValue("instance-id");
        if (!ddmStructure.hasField(name)) {
            return;
        }
        if (!ddmStructure.isFieldTransient(name)) {
            Field ddmField = this.getField(dynamicElementElement, ddmStructure, availableLanguageIds, defaultLanguageId);
            String fieldName = ddmField.getName();
            Field existingDDMField = ddmFields.get(fieldName);
            if (existingDDMField != null) {
                for (Locale locale : ddmField.getAvailableLocales()) {
                    existingDDMField.addValues(locale, ddmField.getValues(locale));
                }
            } else {
                ddmFields.put(ddmField);
            }
        }
        this.updateFieldsDisplay(ddmFields, name, instanceId);
        List childrenDynamicElementElements = dynamicElementElement.elements("dynamic-element");
        for (Element childrenDynamicElementElement : childrenDynamicElementElements) {
            this.addDDMFields(childrenDynamicElementElement, ddmStructure, ddmFields, availableLanguageIds, defaultLanguageId);
        }
    }

    protected void addMetadataEntry(Element metadataElement, String name, String value) {
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", name);
        entryElement.addCDATA(value);
    }

    protected void addMissingFieldValues(Field ddmField, String defaultLanguageId, Set<String> missingLanguageIds) {
        if (missingLanguageIds.isEmpty()) {
            return;
        }
        Locale defaultLocale = LocaleUtil.fromLanguageId((String)defaultLanguageId);
        Serializable fieldValue = ddmField.getValue(defaultLocale);
        for (String missingLanguageId : missingLanguageIds) {
            Locale missingLocale = LocaleUtil.fromLanguageId((String)missingLanguageId);
            ddmField.setValue(missingLocale, fieldValue);
        }
    }

    protected int countFieldRepetition(Fields ddmFields, String fieldName, String parentFieldName, int parentOffset) throws Exception {
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String[] fieldsDisplayValues = this.getDDMFieldsDisplayValues(fieldsDisplayField);
        int offset = -1;
        int repetitions = 0;
        for (int i = 0; i < fieldsDisplayValues.length; ++i) {
            String fieldDisplayName = fieldsDisplayValues[i];
            if (offset > parentOffset) break;
            if (fieldDisplayName.equals(parentFieldName)) {
                ++offset;
            }
            if (!fieldDisplayName.equals(fieldName) || offset != parentOffset) continue;
            ++repetitions;
        }
        return repetitions;
    }

    protected String decodeURL(String url) {
        try {
            return HttpUtil.decodeURL((String)url);
        }
        catch (IllegalArgumentException iae) {
            return url;
        }
    }

    protected Element fetchMetadataEntry(Element parentElement, String attributeName, String attributeValue) {
        StringBundler sb = new StringBundler(5);
        sb.append("entry[@");
        sb.append(attributeName);
        sb.append("=");
        sb.append(HtmlUtil.escapeXPathAttribute((String)attributeValue));
        sb.append("]");
        XPath xPathSelector = SAXReaderUtil.createXPath((String)sb.toString());
        return (Element)xPathSelector.selectSingleNode((Object)parentElement);
    }

    protected String getAvailableLocales(Fields ddmFields) {
        Set availableLocales = ddmFields.getAvailableLocales();
        Locale[] availableLocalesArray = new Locale[availableLocales.size()];
        availableLocalesArray = availableLocales.toArray(availableLocalesArray);
        Object[] languageIds = LocaleUtil.toLanguageIds((Locale[])availableLocalesArray);
        return StringUtil.merge((Object[])languageIds);
    }

    protected String[] getDDMFieldsDisplayValues(Field ddmFieldsDisplayField) throws PortalException {
        try {
            String[] values;
            DDMStructure ddmStructure = ddmFieldsDisplayField.getDDMStructure();
            ArrayList<String> fieldsDisplayValues = new ArrayList<String>();
            for (String value : values = this.splitFieldsDisplayValue(ddmFieldsDisplayField)) {
                String fieldName = StringUtil.extractFirst((String)value, (String)"_INSTANCE_");
                if (!ddmStructure.hasField(fieldName)) continue;
                fieldsDisplayValues.add(fieldName);
            }
            return fieldsDisplayValues.toArray(new String[fieldsDisplayValues.size()]);
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
    }

    protected Serializable getDocumentLibraryValue(String url) {
        try {
            FileEntry fileEntry = null;
            if (url.contains("/c/document_library/get_file?") || url.contains("/image/image_gallery?")) {
                fileEntry = this.getFileEntryByOldDocumentLibraryURL(url);
            } else if (url.contains("/documents/")) {
                fileEntry = this.getFileEntryByDocumentLibraryURL(url);
            }
            if (fileEntry == null) {
                return "";
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("groupId", fileEntry.getGroupId());
            jsonObject.put("title", fileEntry.getTitle());
            jsonObject.put("uuid", fileEntry.getUuid());
            jsonObject.put("version", fileEntry.getVersion());
            return jsonObject.toString();
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Error retrieving file entry", (Throwable)e);
            }
            return "";
        }
    }

    protected Field getField(Element dynamicElementElement, DDMStructure ddmStructure, String[] availableLanguageIds, String defaultLanguageId) throws PortalException {
        Field ddmField = new Field();
        ddmField.setDDMStructureId(ddmStructure.getStructureId());
        Locale defaultLocale = null;
        defaultLocale = defaultLanguageId == null ? LocaleUtil.getSiteDefault() : LocaleUtil.fromLanguageId((String)defaultLanguageId);
        ddmField.setDefaultLocale(defaultLocale);
        String name = dynamicElementElement.attributeValue("name");
        ddmField.setName(name);
        String dataType = ddmStructure.getFieldDataType(name);
        String type = ddmStructure.getFieldType(name);
        Set missingLanguageIds = SetUtil.fromArray((Object[])availableLanguageIds);
        missingLanguageIds.remove(defaultLanguageId);
        List dynamicContentElements = dynamicElementElement.elements("dynamic-content");
        for (Element dynamicContentElement : dynamicContentElements) {
            Locale locale = defaultLocale;
            String languageId = dynamicContentElement.attributeValue("language-id");
            if (Validator.isNotNull((String)languageId)) {
                locale = LocaleUtil.fromLanguageId((String)languageId);
                missingLanguageIds.remove(languageId);
            }
            Serializable serializable = this.getFieldValue(dataType, type, dynamicContentElement);
            ddmField.addValue(locale, serializable);
        }
        this.addMissingFieldValues(ddmField, defaultLanguageId, missingLanguageIds);
        return ddmField;
    }

    protected String getFieldInstanceId(Fields ddmFields, String fieldName, int index) {
        String[] fieldsDisplayValues;
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        String prefix = fieldName.concat("_INSTANCE_");
        for (String fieldsDisplayValue : fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())))) {
            if (!fieldsDisplayValue.startsWith(prefix) || --index >= 0) continue;
            return StringUtil.extractLast((String)fieldsDisplayValue, (String)"_INSTANCE_");
        }
        return null;
    }

    protected Serializable getFieldValue(String dataType, String type, Element dynamicContentElement) {
        Object serializable = null;
        if ("ddm-documentlibrary".equals(type)) {
            serializable = this.getDocumentLibraryValue(dynamicContentElement.getText());
        } else if ("ddm-image".equals(type)) {
            if (Validator.isNull((String)dynamicContentElement.getText())) {
                return "";
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            jsonObject.put("alt", dynamicContentElement.attributeValue("alt"));
            jsonObject.put("data", dynamicContentElement.getText());
            jsonObject.put("name", dynamicContentElement.attributeValue("name"));
            jsonObject.put("title", dynamicContentElement.attributeValue("title"));
            jsonObject.put("type", dynamicContentElement.attributeValue("type"));
            serializable = jsonObject.toString();
        } else if ("ddm-link-to-page".equals(type)) {
            Object[] values = StringUtil.split((String)dynamicContentElement.getText(), (char)'@');
            if (ArrayUtil.isEmpty((Object[])values)) {
                return "";
            }
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
            if (values.length > 2) {
                jsonObject.put("groupId", GetterUtil.getLong((String)values[2]));
            }
            jsonObject.put("layoutId", GetterUtil.getLong((String)values[0]));
            if (((String)values[1]).equals("public")) {
                jsonObject.put("privateLayout", false);
            } else {
                jsonObject.put("privateLayout", true);
            }
            serializable = jsonObject.toString();
        } else if ("select".equals(type)) {
            JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
            List optionElements = dynamicContentElement.elements("option");
            if (!optionElements.isEmpty()) {
                for (Element optionElement : optionElements) {
                    jsonArray.put(optionElement.getText());
                }
            } else {
                jsonArray.put(dynamicContentElement.getText());
            }
            serializable = jsonArray.toString();
        } else {
            serializable = FieldConstants.getSerializable((String)dataType, (String)dynamicContentElement.getText());
        }
        return serializable;
    }

    protected FileEntry getFileEntryByDocumentLibraryURL(String url) throws PortalException {
        int x = url.indexOf("/documents/");
        int y = url.indexOf("?");
        if (y == -1) {
            y = url.length();
        }
        url = url.substring(x, y);
        String[] parts = StringUtil.split((String)url, (char)'/');
        long groupId = GetterUtil.getLong((String)parts[2]);
        return this._dlAppLocalService.getFileEntryByUuidAndGroupId(parts[5], groupId);
    }

    protected FileEntry getFileEntryByOldDocumentLibraryURL(String url) throws PortalException {
        Matcher matcher = this._oldDocumentLibraryURLPattern.matcher(url);
        if (!matcher.find()) {
            return null;
        }
        long groupId = GetterUtil.getLong((String)matcher.group(2));
        return this._dlAppLocalService.getFileEntryByUuidAndGroupId(matcher.group(1), groupId);
    }

    protected void getJournalMetadataElement(Element metadataElement) {
        this.removeAttribute(metadataElement, "locale");
        Element dynamicElementElement = metadataElement.getParent();
        boolean required = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("required"));
        this.addMetadataEntry(metadataElement, "required", String.valueOf(required));
        Element tipElement = this.fetchMetadataEntry(metadataElement, "name", "tip");
        if (tipElement != null) {
            tipElement.addAttribute("name", "instructions");
            this.addMetadataEntry(metadataElement, "displayAsTooltip", "true");
        }
    }

    protected void removeAttribute(Element element, String attributeName) {
        Attribute attribute = element.attribute(attributeName);
        if (attribute == null) {
            return;
        }
        element.remove(attribute);
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    protected String[] splitFieldsDisplayValue(Field fieldsDisplayField) {
        String value = (String)((Object)fieldsDisplayField.getValue());
        return StringUtil.split((String)value);
    }

    protected void updateContentDynamicElement(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, DDMFieldsCounter ddmFieldsCounter) throws Exception {
        String fieldName = dynamicElementElement.attributeValue("name");
        for (String childFieldName : ddmStructure.getChildrenFieldNames(fieldName)) {
            int count = ddmFieldsCounter.get((Object)fieldName);
            int repetitions = this.countFieldRepetition(ddmFields, childFieldName, fieldName, count);
            for (int i = 0; i < repetitions; ++i) {
                Element childDynamicElementElement = dynamicElementElement.addElement("dynamic-element");
                childDynamicElementElement.addAttribute("name", childFieldName);
                String instanceId = this.getFieldInstanceId(ddmFields, fieldName, count + i);
                childDynamicElementElement.addAttribute("instance-id", instanceId);
                this.updateContentDynamicElement(childDynamicElementElement, ddmStructure, ddmFields, ddmFieldsCounter);
            }
        }
        this.updateContentDynamicElement(dynamicElementElement, ddmStructure, ddmFields, fieldName, ddmFieldsCounter);
    }

    protected void updateContentDynamicElement(Element dynamicElementElement, DDMStructure ddmStructure, Fields ddmFields, String fieldName, DDMFieldsCounter ddmFieldsCounter) throws Exception {
        String fieldType = ddmStructure.getFieldType(fieldName);
        String indexType = ddmStructure.getFieldProperty(fieldName, "indexType");
        boolean multiple = GetterUtil.getBoolean((String)ddmStructure.getFieldProperty(fieldName, "multiple"));
        String type = this._ddmTypesToJournalTypes.get(fieldType);
        if (type == null) {
            type = fieldType;
        }
        dynamicElementElement.addAttribute("type", type);
        dynamicElementElement.addAttribute("index-type", indexType);
        int count = ddmFieldsCounter.get((Object)fieldName);
        String instanceId = this.getFieldInstanceId(ddmFields, fieldName, count);
        dynamicElementElement.addAttribute("instance-id", instanceId);
        Field ddmField = ddmFields.get(fieldName);
        if (!ddmStructure.isFieldTransient(fieldName) && ddmField != null) {
            for (Locale locale : ddmField.getAvailableLocales()) {
                Element dynamicContentElement = dynamicElementElement.addElement("dynamic-content");
                dynamicContentElement.addAttribute("language-id", LocaleUtil.toLanguageId((Locale)locale));
                Serializable fieldValue = ddmField.getValue(locale, count);
                String valueString = String.valueOf(fieldValue);
                this.updateDynamicContentValue(dynamicContentElement, fieldType, multiple, valueString.trim());
            }
        }
        ddmFieldsCounter.incrementKey((Object)fieldName);
    }

    protected void updateDDMXSDDynamicElement(Element dynamicElementElement, String defaultLanguageId) {
        String[] removableAttributeNames;
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String languageId = metadataElement.attributeValue("locale");
            if (languageId.equals(defaultLanguageId)) {
                this.getJournalMetadataElement(metadataElement);
                continue;
            }
            dynamicElementElement.remove(metadataElement);
        }
        Element parentElement = dynamicElementElement.getParent();
        String parentType = parentElement.attributeValue("type");
        if (Objects.equals(parentType, "list") || Objects.equals(parentType, "multi-list")) {
            Element metadataElement = dynamicElementElement.element("meta-data");
            Element labelElement = this.fetchMetadataEntry(metadataElement, "name", "label");
            dynamicElementElement.addAttribute("name", labelElement.getText());
            String repeatable = parentElement.attributeValue("repeatable");
            dynamicElementElement.addAttribute("repeatable", repeatable);
            String value = dynamicElementElement.attributeValue("value");
            dynamicElementElement.addAttribute("type", value);
            this.removeAttribute(dynamicElementElement, "value");
            dynamicElementElement.remove(metadataElement);
            return;
        }
        String indexType = GetterUtil.getString((String)dynamicElementElement.attributeValue("indexType"));
        this.removeAttribute(dynamicElementElement, "indexType");
        dynamicElementElement.addAttribute("index-type", indexType);
        String type = dynamicElementElement.attributeValue("type");
        boolean multiple = GetterUtil.getBoolean((String)dynamicElementElement.attributeValue("multiple"));
        String newType = this._ddmTypesToJournalTypes.get(type);
        if (newType.equals("list") && multiple) {
            newType = "multi-list";
        }
        dynamicElementElement.addAttribute("type", newType);
        for (String removableAttributeName : removableAttributeNames = new String[]{"dataType", "fieldNamespace", "multiple", "readOnly", "required", "showLabel", "width"}) {
            this.removeAttribute(dynamicElementElement, removableAttributeName);
        }
        List childrenDynamicElementElements = dynamicElementElement.elements("dynamic-element");
        for (Element childrenDynamicElementElement : childrenDynamicElementElements) {
            this.updateDDMXSDDynamicElement(childrenDynamicElementElement, defaultLanguageId);
        }
    }

    protected void updateDynamicContentValue(Element dynamicContentElement, String fieldType, boolean multiple, String fieldValue) throws Exception {
        if ("checkbox".equals(fieldType)) {
            if (fieldValue.equals(Boolean.FALSE.toString())) {
                fieldValue = "";
            }
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("ddm-documentlibrary".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldValue);
            String uuid = jsonObject.getString("uuid");
            long groupId = jsonObject.getLong("groupId");
            FileEntry fileEntry = this._dlAppLocalService.getFileEntryByUuidAndGroupId(uuid, groupId);
            fieldValue = DLUtil.getPreviewURL((FileEntry)fileEntry, (FileVersion)fileEntry.getFileVersion(), null, (String)"", (boolean)false, (boolean)true);
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("ddm-image".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldValue);
            dynamicContentElement.addAttribute("alt", jsonObject.getString("alt"));
            dynamicContentElement.addAttribute("name", jsonObject.getString("name"));
            dynamicContentElement.addAttribute("title", jsonObject.getString("title"));
            dynamicContentElement.addAttribute("type", jsonObject.getString("type"));
            dynamicContentElement.addCDATA(fieldValue);
        } else if ("ddm-link-to-page".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)fieldValue);
            long groupId = jsonObject.getLong("groupId");
            long layoutId = jsonObject.getLong("layoutId");
            boolean privateLayout = jsonObject.getBoolean("privateLayout");
            StringBundler sb = new StringBundler(groupId > 0L ? 5 : 3);
            sb.append(layoutId);
            sb.append("@");
            if (privateLayout) {
                Group group = this._groupLocalService.fetchGroup(groupId);
                if (group == null) {
                    sb.append("private");
                } else if (group.isUser()) {
                    sb.append("private-user");
                } else {
                    sb.append("private-group");
                }
            } else {
                sb.append("public");
            }
            if (groupId > 0L) {
                sb.append("@");
                sb.append(groupId);
            }
            dynamicContentElement.addCDATA(sb.toString());
        } else if ("select".equals(fieldType) && Validator.isNotNull((String)fieldValue)) {
            JSONArray jsonArray = null;
            try {
                jsonArray = JSONFactoryUtil.createJSONArray((String)fieldValue);
            }
            catch (JSONException jsone) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)jsone, (Throwable)jsone);
                }
                return;
            }
            if (multiple) {
                for (int i = 0; i < jsonArray.length(); ++i) {
                    Element optionElement = dynamicContentElement.addElement("option");
                    optionElement.addCDATA(jsonArray.getString(i));
                }
            } else {
                dynamicContentElement.addCDATA(jsonArray.getString(0));
            }
        } else {
            dynamicContentElement.addCDATA(fieldValue);
        }
    }

    protected void updateFieldsDisplay(Fields ddmFields, String fieldName, String instanceId) {
        if (Validator.isNull((String)instanceId)) {
            instanceId = StringUtil.randomString();
        }
        String fieldsDisplayValue = fieldName.concat("_INSTANCE_").concat(instanceId);
        Field fieldsDisplayField = ddmFields.get("_fieldsDisplay");
        Object[] fieldsDisplayValues = StringUtil.split((String)((String)((Object)fieldsDisplayField.getValue())));
        fieldsDisplayValues = (String[])ArrayUtil.append((Object[])fieldsDisplayValues, (Object)fieldsDisplayValue);
        fieldsDisplayField.setValue((Serializable)((Object)StringUtil.merge((Object[])fieldsDisplayValues)));
    }

    protected void updateJournalXSDDynamicElement(Element element) {
        Locale defaultLocale = LocaleUtil.getSiteDefault();
        this.updateJournalXSDDynamicElement(element, LocaleUtil.toLanguageId((Locale)defaultLocale));
    }

    protected void updateJournalXSDDynamicElement(Element element, String defaultLanguageId) {
        String name = element.attributeValue("name");
        String type = element.attributeValue("type");
        Element metadataElement = element.element("meta-data");
        if (metadataElement == null) {
            metadataElement = element.addElement("meta-data");
        }
        if (type.equals("multi-list")) {
            element.addAttribute("multiple", "true");
        } else {
            Element parentElement = element.getParent();
            String parentType = parentElement.attributeValue("type");
            if (parentType != null && parentType.equals("select")) {
                metadataElement.addAttribute("locale", defaultLanguageId);
                this.addMetadataEntry(metadataElement, "label", this.decodeURL(name));
                this.removeAttribute(element, "index-type");
                element.addAttribute("name", "option" + parentElement.attributeValue("name") + StringUtil.randomString((int)8));
                element.addAttribute("type", "option");
                element.addAttribute("value", this.decodeURL(type));
                return;
            }
        }
        String indexType = "";
        Attribute indexTypeAttribute = element.attribute("index-type");
        if (indexTypeAttribute != null) {
            indexType = indexTypeAttribute.getValue();
            element.remove(indexTypeAttribute);
        }
        element.remove(element.attribute("type"));
        if (!type.equals("selection_break")) {
            String dataType = this._ddmDataTypes.get(type);
            if (dataType == null) {
                dataType = "string";
            }
            element.addAttribute("dataType", dataType);
        }
        element.addAttribute("indexType", indexType);
        String required = "false";
        Element requiredElement = this.fetchMetadataEntry(metadataElement, "name", "required");
        if (requiredElement != null) {
            required = requiredElement.getText();
        }
        element.addAttribute("required", required);
        element.addAttribute("showLabel", "true");
        String newType = this._journalTypesToDDMTypes.get(type);
        if (newType == null) {
            newType = type;
        }
        element.addAttribute("type", newType);
        if (newType.startsWith("ddm")) {
            element.addAttribute("fieldNamespace", "ddm");
        }
        metadataElement.addAttribute("locale", defaultLanguageId);
        List entryElements = metadataElement.elements();
        if (entryElements.isEmpty()) {
            this.addMetadataEntry(metadataElement, "label", name);
        } else {
            for (Element entryElement : entryElements) {
                String oldEntryName = entryElement.attributeValue("name");
                String newEntryName = this._ddmMetadataAttributes.get(oldEntryName);
                if (newEntryName == null) {
                    metadataElement.remove(entryElement);
                    continue;
                }
                entryElement.addAttribute("name", newEntryName);
            }
        }
        if (newType.equals("ddm-date") || newType.equals("ddm-decimal") || newType.equals("ddm-integer") || newType.equals("ddm-link-to-page") || newType.equals("ddm-number") || newType.equals("ddm-text-html") || newType.equals("text") || newType.equals("textarea")) {
            element.addAttribute("width", "25");
        } else if (newType.equals("ddm-image")) {
            element.addAttribute("fieldNamespace", "ddm");
            element.addAttribute("readOnly", "false");
        }
        element.add(metadataElement.detach());
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateJournalXSDDynamicElement(dynamicElementElement, defaultLanguageId);
        }
    }
}

