/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.verify;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalArticleResource;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalArticleResourceLocalService;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.SystemEvent;
import com.liferay.portal.kernel.service.SystemEventLocalService;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class JournalServiceSystemEventVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(JournalServiceSystemEventVerifyProcess.class);
    private final JournalArticleLocalService _journalArticleLocalService;
    private final JournalArticleResourceLocalService _journalArticleResourceLocalService;
    private final SystemEventLocalService _systemEventLocalService;

    @Deprecated
    public JournalServiceSystemEventVerifyProcess() {
        this._journalArticleLocalService = null;
        this._journalArticleResourceLocalService = null;
        this._systemEventLocalService = null;
    }

    public JournalServiceSystemEventVerifyProcess(JournalArticleLocalService journalArticleLocalService, JournalArticleResourceLocalService journalArticleResourceLocalService, SystemEventLocalService systemEventLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
        this._journalArticleResourceLocalService = journalArticleResourceLocalService;
        this._systemEventLocalService = systemEventLocalService;
    }

    protected void doVerify() throws Exception {
        this.verifyJournalArticleDeleteSystemEvents();
    }

    @Deprecated
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
    }

    @Deprecated
    protected void setJournalArticleResourceLocalService(JournalArticleResourceLocalService journalArticleResourceLocalService) {
    }

    @Deprecated
    protected void setSystemEventLocalService(SystemEventLocalService systemEventLocalService) {
    }

    protected void verifyJournalArticleDeleteSystemEvents() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            DynamicQuery dynamicQuery = this._systemEventLocalService.dynamicQuery();
            Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
            dynamicQuery.add(classNameIdProperty.eq((Object)PortalUtil.getClassNameId(JournalArticle.class)));
            Property typeProperty = PropertyFactoryUtil.forName((String)"type");
            dynamicQuery.add(typeProperty.eq((Object)1));
            List systemEvents = this._systemEventLocalService.dynamicQuery(dynamicQuery);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Processing " + systemEvents.size() + " delete system events for journal articles"));
            }
            for (SystemEvent systemEvent : systemEvents) {
                JournalArticle journalArticle;
                JournalArticleResource journalArticleResource;
                JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject((String)systemEvent.getExtraData());
                if (extraDataJSONObject.has("uuid") || !extraDataJSONObject.has("version") || (journalArticleResource = this._journalArticleResourceLocalService.fetchJournalArticleResourceByUuidAndGroupId(systemEvent.getClassUuid(), systemEvent.getGroupId())) == null || (journalArticle = this._journalArticleLocalService.fetchArticle(systemEvent.getGroupId(), journalArticleResource.getArticleId(), extraDataJSONObject.getDouble("version"))) == null || journalArticle.isInTrash()) continue;
                this._systemEventLocalService.deleteSystemEvent(systemEvent);
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Delete system events verified for journal articles");
            }
        }
    }
}

