/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.workflow;

import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.model.JournalFolder;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.journal.service.JournalFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={WorkflowHandler.class})
public class JournalArticleWorkflowHandler
extends BaseWorkflowHandler<JournalArticle> {
    private static final boolean _VISIBLE = false;
    private DDMStructureLocalService _ddmStructureLocalService;
    private JournalArticleLocalService _journalArticleLocalService;
    private JournalFolderLocalService _journalFolderLocalService;
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    public String getClassName() {
        return JournalArticle.class.getName();
    }

    public String getType(Locale locale) {
        return ResourceActionsUtil.getModelResource((Locale)locale, (String)this.getClassName());
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        JournalArticle article = this._journalArticleLocalService.getArticle(classPK);
        long folderId = this._journalFolderLocalService.getInheritedWorkflowFolderId(article.getFolderId());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(article.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class), article.getDDMStructureKey(), true);
        WorkflowDefinitionLink workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, JournalFolder.class.getName(), folderId, ddmStructure.getStructureId(), true);
        if (workflowDefinitionLink == null) {
            workflowDefinitionLink = this._workflowDefinitionLinkLocalService.fetchWorkflowDefinitionLink(companyId, groupId, JournalFolder.class.getName(), folderId, -1L, true);
        }
        return workflowDefinitionLink;
    }

    public boolean isVisible() {
        return false;
    }

    public JournalArticle updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        JournalArticle article = this._journalArticleLocalService.getArticle(classPK);
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        String articleURL = PortalUtil.getControlPanelFullURL((long)serviceContext.getScopeGroupId(), (String)PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT), null);
        return this._journalArticleLocalService.updateStatus(userId, article, status, articleURL, serviceContext, workflowContext);
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalArticleLocalService(JournalArticleLocalService journalArticleLocalService) {
        this._journalArticleLocalService = journalArticleLocalService;
    }

    @Reference(unbind="-")
    protected void setJournalFolderLocalService(JournalFolderLocalService journalFolderLocalService) {
        this._journalFolderLocalService = journalFolderLocalService;
    }

    @Reference(unbind="-")
    protected void setWorkflowDefinitionLinkLocalService(WorkflowDefinitionLinkLocalService workflowDefinitionLinkLocalService) {
        this._workflowDefinitionLinkLocalService = workflowDefinitionLinkLocalService;
    }
}

