/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.journal.atom;

import com.liferay.journal.model.JournalArticle;
import com.liferay.journal.service.JournalArticleService;
import com.liferay.journal.util.comparator.ArticleVersionComparator;
import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.journal.model.JournalArticle"}, service={AtomCollectionAdapter.class})
public class JournalArticleAtomCollectionProvider
extends BaseAtomCollectionAdapter<JournalArticle> {
    private static final String _COLLECTION_NAME = "web-content";
    private JournalArticleService _journalArticleService;

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(JournalArticle journalArticle) {
        return ListUtil.fromArray((Object[])new String[]{journalArticle.getUserName()});
    }

    public AtomEntryContent getEntryContent(JournalArticle journalArticle, AtomRequestContext atomRequestContext) {
        return new AtomEntryContent(journalArticle.getContent(), AtomEntryContent.Type.XML);
    }

    public String getEntryId(JournalArticle journalArticle) {
        return journalArticle.getArticleId();
    }

    public String getEntrySummary(JournalArticle entry) {
        return null;
    }

    public String getEntryTitle(JournalArticle journalArticle) {
        return journalArticle.getTitle();
    }

    public Date getEntryUpdated(JournalArticle journalArticle) {
        return journalArticle.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        String portletId = PortletProviderUtil.getPortletId((String)JournalArticle.class.getName(), (PortletProvider.Action)PortletProvider.Action.EDIT);
        return AtomUtil.createFeedTitleFromPortletName((AtomRequestContext)atomRequestContext, (String)portletId);
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        String articleId = resourceName;
        ServiceContext serviceContext = new ServiceContext();
        this._journalArticleService.deleteArticle(groupId, articleId, null, serviceContext);
    }

    protected JournalArticle doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        String articleId = resourceName;
        return this._journalArticleService.getArticle(groupId, articleId);
    }

    protected Iterable<JournalArticle> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        ArrayList<JournalArticle> journalArticles = new ArrayList<JournalArticle>();
        long companyId = CompanyThreadLocal.getCompanyId();
        long groupId = atomRequestContext.getLongParameter("groupId");
        if (companyId <= 0L || groupId <= 0L) {
            return journalArticles;
        }
        List folderIds = Collections.emptyList();
        long classNameId = 0L;
        String keywords = null;
        Double version = null;
        String ddmStructureKey = null;
        String ddmTemplateKey = null;
        Date displayDateGT = null;
        Date displayDateLT = new Date();
        int status = 0;
        Date reviewDate = null;
        ArticleVersionComparator obc = new ArticleVersionComparator();
        int count = this._journalArticleService.searchCount(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate);
        AtomPager atomPager = new AtomPager(atomRequestContext, count);
        AtomUtil.saveAtomPagerInRequest((AtomRequestContext)atomRequestContext, (AtomPager)atomPager);
        return this._journalArticleService.search(companyId, groupId, folderIds, classNameId, keywords, version, ddmStructureKey, ddmTemplateKey, displayDateGT, displayDateLT, status, reviewDate, atomPager.getStart(), atomPager.getEnd() + 1, (OrderByComparator)obc);
    }

    protected JournalArticle doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        long folderId = 0L;
        long classNameId = 0L;
        long classPK = 0L;
        String articleId = "";
        boolean autoArticleId = true;
        Locale locale = LocaleUtil.getDefault();
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        titleMap.put(locale, title);
        HashMap descriptionMap = new HashMap();
        String ddmStructureKey = null;
        String ddmTemplateKey = null;
        String layoutUuid = null;
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        int expirationDateMonth = 0;
        int expirationDateDay = 0;
        int expirationDateYear = 0;
        int expirationDateHour = 0;
        int expirationDateMinute = 0;
        boolean neverExpire = true;
        int reviewDateMonth = 0;
        int reviewDateDay = 0;
        int reviewDateYear = 0;
        int reviewDateHour = 0;
        int reviewDateMinute = 0;
        boolean neverReview = true;
        boolean indexable = true;
        String articleURL = "";
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(false);
        serviceContext.setAddGuestPermissions(false);
        serviceContext.setScopeGroupId(groupId);
        JournalArticle journalArticle = this._journalArticleService.addArticle(groupId, folderId, classNameId, classPK, articleId, autoArticleId, titleMap, descriptionMap, content, ddmStructureKey, ddmTemplateKey, layoutUuid, displayDateMonth, displayDateDay, displayDateYear, displayDateHour, displayDateMinute, expirationDateMonth, expirationDateDay, expirationDateYear, expirationDateHour, expirationDateMinute, neverExpire, reviewDateMonth, reviewDateDay, reviewDateYear, reviewDateHour, reviewDateMinute, neverReview, indexable, articleURL, serviceContext);
        double version = journalArticle.getVersion();
        int status = 0;
        return this._journalArticleService.updateStatus(groupId, journalArticle.getArticleId(), version, status, articleURL, serviceContext);
    }

    protected void doPutEntry(JournalArticle journalArticle, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = journalArticle.getGroupId();
        long folderId = journalArticle.getFolderId();
        String articleId = journalArticle.getArticleId();
        double version = journalArticle.getVersion();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setScopeGroupId(groupId);
        journalArticle = this._journalArticleService.updateArticle(groupId, folderId, articleId, version, content, serviceContext);
        int status = 0;
        String articleURL = "";
        this._journalArticleService.updateStatus(groupId, journalArticle.getArticleId(), journalArticle.getVersion(), status, articleURL, serviceContext);
    }

    @Reference(unbind="-")
    protected void setJournalArticleService(JournalArticleService journalArticleService) {
        this._journalArticleService = journalArticleService;
    }
}

